/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HelpPopup
extends JDialog {
    private final String payload;
    private JTextArea helpText;
    private JScrollPane jScrollPane1;

    public HelpPopup(Frame parent, String helpText) {
        super(parent, false);
        this.payload = helpText;
        this.initComponents();
        this.helpText.setCaretPosition(0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.helpText = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Help");
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpPopup.this.formMouseClicked(evt);
            }
        });
        this.jScrollPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.helpText.setEditable(false);
        this.helpText.setColumns(20);
        this.helpText.setFont(new Font("Lucida Bright", 0, 14));
        this.helpText.setLineWrap(true);
        this.helpText.setRows(4);
        this.helpText.setText(this.payload);
        this.helpText.setToolTipText("Press mouse button 2 or 3 to close window.");
        this.helpText.setWrapStyleWord(true);
        this.helpText.setBorder(BorderFactory.createBevelBorder(1));
        this.helpText.setMargin(new Insets(0, 10, 0, 0));
        this.helpText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpPopup.this.formMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.helpText);
        this.helpText.getAccessibleContext().setAccessibleDescription("Press mouse button 2 or 3 to close window");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 527, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 280, Short.MAX_VALUE));
        this.pack();
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            this.dispose();
        }
    }

    public static HelpPopup newHelpPopup(Frame parent, String helpText) {
        HelpPopup helpBox = new HelpPopup(parent, helpText);
        Rectangle parentCoords = parent.getBounds();
        Rectangle myCoords = helpBox.getBounds();
        myCoords.x = parentCoords.x + parentCoords.width;
        myCoords.y = parentCoords.y;
        helpBox.setBounds(myCoords);
        helpBox.setVisible(true);
        return helpBox;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpPopup dialog = new HelpPopup((Frame)new JFrame(), "The best defense against logic is ignorance.");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

