/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.harctoolbox.guicomponents.CopyPastePopupMenu;
import org.harctoolbox.guicomponents.HarcPanel;
import org.harctoolbox.guicomponents.StatusLine;

public class HexCalculator
extends HarcPanel {
    private static final String versionString = "0.3.0";
    private static final String helpText = "This pane computes, for a number given in first row either as decimal or hexadecimal\nits (one-) complement (in 8, 16, or 32 bits), its \"reverse\" (java.lang.Integer.reverse()):\nthe value obtained by reversing the order of the bits in the two's complement binary\nrepresentation of the specified int value).";
    private static final String aboutText = "HexCalculator version 0.3.0.\nCopyright 2012, 2013, 2014 by Bengt Martensson.\n\nLicense: GPL3.\n\nProject home page: http://www.harctoolbox.org";
    private static final String invalidString = "****";
    private JTextField complementDecimalTextField;
    private JTextField complementHexTextField;
    private CopyPastePopupMenu copyPastePopupMenu;
    private CopyPastePopupMenu copyPopupMenu;
    private JTextField decimalTextField;
    private JTextField hexTextField;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField reverseComplementDecimalTextField;
    private JTextField reverseComplementHexTextField;
    private JTextField reverseDecimalTextField;
    private JTextField reverseHexTextField;
    private StatusLine statusLine;

    public HexCalculator() {
        this.initComponents();
    }

    @Override
    public String getHelpMessage() {
        return helpText;
    }

    @Override
    public String getAboutMessage() {
        return aboutText;
    }

    @Override
    public String getProgName() {
        return "HexCalculator";
    }

    @Override
    public String getIconPath() {
        return "/icons/Crystal-Clear/22x22/apps/calc.png";
    }

    private String hexFormat(int noBytes, long x) {
        String hexFormat = "%0" + 2 * noBytes + "X";
        return String.format(hexFormat, x);
    }

    private void updateHexcalc(long in, int noBytes) {
        long comp = (1L << 8 * noBytes) - 1L;
        long rev = Long.reverse(in) >> 64 - 8 * noBytes & comp;
        this.complementDecimalTextField.setText(Long.toString(comp - in));
        this.complementHexTextField.setText(this.hexFormat(noBytes, comp - in));
        this.reverseDecimalTextField.setText(Long.toString(rev));
        this.reverseHexTextField.setText(this.hexFormat(noBytes, rev));
        this.reverseComplementHexTextField.setText(this.hexFormat(noBytes, comp - rev));
        this.reverseComplementDecimalTextField.setText(Long.toString(comp - rev));
        this.statusLine.setStatus(null);
    }

    private void hexcalcSillyNumber(String str) {
        if (this.complementDecimalTextField.getText().equalsIgnoreCase(invalidString)) {
            return;
        }
        this.complementDecimalTextField.setText(invalidString);
        this.complementHexTextField.setText(invalidString);
        this.reverseDecimalTextField.setText(invalidString);
        this.reverseHexTextField.setText(invalidString);
        this.reverseComplementDecimalTextField.setText(invalidString);
        this.reverseComplementHexTextField.setText(invalidString);
        this.statusLine.setStatus(str);
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initComponents() {
        this.copyPastePopupMenu = new CopyPastePopupMenu(true);
        this.copyPopupMenu = new CopyPastePopupMenu();
        this.hexTextField = new JTextField();
        this.reverseDecimalTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.complementDecimalTextField = new JTextField();
        this.reverseComplementHexTextField = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel6 = new JLabel();
        this.reverseHexTextField = new JTextField();
        this.reverseComplementDecimalTextField = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel9 = new JLabel();
        this.decimalTextField = new JTextField();
        this.complementHexTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.statusLine = new StatusLine();
        this.hexTextField.setHorizontalAlignment(4);
        this.hexTextField.setText("00");
        this.hexTextField.setToolTipText("Enter hexadecimal number here, then press return.");
        this.hexTextField.setMinimumSize(new Dimension(100, 27));
        this.hexTextField.setPreferredSize(new Dimension(100, 27));
        this.hexTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.hexTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.hexTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.hexTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexCalculator.this.hexTextFieldActionPerformed(evt);
            }
        });
        this.hexTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HexCalculator.this.hexTextFieldFocusLost(evt);
            }
        });
        this.reverseDecimalTextField.setEditable(false);
        this.reverseDecimalTextField.setHorizontalAlignment(4);
        this.reverseDecimalTextField.setText("0");
        this.reverseDecimalTextField.setPreferredSize(new Dimension(100, 27));
        this.reverseDecimalTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.reverseDecimalTextFieldgenericCopyMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.reverseDecimalTextFieldgenericCopyMenu1(evt);
            }
        });
        this.jLabel8.setText("Complement");
        this.jLabel8.setToolTipText("(One) complement: all bits inverted.");
        this.complementDecimalTextField.setEditable(false);
        this.complementDecimalTextField.setHorizontalAlignment(4);
        this.complementDecimalTextField.setText("255");
        this.complementDecimalTextField.setPreferredSize(new Dimension(100, 27));
        this.complementDecimalTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.complementDecimalTextFieldgenericCopyMenu(evt);
            }
        });
        this.reverseComplementHexTextField.setEditable(false);
        this.reverseComplementHexTextField.setHorizontalAlignment(4);
        this.reverseComplementHexTextField.setText("FF");
        this.reverseComplementHexTextField.setPreferredSize(new Dimension(100, 27));
        this.reverseComplementHexTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.reverseComplementHexTextFieldgenericCopyMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.reverseComplementHexTextFieldgenericCopyMenu1(evt);
            }
        });
        this.jLabel14.setText("LSB");
        this.jLabel14.setToolTipText("Result with the reverse bit order (LSB: least significant bit (first)).");
        this.jLabel6.setText("Decimal");
        this.reverseHexTextField.setEditable(false);
        this.reverseHexTextField.setHorizontalAlignment(4);
        this.reverseHexTextField.setText("00");
        this.reverseHexTextField.setMinimumSize(new Dimension(100, 27));
        this.reverseHexTextField.setPreferredSize(new Dimension(100, 27));
        this.reverseHexTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.reverseHexTextFieldgenericCopyMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.reverseHexTextFieldgenericCopyMenu1(evt);
            }
        });
        this.reverseComplementDecimalTextField.setEditable(false);
        this.reverseComplementDecimalTextField.setHorizontalAlignment(4);
        this.reverseComplementDecimalTextField.setText("255");
        this.reverseComplementDecimalTextField.setPreferredSize(new Dimension(100, 27));
        this.reverseComplementDecimalTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.reverseComplementDecimalTextFieldgenericCopyMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.reverseComplementDecimalTextFieldgenericCopyMenu1(evt);
            }
        });
        this.jLabel15.setText("LSB-Compl.");
        this.jLabel15.setToolTipText("All bits inverted, in the reverse order.");
        this.jLabel9.setText("Input");
        this.decimalTextField.setHorizontalAlignment(4);
        this.decimalTextField.setText("0");
        this.decimalTextField.setToolTipText("Enter decimal number here, then press return.");
        this.decimalTextField.setMinimumSize(new Dimension(100, 27));
        this.decimalTextField.setPreferredSize(new Dimension(100, 27));
        this.decimalTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.decimalTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.decimalTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.decimalTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HexCalculator.this.decimalTextFieldActionPerformed(evt);
            }
        });
        this.decimalTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                HexCalculator.this.decimalTextFieldFocusLost(evt);
            }
        });
        this.complementHexTextField.setEditable(false);
        this.complementHexTextField.setHorizontalAlignment(4);
        this.complementHexTextField.setText("FF");
        this.complementHexTextField.setMinimumSize(new Dimension(100, 27));
        this.complementHexTextField.setPreferredSize(new Dimension(100, 27));
        this.complementHexTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                HexCalculator.this.complementHexTextFieldgenericCopyMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                HexCalculator.this.complementHexTextFieldgenericCopyMenu1(evt);
            }
        });
        this.jLabel7.setText("Hex");
        this.statusLine.setText("statusLine");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel8).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.reverseComplementDecimalTextField, -1, -1, Short.MAX_VALUE).addComponent(this.reverseDecimalTextField, -1, -1, Short.MAX_VALUE).addComponent(this.complementDecimalTextField, -1, -1, Short.MAX_VALUE).addComponent(this.decimalTextField, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.hexTextField, GroupLayout.Alignment.TRAILING, -1, 168, Short.MAX_VALUE).addComponent(this.complementHexTextField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.reverseHexTextField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.reverseComplementHexTextField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusLine, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel7)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.decimalTextField, -2, -1, -2).addComponent(this.hexTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.complementDecimalTextField, -2, -1, -2).addComponent(this.complementHexTextField, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reverseDecimalTextField, -2, -1, -2).addComponent(this.reverseHexTextField, -2, -1, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reverseComplementDecimalTextField, -2, -1, -2).addComponent(this.reverseComplementHexTextField, -2, -1, -2).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLine, -2, -1, -2).addContainerGap()));
    }

    private void hexTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void hexTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void hexTextFieldActionPerformed(ActionEvent evt) {
        try {
            long in = Long.parseLong(this.hexTextField.getText(), 16);
            if (in > 0xFFFFFFFFL) {
                this.decimalTextField.setText(invalidString);
                this.hexcalcSillyNumber("Number too large");
                return;
            }
            int noBytes = this.hexTextField.getText().length() <= 2 ? 1 : (this.hexTextField.getText().length() <= 4 ? 2 : 4);
            this.hexTextField.setText(this.hexFormat(noBytes, in));
            this.decimalTextField.setText(Long.toString(in));
            this.updateHexcalc(in, noBytes);
        }
        catch (NumberFormatException e) {
            this.decimalTextField.setText("*");
            this.hexcalcSillyNumber("Parse error: " + e.getMessage());
        }
    }

    private void hexTextFieldFocusLost(FocusEvent evt) {
        this.hexTextFieldActionPerformed(null);
    }

    private void reverseDecimalTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseDecimalTextFieldgenericCopyMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void complementDecimalTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseComplementHexTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseComplementHexTextFieldgenericCopyMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseHexTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseHexTextFieldgenericCopyMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseComplementDecimalTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void reverseComplementDecimalTextFieldgenericCopyMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void decimalTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void decimalTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void decimalTextFieldActionPerformed(ActionEvent evt) {
        try {
            long in = Long.parseLong(this.decimalTextField.getText());
            if (in > 0xFFFFFFFFL) {
                this.hexTextField.setText(invalidString);
                this.hexcalcSillyNumber("Number too large");
                return;
            }
            int noBytes = in < 256L && this.decimalTextField.getText().length() <= 3 ? 1 : (in < 65536L && this.decimalTextField.getText().length() <= 5 ? 2 : 4);
            this.hexTextField.setText(this.hexFormat(noBytes, in));
            this.updateHexcalc(in, noBytes);
        }
        catch (NumberFormatException e) {
            this.hexTextField.setText("*");
            this.hexcalcSillyNumber("Parse error: " + e.getMessage());
        }
    }

    private void decimalTextFieldFocusLost(FocusEvent evt) {
        this.decimalTextFieldActionPerformed(null);
    }

    private void complementHexTextFieldgenericCopyMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void complementHexTextFieldgenericCopyMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

