/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.IHarcHardware;

public class InternetHostPanel
extends JPanel {
    public static final String PROP_IP_NAME = "ipName";
    public static final String PROP_PORT_NUMBER = "portNumber";
    public static final String PROP_READY = "PROP_READY";
    public static final String PROP_VERSION = "PROP_VERSION";
    public static final String PROP_ISOPEN = "PROP_ISOPEN";
    public static final int defaultPingTimeout = 5000;
    public static final String defaultIpName = "localhost";
    public static final int defaultPortNumber = 8765;
    private int pingTimeout = 5000;
    private boolean usePort;
    private boolean usePing;
    private boolean useBrowse;
    private String ipName;
    private int portNumber;
    private boolean ready;
    private String version;
    private GuiUtils guiUtils;
    private transient IHarcHardware hardware;
    private boolean listenable;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JButton browseButton;
    private JTextField ipNameTextField;
    private JLabel jLabel1;
    private JButton pingButton;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel versionLabel;
    private JLabel versionLiteralLabel;

    public InternetHostPanel() {
        this(null, true, true, true);
    }

    public InternetHostPanel(GuiUtils guiUtils, boolean usePort, boolean usePing, boolean useBrowse) {
        this.guiUtils = guiUtils;
        this.useBrowse = useBrowse;
        this.usePing = usePing;
        this.usePort = usePort;
        this.ipName = defaultIpName;
        this.portNumber = 8765;
        this.ready = false;
        this.initComponents();
        this.setUsePort(usePort);
        this.portTextField.setEnabled(usePort);
        this.pingButton.setEnabled(usePing);
        this.browseButton.setEnabled(useBrowse);
    }

    public final void setUsePort(boolean value) {
        this.usePort = value;
        this.portTextField.setEnabled(value);
        this.portLabel.setText(value ? "Port" : null);
    }

    public boolean getUsePort() {
        return this.usePort;
    }

    public String getIpName() {
        return this.ipName;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        boolean oldReady = this.ready;
        this.ready = ready;
        this.propertyChangeSupport.firePropertyChange(PROP_READY, oldReady, ready);
    }

    public final void setIpName(String name) {
        if (name == null || name.equals(this.ipName)) {
            return;
        }
        String oldIpName = this.ipName;
        this.ipName = name;
        this.ipNameTextField.setText(name);
        this.propertyChangeSupport.firePropertyChange(PROP_IP_NAME, oldIpName, name);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public final void setPortNumber(int value) {
        int oldPortNumber = this.portNumber;
        this.portNumber = value;
        this.portTextField.setText(Integer.toString(value));
        if (this.usePort) {
            this.propertyChangeSupport.firePropertyChange(PROP_PORT_NUMBER, oldPortNumber, value);
        }
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(int val) {
        this.pingTimeout = val;
    }

    public void setGuiUtils(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
    }

    public boolean isPingable() {
        boolean success = false;
        String host = this.getIpName();
        try {
            success = InetAddress.getByName(host).isReachable(this.pingTimeout);
            this.guiUtils.info(host + (success ? " is reachable" : " is not reachable (using Java's isReachable)"));
        }
        catch (IOException ex) {
            this.guiUtils.info(host + " is not reachable (using Java's isReachable): " + ex.getMessage());
        }
        return success;
    }

    public void testPing() {
        boolean result = this.isPingable();
        System.err.println(result);
    }

    public void setHardware(IHarcHardware hardware) throws IOException {
        this.hardware = hardware;
        this.setVersion();
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion() throws IOException {
        try {
            this.setVersion(this.hardware.isValid() ? this.hardware.getVersion() : "<not connected>");
        }
        catch (IOException ex) {
            this.versionLabel.setText("<invalid>");
            this.version = null;
            throw ex;
        }
    }

    public void setVersion(String version) {
        String oldVersion = this.version;
        this.version = version;
        this.versionLabel.setText(version);
        this.versionLabel.setEnabled(true);
        this.versionLiteralLabel.setEnabled(true);
        this.propertyChangeSupport.firePropertyChange(PROP_VERSION, oldVersion, version);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.ipNameTextField = new JTextField();
        this.portTextField = new JTextField();
        this.browseButton = new JButton();
        this.pingButton = new JButton();
        this.jLabel1 = new JLabel();
        this.portLabel = new JLabel();
        this.versionLiteralLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.ipNameTextField.setText(this.getIpName());
        this.ipNameTextField.setToolTipText("IP-Name or -address of host");
        this.ipNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetHostPanel.this.ipNameTextFieldActionPerformed(evt);
            }
        });
        this.portTextField.setText(Integer.toString(this.getPortNumber()));
        this.portTextField.setToolTipText("Portnumber");
        this.portTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetHostPanel.this.portTextFieldActionPerformed(evt);
            }
        });
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/browser.png")));
        this.browseButton.setMnemonic('B');
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("Browse WWW server at host");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetHostPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.pingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/bell.png")));
        this.pingButton.setMnemonic('P');
        this.pingButton.setText("Ping");
        this.pingButton.setToolTipText("Try to ping host");
        this.pingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternetHostPanel.this.pingButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("IP Name/Address");
        this.portLabel.setText("Port");
        this.versionLiteralLabel.setText("Ver:");
        this.versionLiteralLabel.setToolTipText("Version of the firmware on the device, if supported by the device. Verifies that the connection is working.");
        this.versionLiteralLabel.setEnabled(false);
        this.versionLabel.setText("no version available");
        this.versionLabel.setToolTipText("Version of firmware on device. Verifies the connection.");
        this.versionLabel.setBorder(new SoftBevelBorder(1));
        this.versionLabel.setEnabled(false);
        this.versionLabel.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.ipNameTextField, -2, 138, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portLabel).addComponent(this.portTextField, -2, 56, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pingButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLiteralLabel, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel, -1, 236, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.portLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ipNameTextField, -2, -1, -2).addComponent(this.portTextField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.pingButton).addComponent(this.versionLiteralLabel).addComponent(this.versionLabel)).addContainerGap(23, Short.MAX_VALUE)));
        layout.linkSize(1, this.browseButton, this.ipNameTextField, this.pingButton, this.portTextField);
    }

    private void ipNameTextFieldActionPerformed(ActionEvent evt) {
        String name = this.ipNameTextField.getText();
        try {
            InetAddress.getByName(name);
            this.setIpName(name);
        }
        catch (UnknownHostException ex) {
            this.guiUtils.warning(name + " does not resolve.");
        }
    }

    private void portTextFieldActionPerformed(ActionEvent evt) {
        try {
            int val = Integer.parseInt(this.portTextField.getText());
            this.setPortNumber(val);
        }
        catch (NumberFormatException ex) {
            this.guiUtils.error("Cannot parse " + this.portTextField.getText());
            this.portTextField.setText(Integer.toString(this.portNumber));
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.ipName = this.ipNameTextField.getText();
        try {
            Desktop.getDesktop().browse(URI.create("http://" + this.getIpName()));
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void pingButtonActionPerformed(ActionEvent evt) {
        this.isPingable();
    }
}

