/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.guicomponents.HarcPanel;
import org.harctoolbox.guicomponents.HarcletFrame;

public class IrPlotter
extends HarcPanel {
    private static final String versionString = "0.1.0";
    private static final String helpText = "This window shows a frozen copy of a signal originally shown in the plot window of IrScrutinizer.";
    private static final String aboutText = "IrPlotter version 0.1.0.\nCopyright 2013-2015 by Bengt Martensson.\n\nLicense: GPL3.\n\nProject home page: http://www.harctoolbox.org";
    private int xmin = 0;
    private int xmax = 200000;
    private int[] irdata = null;
    private int noIntroBursts;
    private int noRepeatBursts;
    private int noRepeats;
    private int onY;
    private int offY;
    private int dragBeginX = -1;
    private int dragEndX = -1;
    private JMenu plotterWidthsMenu;
    private JPopupMenu plotterPopupMenu;
    private static final int topMargin = 10;
    private static final int bottomMargin = 40;
    private static final int leftMargin = 15;
    private static final int rightMargin = 15;
    private static final int tickBarLength = 10;
    private static final int charWidth = 8;
    private static final int numberOffset = 30;
    private static final int pixelsPerTick = 75;
    private static final int preferredWidth = 400;
    private static final int preferredHeight = 50;
    private static final int dragThreshold = 20;
    private static final Color plotBackgroundColor = Color.WHITE;
    private static final Color plotDraggingBackgroundColor = Color.DARK_GRAY;
    private static final Color tickMarkColor = Color.GRAY;
    private static final Color numberColor = Color.BLACK;
    private static final Color introColor = Color.RED;
    private static final Color repeatColor = Color.BLUE;
    private static final Color endingColor = Color.GREEN;
    private boolean usePulseAsTiming = false;
    private boolean ignoreLast = false;
    private double frequency;
    private boolean useMilliSeconds = false;
    private static final int invalid = -1;
    private final int[] plotterWidths = new int[]{1000, 1500, 2000, 2500, 3000, 4000, 5000, 6000, 7000, 8000, 10000};

    public IrPlotter(boolean zoomSupport) {
        this.initializePlotterWidthsMenu();
        this.initializePlotterMenu();
        if (zoomSupport) {
            this.initializeMouse();
        }
    }

    public IrPlotter() {
        this(true);
    }

    public IrPlotter(IrPlotter irPlotter, boolean zoomSupport) {
        this(zoomSupport);
        this.noIntroBursts = irPlotter.noIntroBursts;
        this.noRepeatBursts = irPlotter.noRepeatBursts;
        this.noRepeats = irPlotter.noRepeats;
        this.irdata = new int[irPlotter.irdata.length];
        System.arraycopy(irPlotter.irdata, 0, this.irdata, 0, irPlotter.irdata.length);
        this.frequency = irPlotter.frequency;
        this.ignoreLast = irPlotter.ignoreLast;
        this.xmin = irPlotter.xmin;
        this.xmax = irPlotter.xmax;
    }

    private void plot(int[] irdata, int noIntroBursts, int noRepeatBursts, int noRepeats, double frequency) {
        this.noIntroBursts = noIntroBursts;
        this.noRepeatBursts = noRepeatBursts;
        this.noRepeats = noRepeats;
        this.irdata = irdata;
        this.frequency = frequency;
        this.resetXminXmax();
    }

    public void plot(ModulatedIrSequence irSequence, int noIntroBursts, int noRepeatBursts, int noRepetitions) {
        this.plot(irSequence.toInts(), noIntroBursts, noRepeatBursts, noRepetitions, irSequence.getFrequency());
        this.repaint();
    }

    public void plot(ModulatedIrSequence irSequence) {
        this.plot(irSequence, irSequence.getNumberBursts(), 0, 0);
    }

    public void plot(IrSignal irSignal) {
        this.plot(irSignal.toModulatedIrSequence(true, 1, true), irSignal.getIntroBursts(), irSignal.getRepeatBursts(), 1);
    }

    public void clear() {
        this.plot(null, 0, 0, 0, 0.0);
        this.reset();
    }

    public boolean isEmpty() {
        return this.irdata == null || this.irdata.length == 0;
    }

    public void setPulseAsTiming(boolean val) throws IncompatibleArgumentException {
        if (val && this.frequency <= 0.0) {
            throw new IncompatibleArgumentException("");
        }
        this.usePulseAsTiming = val;
    }

    public void setIgnoreLast(boolean ignoreLast) {
        if (this.ignoreLast != ignoreLast) {
            this.ignoreLast = ignoreLast;
            this.resetXminXmax();
            this.repaint();
        }
    }

    private void setDragBegin(int x) {
        this.dragBeginX = Math.max(x, 15);
    }

    private void setDragEnd(int x) {
        if (this.dragBeginX != -1 && Math.abs(this.dragBeginX - x) > 20) {
            this.xmin = this.screenX2x(Math.min(this.dragBeginX, x));
            this.xmax = this.screenX2x(Math.max(this.dragBeginX, x));
        }
        this.dragBeginX = -1;
        this.dragEndX = -1;
        this.repaint();
    }

    private void drag(int x) {
        if (this.dragBeginX != -1) {
            this.dragEndX = x;
            this.repaint();
        }
    }

    private void resetXminXmax() {
        this.xmin = 0;
        this.xmax = 0;
        if (this.irdata != null) {
            for (int i = 0; i < (this.ignoreLast ? this.irdata.length - 1 : this.irdata.length); ++i) {
                this.xmax += Math.abs(this.irdata[i]);
            }
        }
    }

    public void reset() {
        this.resetSize();
        this.resetXminXmax();
    }

    public void resetSize() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(32000, 32000));
        this.setSize(new Dimension(400, 50));
        this.setPreferredSize(new Dimension(400, 50));
    }

    public void setWidth(int width) {
        if (width == 0) {
            this.reset();
            this.repaint();
        } else {
            this.resetXminXmax();
            Dimension d = new Dimension(width, this.getHeight());
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.setSize(d);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.onY = 10;
        this.offY = this.getHeight() - 40;
        this.drawBackground(graphics);
        this.drawDraggingBackground(graphics);
        this.drawTicks(graphics);
        this.drawPlot(graphics);
    }

    private void drawBackground(Graphics graphics) {
        graphics.setColor(plotBackgroundColor);
        graphics.fillRect(15, this.onY, this.getWidth() - 15 - 15, this.getHeight() - 10 - 40);
    }

    private void drawDraggingBackground(Graphics graphics) {
        if (this.dragBeginX != -1 && this.dragEndX != -1) {
            int minX = Math.min(this.dragBeginX, this.dragEndX);
            int maxX = Math.max(this.dragBeginX, this.dragEndX);
            graphics.setColor(plotDraggingBackgroundColor);
            graphics.fillRect(minX, this.onY, maxX - minX, this.getHeight() - 10 - 40);
        }
    }

    private void drawPlot(Graphics graphics) {
        if (this.irdata == null) {
            return;
        }
        int t = 0;
        graphics.setColor(introColor);
        for (int i = 0; i < this.irdata.length && t <= this.xmax; ++i) {
            int screenXEnd;
            boolean drawTransition = true;
            int screenXStart = this.x2screenX(t);
            if (screenXStart < 15) {
                screenXStart = 15;
                drawTransition = false;
            }
            if ((screenXEnd = this.x2screenX(t += Math.min(this.irdata[i], this.xmax))) < 15) continue;
            if (i == 2 * this.noIntroBursts) {
                graphics.setColor(repeatColor);
            }
            if (i == 2 * (this.noIntroBursts + this.noRepeats * this.noRepeatBursts)) {
                graphics.setColor(endingColor);
            }
            if (i % 2 == 0) {
                if (drawTransition) {
                    graphics.drawLine(screenXStart, this.offY, screenXStart, this.onY);
                }
                graphics.drawLine(screenXStart, this.onY, screenXEnd, this.onY);
                continue;
            }
            if (drawTransition || this.ignoreLast && i == this.irdata.length - 1) {
                graphics.drawLine(screenXStart, this.onY, screenXStart, this.offY);
            }
            if (this.ignoreLast && i == this.irdata.length - 1) continue;
            graphics.drawLine(screenXStart, this.offY, screenXEnd, this.offY);
        }
    }

    private int[] getTickValues(int xmin, int xmax, int pixelWidth) {
        int newXmin;
        if (xmin == xmax) {
            return new int[0];
        }
        double goalNoTicks = (double)pixelWidth / 75.0;
        double goalWidth = (double)(xmax - xmin) / goalNoTicks;
        int tickWidth = this.rounder((int)Math.round(goalWidth));
        this.useMilliSeconds = tickWidth >= 5000;
        this.xmin = newXmin = xmin / tickWidth * tickWidth;
        int noTicks = (int)Math.ceil((double)(xmax - newXmin) / (double)tickWidth) + 1;
        if (noTicks <= 0) {
            System.err.println(">>>>>>>>>>>>>>" + xmax + " " + newXmin + " " + tickWidth + " " + goalWidth);
            return new int[0];
        }
        int[] result = new int[noTicks];
        for (int i = 0; i < noTicks; ++i) {
            result[i] = newXmin + i * tickWidth;
        }
        return result;
    }

    private int[] getTickValues() {
        return this.getTickValues(this.xmin, this.xmax, this.getWidth() - 15 - 15);
    }

    private int rounder(double x) {
        double log = Math.log10(x);
        int divisor = this.pow10((int)log);
        int r = (int)Math.round(x / (double)divisor);
        return (r *= divisor) == 0 ? 1 : r;
    }

    private int pow10(int x) {
        return x <= 0 ? 1 : 10 * this.pow10(x - 1);
    }

    private int x2screenX(int x) {
        return (int)Math.round((double)(x - this.xmin) / (double)(this.xmax - this.xmin) * (double)(this.getWidth() - 15 - 15) + 15.0);
    }

    private int screenX2x(int X2) {
        return (int)Math.round((double)(X2 - 15) / (double)(this.getWidth() - 15 - 15) * (double)(this.xmax - this.xmin) + (double)this.xmin);
    }

    private void drawTicks(Graphics graphics) {
        int[] tickValues = this.getTickValues();
        for (int i = 0; i < tickValues.length; ++i) {
            this.drawTick(tickValues[i], graphics);
        }
    }

    private void drawTick(int x, Graphics graphics) {
        graphics.setColor(tickMarkColor);
        graphics.drawLine(this.x2screenX(x), this.offY + 10, this.x2screenX(x), this.offY);
        String str = Integer.toString(this.useMilliSeconds ? x / 1000 : x);
        graphics.setColor(numberColor);
        int strLength = 8 * str.length();
        int xcoord = this.x2screenX(x) - strLength / 2 < 15 ? 15 : (this.x2screenX(x) + strLength / 2 > this.getWidth() - 15 ? this.getWidth() - 15 - strLength : this.x2screenX(x) - strLength / 2);
        graphics.drawString(str, xcoord, this.offY + 30);
    }

    private void initializeMouse() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    IrPlotter.this.setDragBegin(evt.getX());
                } else if (evt.getButton() == 3 && evt.isPopupTrigger()) {
                    IrPlotter.this.plotterPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    IrPlotter.this.setDragEnd(evt.getX());
                } else if (evt.getButton() == 3 && evt.isPopupTrigger()) {
                    IrPlotter.this.plotterPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                IrPlotter.this.drag(evt.getX());
            }
        });
    }

    private void initializePlotterMenu() {
        this.plotterPopupMenu = new JPopupMenu();
        JMenuItem resetMenuItem = new JMenuItem();
        resetMenuItem.setText("Reset plotter");
        resetMenuItem.setToolTipText("Reset the axis of the plotter");
        resetMenuItem.setMnemonic('R');
        resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrPlotter.this.reset();
            }
        });
        this.plotterPopupMenu.add(resetMenuItem);
        this.plotterPopupMenu.add(this.plotterWidthsMenu);
        JMenuItem cloneMenuItem = new JMenuItem();
        cloneMenuItem.setText("Clone Plot");
        cloneMenuItem.setToolTipText("Create a frozen clone of the current plot in a popup window.");
        cloneMenuItem.setMnemonic('C');
        cloneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrPlotter.this.createPopupClone();
            }
        });
        this.plotterPopupMenu.add(cloneMenuItem);
    }

    public void createPopupClone() {
        if (this.isEmpty()) {
            return;
        }
        IrPlotter clone = new IrPlotter(this, false);
        clone.setPreferredSize(this.getSize());
        HarcletFrame.newHarcletFrame(this, clone, false, null);
    }

    private void initializePlotterWidthsMenu() {
        this.plotterWidthsMenu = new JMenu();
        this.plotterWidthsMenu.setText("Set width");
        this.plotterWidthsMenu.setToolTipText("Set width of the plotter explicitly. It can then be horizontally scrolled.");
        for (int width : this.plotterWidths) {
            JMenuItem menuItem = new JMenuItem(Integer.toString(width));
            final int localWidth = width;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    IrPlotter.this.setWidth(localWidth);
                }
            });
            this.plotterWidthsMenu.add(menuItem);
        }
    }

    @Override
    public String getHelpMessage() {
        return helpText;
    }

    @Override
    public String getAboutMessage() {
        return aboutText;
    }

    @Override
    public String getProgName() {
        return "IrPlotter";
    }

    @Override
    public String getIconPath() {
        return "/icons/Crystal-Clear/22x22/actions/pert_chart.png";
    }

    @Override
    public void close() throws IOException {
    }
}

