/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMaster;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.Iterate.InputVariableSetValues;
import org.harctoolbox.IrpMaster.Iterate.RandomValueSet;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UnknownProtocolException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.guicomponents.CopyPastePopupMenu;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.HelpPopup;

public class IrpMasterBean
extends JPanel {
    private static final String invalidParameterString = Long.toString(-1L);
    public static final String PROP_PROTOCOL_NAME = "protocolName";
    public static final String PROP_D = "D";
    public static final String PROP_S = "S";
    public static final String PROP_F = "F";
    public static final String PROP_T = "T";
    public static final String PROP_ADDITIONAL_PARAMS = "ADDITIONAL_PARAMS";
    private JFrame frame;
    private IrpMaster irpMaster;
    private String protocolName;
    private boolean disregardRepeatMins;
    private GuiUtils guiUtils;
    private ISignalNameFormatter signalNameFormatter;
    private String D = invalidParameterString;
    private String S = invalidParameterString;
    private String F = invalidParameterString;
    private String T = invalidParameterString;
    private String additionalParameters = "";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JLabel additionalParametersLabel;
    private JTextField additionalParametersTextField;
    private CopyPastePopupMenu copyPastePopupMenu;
    private CopyPastePopupMenu copyPopupMenu;
    private JLabel dLabel;
    private JTextField dTextField;
    private JLabel fLabel;
    private JTextField fTextField;
    private JTextField irpTextField;
    private JLabel jLabel1;
    private JComboBox<String> protocolComboBox;
    private JButton protocolDocuButton;
    private JLabel sLabel;
    private JTextField sTextField;
    private JLabel tLabel;
    private JComboBox<String> toggleComboBox;

    public void setDisregardRepeatMins(boolean disregardRepeatMins) {
        this.disregardRepeatMins = disregardRepeatMins;
    }

    public void setSignalNameFormatter(ISignalNameFormatter signalNameFormatter) {
        this.signalNameFormatter = signalNameFormatter;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public void setIrpMaster(IrpMaster irpMaster) {
        this.irpMaster = irpMaster;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public IrpMasterBean() {
        this.initComponents();
    }

    public IrpMasterBean(JFrame frame, GuiUtils guiUtils, IrpMaster irpMaster, String intialProtocol, boolean disregardRepeatMins) {
        this(frame, guiUtils, irpMaster, intialProtocol, "0", invalidParameterString, "0", "-", "", disregardRepeatMins);
    }

    public IrpMasterBean(JFrame frame, GuiUtils guiUtils, IrpMaster irpMaster, String intialProtocol, String initialD, String initialS, String initialF, String initialT, String initialAdditionalParameters, boolean disregardRepeatMins) {
        this.signalNameFormatter = new DefaultSignalNameFormatter();
        this.frame = frame;
        this.guiUtils = guiUtils;
        this.disregardRepeatMins = disregardRepeatMins;
        this.irpMaster = irpMaster;
        this.protocolName = intialProtocol;
        this.initComponents();
        try {
            this.setupProtocol(this.protocolName, initialD, initialS, initialF, initialT, initialAdditionalParameters);
            this.D = initialD;
            this.S = initialS;
            this.F = initialF;
            this.T = initialT;
            this.additionalParameters = initialAdditionalParameters;
        }
        catch (ParseException | UnassignedException | UnknownProtocolException ex) {
            guiUtils.error(ex);
        }
    }

    private String[] irpMasterProtocols() {
        if (this.irpMaster == null) {
            return new String[]{"--"};
        }
        String[] protocolList = this.irpMaster.getNames().toArray(new String[this.irpMaster.getNames().size()]);
        Arrays.sort(protocolList, String.CASE_INSENSITIVE_ORDER);
        return protocolList;
    }

    private void checkParam(Protocol protocol, JTextField textField, JLabel label, String parameterName, String oldValueStr) {
        if (protocol.hasParameter(parameterName)) {
            textField.setEnabled(true);
            label.setEnabled(true);
            if (!oldValueStr.equals(invalidParameterString)) {
                textField.setText(oldValueStr);
            }
        } else {
            textField.setEnabled(false);
            label.setEnabled(false);
            textField.setText(null);
        }
    }

    private void checkParam(Protocol protocol, JComboBox comboBox, JLabel label, String parameterName, String initalValue) {
        if (protocol.hasParameter(parameterName)) {
            comboBox.setSelectedItem(initalValue);
        } else {
            comboBox.setSelectedItem("-");
        }
        comboBox.setEnabled(protocol.hasParameter(parameterName));
        label.setEnabled(protocol.hasParameter(parameterName));
    }

    private void setupProtocol(String protocolName, String initialD, String initialS, String initialF, String initalT, String initialAdditionalParameters) throws UnassignedException, ParseException, UnknownProtocolException {
        Protocol protocol = this.irpMaster.newProtocol(protocolName);
        this.checkParam(protocol, this.dTextField, this.dLabel, PROP_D, initialD);
        this.checkParam(protocol, this.sTextField, this.sLabel, PROP_S, initialS);
        this.checkParam(protocol, this.fTextField, this.fLabel, PROP_F, initialF);
        this.checkParam(protocol, this.toggleComboBox, this.tLabel, PROP_T, initalT);
        this.additionalParametersTextField.setText(initialAdditionalParameters);
        this.additionalParametersLabel.setEnabled(protocol.hasAdvancedParameters());
        this.additionalParametersTextField.setEnabled(protocol.hasAdvancedParameters());
        this.irpTextField.setText(this.irpMaster.getIrp(protocolName));
    }

    public String getSignalName() throws UnassignedException, ParseException, UnknownProtocolException, IncompatibleArgumentException {
        HashMap<String, Long> parameters = this.getParameters();
        return this.signalNameFormatter.format(this.protocolName, parameters);
    }

    public HashMap<String, Long> getParameters() throws UnassignedException, ParseException, UnknownProtocolException, IncompatibleArgumentException {
        InputVariableSetValues parameterSets = this.getIntervalParameters();
        Iterator<LinkedHashMap<String, Long>> it = parameterSets.iterator();
        return it.hasNext() ? it.next() : null;
    }

    private void processParameter(HashMap<String, String> parameters, Protocol protocol, String name, JTextField textField) {
        if (!(!protocol.hasParameter(name) || protocol.hasParameterDefault(name) && textField.getText().trim().isEmpty())) {
            parameters.put(name, textField.getText());
        }
    }

    public InputVariableSetValues getIntervalParameters() throws UnassignedException, ParseException, UnknownProtocolException, IncompatibleArgumentException {
        String addParams;
        Protocol protocol = this.irpMaster.newProtocol(this.protocolName);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(4);
        this.processParameter(parameters, protocol, PROP_D, this.dTextField);
        this.processParameter(parameters, protocol, PROP_S, this.sTextField);
        this.processParameter(parameters, protocol, PROP_F, this.fTextField);
        String toggle = (String)this.toggleComboBox.getModel().getSelectedItem();
        if (!toggle.equals("-")) {
            parameters.put(PROP_T, toggle);
        }
        String string = addParams = protocol.hasAdvancedParameters() ? this.additionalParametersTextField.getText() : null;
        if (addParams != null && !addParams.trim().isEmpty()) {
            String[] str;
            for (String s : str = addParams.trim().split("[ \t]+")) {
                String[] q = s.split("=");
                if (q.length != 2) continue;
                parameters.put(q[0], q[1]);
            }
        }
        RandomValueSet.initRng();
        return new InputVariableSetValues(parameters, true, protocol);
    }

    public IrSignal render() throws UnassignedException, ParseException, UnknownProtocolException, IncompatibleArgumentException, DomainViolationException, InvalidRepeatException {
        HashMap<String, Long> parameters = this.getParameters();
        Protocol protocol = this.irpMaster.newProtocol(this.protocolName);
        IrSignal irSignal = protocol.renderIrSignal(parameters, !this.disregardRepeatMins);
        return irSignal;
    }

    public LinkedHashMap<String, Command> getCommands() throws UnassignedException, ParseException, UnknownProtocolException, IncompatibleArgumentException, IrpMasterException {
        InputVariableSetValues intervals = this.getIntervalParameters();
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(16);
        for (LinkedHashMap<String, Long> params : intervals) {
            String name = this.signalNameFormatter.format(this.getProtocolName(), params);
            Command command = new Command(name, null, this.getProtocolName(), params);
            commands.put(name, command);
        }
        return commands;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.copyPastePopupMenu = new CopyPastePopupMenu(true);
        this.copyPopupMenu = new CopyPastePopupMenu();
        this.protocolComboBox = new JComboBox();
        this.toggleComboBox = new JComboBox();
        this.protocolDocuButton = new JButton();
        this.dTextField = new JTextField();
        this.sTextField = new JTextField();
        this.fTextField = new JTextField();
        this.additionalParametersTextField = new JTextField();
        this.irpTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.dLabel = new JLabel();
        this.sLabel = new JLabel();
        this.fLabel = new JLabel();
        this.tLabel = new JLabel();
        this.additionalParametersLabel = new JLabel();
        this.protocolComboBox.setModel(new DefaultComboBoxModel<String>(this.irpMasterProtocols()));
        this.protocolComboBox.setSelectedItem(this.protocolName);
        this.protocolComboBox.setToolTipText("Name of protocol");
        this.protocolComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.protocolComboBoxActionPerformed(evt);
            }
        });
        this.toggleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "0", "1", "*"}));
        this.toggleComboBox.setToolTipText("toggle code");
        this.toggleComboBox.setEnabled(false);
        this.toggleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.toggleComboBoxActionPerformed(evt);
            }
        });
        this.protocolDocuButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/mimetypes/man.png")));
        this.protocolDocuButton.setText("Docu");
        this.protocolDocuButton.setToolTipText("Display notes to the selected protocol");
        this.protocolDocuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.protocolDocuButtonActionPerformed(evt);
            }
        });
        this.dTextField.setToolTipText("device number");
        this.dTextField.setComponentPopupMenu(this.copyPastePopupMenu);
        this.dTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IrpMasterBean.this.dTextFieldFocusLost(evt);
            }
        });
        this.dTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.dTextFieldActionPerformed(evt);
            }
        });
        this.sTextField.setToolTipText("subdevice number");
        this.sTextField.setComponentPopupMenu(this.copyPastePopupMenu);
        this.sTextField.setEnabled(false);
        this.sTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IrpMasterBean.this.sTextFieldFocusLost(evt);
            }
        });
        this.sTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.sTextFieldActionPerformed(evt);
            }
        });
        this.fTextField.setToolTipText("function number (OBC)");
        this.fTextField.setComponentPopupMenu(this.copyPastePopupMenu);
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.fTextFieldActionPerformed(evt);
            }
        });
        this.fTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IrpMasterBean.this.fTextFieldFocusLost(evt);
            }
        });
        this.additionalParametersTextField.setToolTipText("Other parameters than D, S, F, T, in syntayx variable1=val1 variable2=val2");
        this.additionalParametersTextField.setComponentPopupMenu(this.copyPastePopupMenu);
        this.additionalParametersTextField.setEnabled(false);
        this.additionalParametersTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                IrpMasterBean.this.additionalParametersTextFieldFocusLost(evt);
            }
        });
        this.additionalParametersTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IrpMasterBean.this.additionalParametersTextFieldActionPerformed(evt);
            }
        });
        this.irpTextField.setEditable(false);
        this.irpTextField.setText("{38.4k,564}<1,-1|1,-3>(16,-8,D:8,S:8,F:8,~F:8,1,^108m,(16,-4,1,^108m)*) [D:0..255,S:0..255=255-D,F:0..255]");
        this.irpTextField.setToolTipText("IRP notation of the selected protocol");
        this.irpTextField.setComponentPopupMenu(this.copyPopupMenu);
        this.jLabel1.setText("Protocol");
        this.dLabel.setText(PROP_D);
        this.sLabel.setText(PROP_S);
        this.sLabel.setEnabled(false);
        this.fLabel.setText(PROP_F);
        this.tLabel.setText(PROP_T);
        this.tLabel.setEnabled(false);
        this.additionalParametersLabel.setText("Additional parameters");
        this.additionalParametersLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.irpTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.protocolComboBox, -2, 124, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dTextField, -2, 50, -2).addComponent(this.dLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sLabel).addComponent(this.sTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fLabel).addComponent(this.fTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tLabel).addComponent(this.toggleComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.additionalParametersLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.additionalParametersTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolDocuButton))))).addContainerGap()));
        layout.linkSize(0, this.dTextField, this.fTextField, this.sTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dLabel).addComponent(this.sLabel).addComponent(this.fLabel).addComponent(this.tLabel).addComponent(this.additionalParametersLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protocolComboBox, -2, -1, -2).addComponent(this.toggleComboBox, -2, -1, -2).addComponent(this.protocolDocuButton).addComponent(this.dTextField, -2, -1, -2).addComponent(this.sTextField, -2, -1, -2).addComponent(this.fTextField, -2, -1, -2).addComponent(this.additionalParametersTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.irpTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void protocolDocuButtonActionPerformed(ActionEvent evt) {
        StringBuilder str = new StringBuilder(this.irpMaster.getIrp(this.protocolName)).append("\n\n");
        if (this.irpMaster.getDocumentation(this.protocolName) != null) {
            str.append(this.irpMaster.getDocumentation(this.protocolName));
        }
        HelpPopup.newHelpPopup(this.frame, str.toString());
    }

    private void protocolComboBoxActionPerformed(ActionEvent evt) {
        try {
            String oldProtocolName = this.protocolName;
            this.protocolName = (String)this.protocolComboBox.getSelectedItem();
            this.setupProtocol(this.protocolName, invalidParameterString, invalidParameterString, invalidParameterString, invalidParameterString, "");
            this.propertyChangeSupport.firePropertyChange(PROP_PROTOCOL_NAME, oldProtocolName, this.protocolName);
        }
        catch (ParseException | UnassignedException | UnknownProtocolException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void dTextFieldActionPerformed(ActionEvent evt) {
        String oldD = this.D;
        this.D = this.dTextField.getText();
        this.propertyChangeSupport.firePropertyChange(PROP_D, oldD, this.D);
    }

    private void sTextFieldActionPerformed(ActionEvent evt) {
        String oldS = this.S;
        this.S = this.sTextField.getText();
        this.propertyChangeSupport.firePropertyChange(PROP_S, oldS, this.S);
    }

    private void fTextFieldActionPerformed(ActionEvent evt) {
        String oldF = this.F;
        this.F = this.fTextField.getText();
        this.propertyChangeSupport.firePropertyChange(PROP_F, oldF, this.F);
    }

    private void dTextFieldFocusLost(FocusEvent evt) {
        this.dTextFieldActionPerformed(null);
    }

    private void sTextFieldFocusLost(FocusEvent evt) {
        this.sTextFieldActionPerformed(null);
    }

    private void fTextFieldFocusLost(FocusEvent evt) {
        this.fTextFieldActionPerformed(null);
    }

    private void toggleComboBoxActionPerformed(ActionEvent evt) {
        String oldT = this.T;
        this.T = (String)this.toggleComboBox.getSelectedItem();
        this.propertyChangeSupport.firePropertyChange(PROP_T, oldT, this.T);
    }

    private void additionalParametersTextFieldActionPerformed(ActionEvent evt) {
        String oldParams = this.additionalParameters;
        this.additionalParameters = this.additionalParametersTextField.getText().trim();
        this.propertyChangeSupport.firePropertyChange(PROP_ADDITIONAL_PARAMS, oldParams, this.additionalParameters);
    }

    private void additionalParametersTextFieldFocusLost(FocusEvent evt) {
        this.additionalParametersTextFieldActionPerformed(null);
    }

    public static class DefaultSignalNameFormatter
    implements ISignalNameFormatter,
    Serializable {
        private StringBuilder doParameter(HashMap<String, Long> parameters, String parameterName) {
            if (!parameters.containsKey(parameterName)) {
                return new StringBuilder(0);
            }
            StringBuilder str = new StringBuilder(64);
            str.append(parameterName).append(parameters.get(parameterName));
            parameters.remove(parameterName);
            return str;
        }

        @Override
        public String format(String protocolName, HashMap<String, Long> parameters) {
            HashMap params = (HashMap)parameters.clone();
            StringBuilder tail = new StringBuilder(64);
            tail.append((CharSequence)this.doParameter(params, IrpMasterBean.PROP_D));
            tail.append((CharSequence)this.doParameter(params, IrpMasterBean.PROP_S));
            tail.append((CharSequence)this.doParameter(params, IrpMasterBean.PROP_F));
            tail.append((CharSequence)this.doParameter(params, IrpMasterBean.PROP_T));
            StringBuilder mid = new StringBuilder(64);
            for (String param : params.keySet().toArray(new String[params.size()])) {
                mid.append((CharSequence)this.doParameter(params, param));
            }
            StringBuilder str = new StringBuilder(protocolName);
            str.append("_").append((CharSequence)mid).append((CharSequence)tail);
            return str.toString();
        }
    }

    public static interface ISignalNameFormatter {
        public String format(String var1, HashMap<String, Long> var2);
    }
}

