/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelManager {
    private final String[] lafNames;
    private final UIManager.LookAndFeelInfo[] lafInfo;
    private JRadioButton[] lafRadioButtons = null;
    private ButtonGroup lafButtonGroup = null;
    private final Window topLevel;
    private int currentIndex;
    private final ILookAndFeelManagerCaller caller;

    public LookAndFeelManager(Window topLevel, JMenu lafMenu, ILookAndFeelManagerCaller caller) {
        this.caller = caller;
        this.topLevel = topLevel;
        this.lafInfo = UIManager.getInstalledLookAndFeels();
        this.lafNames = new String[this.lafInfo.length];
        if (lafMenu != null) {
            this.lafButtonGroup = new ButtonGroup();
            this.lafRadioButtons = new JRadioButton[this.lafInfo.length];
        }
        for (int i = 0; i < this.lafInfo.length; ++i) {
            JRadioButton menuItem;
            this.lafNames[i] = this.lafInfo[i].getName();
            if (lafMenu == null) continue;
            this.lafRadioButtons[i] = menuItem = new JRadioButton(this.lafNames[i]);
            final int lafIndex = i;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LookAndFeelManager.this.setLAF(lafIndex);
                    LookAndFeelManager.this.updateLAF();
                }
            });
            this.lafButtonGroup.add(menuItem);
            lafMenu.add(menuItem);
        }
    }

    public void setLAF(int index) {
        try {
            this.setLAFex(index);
        }
        catch (ClassNotFoundException ex) {
            this.caller.err(ex, "Class not found");
        }
        catch (IllegalAccessException | InstantiationException ex) {
            this.caller.err(ex, null);
        }
        catch (UnsupportedLookAndFeelException ex) {
            this.caller.err(ex, "Unsupported LAF");
        }
    }

    public void setLAFex(int index) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(this.lafInfo[index].getClassName());
        if (this.lafRadioButtons != null) {
            for (int i = 0; i < this.lafInfo.length; ++i) {
                this.lafRadioButtons[i].setSelected(i == index);
            }
        }
        this.caller.setLAFProperty(index);
        this.currentIndex = index;
    }

    public void updateLAF() {
        SwingUtilities.updateComponentTreeUI(this.topLevel);
        this.topLevel.pack();
    }

    public String getCurrentLAFClassName() {
        return this.lafInfo[this.currentIndex].getClassName();
    }

    public static interface ILookAndFeelManagerCaller {
        public void err(Exception var1, String var2);

        public void setLAFProperty(int var1);
    }
}

