/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.harctoolbox.guicomponents.CopyPastePopupMenu;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.ir.IRemoteCommandIrSender;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class NamedCommandLauncher
extends JPanel {
    private GuiUtils guiUtils;
    private transient IRemoteCommandIrSender hardware;
    private DefaultComboBoxModel<String> transmitterComboBoxModel;
    private DefaultComboBoxModel<String> remoteComboBoxModel;
    private DefaultComboBoxModel<String> commandComboBoxModel;
    private JComboBox<String> commandComboBox;
    private CopyPastePopupMenu copyPopupMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox<String> noSendsComboBox;
    private JButton reloadButton;
    private JComboBox<String> remoteComboBox;
    private JButton sendButton;
    private JButton stopButton;
    private JComboBox<String> transmitterComboBox;

    public NamedCommandLauncher() {
        this(null, null);
    }

    public NamedCommandLauncher(GuiUtils guiUtils) {
        this(guiUtils, null);
    }

    public NamedCommandLauncher(GuiUtils guiUtils, IRemoteCommandIrSender remoteCommandIrSender) {
        this.guiUtils = guiUtils;
        try {
            this.setHardware(remoteCommandIrSender);
        }
        catch (ConnectException ex) {
            guiUtils.error("Connection was refused.");
        }
        catch (IOException ex) {
            guiUtils.error(ex);
        }
        this.initComponents();
        this.enableStuff();
    }

    public final void setHardware(IRemoteCommandIrSender hardware) throws IOException {
        this.hardware = hardware;
        if (hardware == null) {
            this.transmitterComboBoxModel = new DefaultComboBoxModel();
            this.remoteComboBoxModel = new DefaultComboBoxModel();
            this.commandComboBoxModel = new DefaultComboBoxModel();
            if (this.remoteComboBox != null) {
                this.remoteComboBox.setModel(this.remoteComboBoxModel);
            }
            if (this.commandComboBox != null) {
                this.commandComboBox.setModel(this.commandComboBoxModel);
            }
        } else {
            this.load();
            this.enableStuff();
        }
    }

    private void enableStuff() {
        this.stopButton.setEnabled(false);
        this.sendButton.setEnabled(this.hardware != null);
        this.reloadButton.setEnabled(this.hardware != null);
        this.transmitterComboBox.setEnabled(this.hardware != null && this.transmitterComboBoxModel.getSize() > 1);
        this.noSendsComboBox.setEnabled(this.hardware != null);
        this.remoteComboBox.setEnabled(this.hardware != null);
        this.commandComboBox.setEnabled(this.hardware != null);
    }

    private void load() throws IOException {
        if (ITransmitter.class.isInstance(this.hardware)) {
            this.transmitterComboBoxModel = new DefaultComboBoxModel<String>(((ITransmitter)((Object)this.hardware)).getTransmitterNames());
        } else {
            this.transmitterComboBox.setEditable(false);
        }
        this.transmitterComboBox.setModel(this.transmitterComboBoxModel);
        try {
            String[] remotes = this.hardware.getRemotes();
            if (remotes == null || remotes.length == 0) {
                this.guiUtils.warning("No remotes present");
                this.remoteComboBox.setModel(new DefaultComboBoxModel());
                this.commandComboBox.setModel(new DefaultComboBoxModel());
                return;
            }
            Arrays.sort(remotes, String.CASE_INSENSITIVE_ORDER);
            this.remoteComboBoxModel = new DefaultComboBoxModel<String>(remotes);
            this.remoteComboBox.setModel(this.remoteComboBoxModel);
            this.loadCommands(this.remoteComboBoxModel.getElementAt(0));
        }
        catch (IOException ex) {
            this.hardware = null;
            this.remoteComboBox.setModel(new DefaultComboBoxModel());
            this.commandComboBox.setModel(new DefaultComboBoxModel());
            throw ex;
        }
    }

    private void loadCommands(String remote) {
        try {
            String[] commands = this.hardware.getCommands(remote);
            if (commands == null) {
                commands = new String[]{};
            }
            Arrays.sort(commands, String.CASE_INSENSITIVE_ORDER);
            this.commandComboBoxModel = new DefaultComboBoxModel<String>(commands);
            this.commandComboBox.setModel(this.commandComboBoxModel);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private String getRemote() {
        return (String)this.remoteComboBox.getSelectedItem();
    }

    private String getCommand() {
        return (String)this.commandComboBox.getSelectedItem();
    }

    private int getNoSends() {
        return Integer.parseInt((String)this.noSendsComboBox.getSelectedItem());
    }

    public Transmitter getTransmitter() throws NoSuchTransmitterException {
        if (ITransmitter.class.isInstance(this.hardware)) {
            ITransmitter tr = (ITransmitter)((Object)this.hardware);
            return tr.getTransmitter((String)this.transmitterComboBox.getSelectedItem());
        }
        return null;
    }

    private void initComponents() {
        this.copyPopupMenu = new CopyPastePopupMenu();
        this.noSendsComboBox = new JComboBox();
        this.transmitterComboBox = new JComboBox();
        this.remoteComboBox = new JComboBox();
        this.commandComboBox = new JComboBox();
        this.sendButton = new JButton();
        this.stopButton = new JButton();
        this.reloadButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.noSendsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "7", "10", "15", "20", "30", "40", "50", "70", "100", "200", "500", "1000"}));
        this.noSendsComboBox.setToolTipText("Number of times to send command");
        this.transmitterComboBox.setModel(this.transmitterComboBoxModel);
        this.transmitterComboBox.setToolTipText("The transmitter to use to send the command");
        this.remoteComboBox.setModel(this.remoteComboBoxModel);
        this.remoteComboBox.setToolTipText("Device for which command is defined");
        this.remoteComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamedCommandLauncher.this.remoteComboBoxActionPerformed(evt);
            }
        });
        this.commandComboBox.setModel(this.commandComboBoxModel);
        this.commandComboBox.setToolTipText("Command name");
        this.sendButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/cache.png")));
        this.sendButton.setMnemonic('S');
        this.sendButton.setText("Send");
        this.sendButton.setToolTipText("Send command");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamedCommandLauncher.this.sendButtonActionPerformed(evt);
            }
        });
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/stop.png")));
        this.stopButton.setMnemonic('T');
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stop ongoing transmission");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamedCommandLauncher.this.stopButtonActionPerformed(evt);
            }
        });
        this.reloadButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/reload.png")));
        this.reloadButton.setMnemonic('R');
        this.reloadButton.setText("Reload");
        this.reloadButton.setToolTipText("Reload devices and their commands from the gateway");
        this.reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamedCommandLauncher.this.reloadButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("# Sends");
        this.jLabel2.setText("Transm.");
        this.jLabel3.setText("Remote");
        this.jLabel4.setText("Command");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noSendsComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.transmitterComboBox, -2, 72, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.remoteComboBox, -2, 150, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandComboBox, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reloadButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.noSendsComboBox, -2, -1, -2).addComponent(this.transmitterComboBox, -2, -1, -2).addComponent(this.remoteComboBox, -2, -1, -2).addComponent(this.commandComboBox, -2, -1, -2).addComponent(this.sendButton).addComponent(this.stopButton).addComponent(this.reloadButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.commandComboBox, this.noSendsComboBox, this.remoteComboBox, this.transmitterComboBox);
        layout.linkSize(1, this.reloadButton, this.sendButton, this.stopButton);
    }

    private void remoteComboBoxActionPerformed(ActionEvent evt) {
        this.loadCommands(this.getRemote());
        this.commandComboBox.setModel(this.commandComboBoxModel);
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        try {
            this.hardware.sendIrCommand(this.getRemote(), this.getCommand(), this.getNoSends(), this.getTransmitter());
        }
        catch (IOException | NoSuchTransmitterException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        try {
            this.load();
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
        if (this.remoteComboBox.getItemCount() > 0) {
            this.remoteComboBox.setSelectedIndex(0);
            this.remoteComboBoxActionPerformed(null);
        }
        this.enableStuff();
    }
}

