/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;

public class SerialPortBean
extends JPanel {
    private String portName;
    private int baud;
    private int dataSize;
    private LocalSerialPort.FlowControl flowControl;
    private LocalSerialPort.Parity parity;
    private int stopBits;
    private GuiUtils guiUtils;
    private boolean verbose;
    private transient IHarcHardware hardware;
    public static final String PROP_PORTNAME = "PROP_PORTNAME";
    public static final String PROP_BAUD = "PROP_BAUD";
    public static final String PROP_DATASIZE = "PROP_DATASIZE";
    public static final String PROP_FLOWCONTROL = "PROP_FLOWCONTROL";
    public static final String PROP_PARITY = "PROP_PARITY";
    public static final String PROP_STOPBITS = "PROP_STOPBITS";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox<String> baudComboBox;
    private JComboBox<String> bitsComboBox;
    private JComboBox<String> flowControlComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JToggleButton openToggleButton;
    private JComboBox<String> parityComboBox;
    private JComboBox<String> portComboBox;
    private JButton refreshButton;
    private JComboBox<String> stopBitsComboBox;

    public SerialPortBean(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
        this.initComponents();
        this.portComboBoxActionPerformed(null);
        this.baudComboBoxActionPerformed(null);
        this.bitsComboBoxActionPerformed(null);
        this.flowControlComboBoxActionPerformed(null);
        this.stopBitsComboBoxActionPerformed(null);
        this.parityComboBoxActionPerformed(null);
    }

    public SerialPortBean() {
        this((GuiUtils)null);
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        if (portName == null || portName.isEmpty()) {
            return;
        }
        String oldPortName = this.portName;
        this.portName = portName;
        this.propertyChangeSupport.firePropertyChange(PROP_PORTNAME, oldPortName, portName);
    }

    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        int oldBaud = this.baud;
        this.baud = baud;
        this.propertyChangeSupport.firePropertyChange(PROP_BAUD, oldBaud, baud);
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataSize) {
        int oldDataSize = this.dataSize;
        this.dataSize = dataSize;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASIZE, oldDataSize, dataSize);
    }

    public LocalSerialPort.FlowControl getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(LocalSerialPort.FlowControl flowControl) {
        LocalSerialPort.FlowControl oldFlowControl = this.flowControl;
        this.flowControl = flowControl;
        this.propertyChangeSupport.firePropertyChange(PROP_FLOWCONTROL, (Object)oldFlowControl, (Object)flowControl);
    }

    public LocalSerialPort.Parity getParity() {
        return this.parity;
    }

    public void setParity(LocalSerialPort.Parity parity) {
        LocalSerialPort.Parity oldParity = this.parity;
        this.parity = parity;
        this.propertyChangeSupport.firePropertyChange(PROP_PARITY, (Object)oldParity, (Object)parity);
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        int oldStopBits = this.stopBits;
        this.stopBits = stopBits;
        this.propertyChangeSupport.firePropertyChange(PROP_STOPBITS, oldStopBits, stopBits);
    }

    public void setGuiUtils(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setHardware(IHarcHardware hardware) {
        this.hardware = hardware;
        this.openToggleButton.setEnabled(hardware != null);
        this.openToggleButton.setSelected(hardware.isValid());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setup(String desiredPort) throws IOException {
        if (this.portComboBox.getModel().getSize() == 0 || this.portComboBox.getModel().getSize() == 1 && ((String)this.portComboBox.getSelectedItem()).equals("not initialized")) {
            this.setupPortComboBox(true);
        }
        this.portComboBox.setSelectedItem(desiredPort != null ? desiredPort : this.portName);
    }

    public void setupPortComboBox(boolean useCached) throws IOException {
        if (this.hardware != null) {
            this.hardware.close();
        }
        ArrayList<String> portNames = LocalSerialPort.getSerialPortNames(useCached);
        portNames.add(0, null);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(portNames.toArray(new String[portNames.size()]));
        this.portComboBox.setModel(model);
    }

    private void initComponents() {
        this.portComboBox = new JComboBox();
        this.refreshButton = new JButton();
        this.jLabel1 = new JLabel();
        this.bitsComboBox = new JComboBox();
        this.flowControlComboBox = new JComboBox();
        this.parityComboBox = new JComboBox();
        this.stopBitsComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.baudComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.openToggleButton = new JToggleButton();
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"not initialized"}));
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.portComboBoxActionPerformed(evt);
            }
        });
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/reload.png")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.refreshButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Serial Port");
        this.bitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"5", "6", "7", "8"}));
        this.bitsComboBox.setSelectedIndex(3);
        this.bitsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.bitsComboBoxActionPerformed(evt);
            }
        });
        this.flowControlComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "RTS/CTS", "Xon/Xoff"}));
        this.flowControlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.flowControlComboBoxActionPerformed(evt);
            }
        });
        this.parityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "odd", "even", "mark", "space"}));
        this.parityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.parityComboBoxActionPerformed(evt);
            }
        });
        this.stopBitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "1.5"}));
        this.stopBitsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.stopBitsComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Bits");
        this.jLabel3.setText("Flow cntrl");
        this.jLabel4.setText("parity");
        this.jLabel5.setText("stop bits");
        this.baudComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"115200", "57600", "38400", "19200", "9600", "4800", "2400", "1200"}));
        this.baudComboBox.setSelectedItem("9600");
        this.baudComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.baudComboBoxActionPerformed(evt);
            }
        });
        this.jLabel7.setText("bits/s");
        this.openToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/connect_creating.png")));
        this.openToggleButton.setText("Open");
        this.openToggleButton.setEnabled(false);
        this.openToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortBean.this.openToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portComboBox, -2, 142, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baudComboBox, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bitsComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.flowControlComboBox, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.parityComboBox, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(layout.createSequentialGroup().addComponent(this.stopBitsComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openToggleButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.refreshButton).addComponent(this.bitsComboBox, -2, -1, -2).addComponent(this.flowControlComboBox, -2, -1, -2).addComponent(this.parityComboBox, -2, -1, -2).addComponent(this.stopBitsComboBox, -2, -1, -2).addComponent(this.baudComboBox, -2, -1, -2).addComponent(this.openToggleButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        try {
            this.setupPortComboBox(false);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.setPortName((String)this.portComboBox.getSelectedItem());
    }

    private void baudComboBoxActionPerformed(ActionEvent evt) {
        this.setBaud(Integer.parseInt((String)this.baudComboBox.getSelectedItem()));
    }

    private void bitsComboBoxActionPerformed(ActionEvent evt) {
        this.setDataSize(Integer.parseInt((String)this.bitsComboBox.getSelectedItem()));
    }

    private void flowControlComboBoxActionPerformed(ActionEvent evt) {
        int index = this.flowControlComboBox.getSelectedIndex();
        LocalSerialPort.FlowControl flow = index == 0 ? LocalSerialPort.FlowControl.NONE : (index == 1 ? LocalSerialPort.FlowControl.RTSCTS : LocalSerialPort.FlowControl.XONXOFF);
        this.setFlowControl(flow);
    }

    private void stopBitsComboBoxActionPerformed(ActionEvent evt) {
        this.setStopBits(this.stopBitsComboBox.getSelectedIndex() + 1);
    }

    private void parityComboBoxActionPerformed(ActionEvent evt) {
        this.setParity(LocalSerialPort.Parity.valueOf(((String)this.parityComboBox.getSelectedItem()).toUpperCase(IrpUtils.dumbLocale)));
    }

    private void openToggleButtonActionPerformed(ActionEvent evt) {
        block5: {
            try {
                if (this.openToggleButton.isSelected()) {
                    this.hardware.open();
                    break block5;
                }
                this.hardware.close();
            }
            catch (IOException | HarcHardwareException ex) {
                try {
                    this.guiUtils.error(ex);
                }
                catch (Throwable throwable) {
                    this.openToggleButton.setSelected(this.hardware.isValid());
                    this.refreshButton.setEnabled(!this.hardware.isValid() || !this.openToggleButton.isSelected());
                    throw throwable;
                }
                this.openToggleButton.setSelected(this.hardware.isValid());
                this.refreshButton.setEnabled(!this.hardware.isValid() || !this.openToggleButton.isSelected());
            }
        }
        this.openToggleButton.setSelected(this.hardware.isValid());
        this.refreshButton.setEnabled(!this.hardware.isValid() || !this.openToggleButton.isSelected());
    }
}

