/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.ISendingReceivingBean;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;

public class SerialPortSimpleBean
extends JPanel
implements ISendingReceivingBean {
    private static final int defaultBaudRate = 9600;
    private static final String notInitialized = "not initialized";
    private String portName;
    private int baudRate;
    private String version;
    private GuiUtils guiUtils;
    private transient IHarcHardware hardware;
    private final boolean settableBaudRate;
    private boolean listenable;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox<String> baudComboBox;
    private JLabel baudRateLabel;
    private JLabel jLabel1;
    private JToggleButton openToggleButton;
    private JComboBox<String> portComboBox;
    private JButton refreshButton;
    private JLabel versionLabel;
    private JLabel versionLiteralLabel;

    public SerialPortSimpleBean() {
        this(null, null, 9600, true);
    }

    public SerialPortSimpleBean(GuiUtils guiUtils) {
        this(guiUtils, null, 9600, true);
    }

    public SerialPortSimpleBean(GuiUtils guiUtils, String initialPort, int initialBaud, boolean settableBaudRate) {
        DefaultComboBoxModel<String> model;
        this.initComponents();
        this.guiUtils = guiUtils;
        this.listenable = false;
        try {
            ArrayList<String> portList = LocalSerialPort.getSerialPortNames(true);
            model = new DefaultComboBoxModel<String>(portList.toArray(new String[portList.size()]));
        }
        catch (IOException | LinkageError ex) {
            model = new DefaultComboBoxModel<String>(new String[]{initialPort != null ? initialPort : notInitialized});
        }
        this.portComboBox.setModel(model);
        boolean hit = false;
        if (initialPort != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!initialPort.equalsIgnoreCase(model.getElementAt(i))) continue;
                hit = true;
                this.portComboBox.setSelectedIndex(i);
                break;
            }
        }
        String actualPort = initialPort;
        if (!hit && model.getSize() > 0) {
            this.portComboBox.setSelectedIndex(0);
            actualPort = this.portComboBox.getItemAt(0);
        }
        this.setPortName(actualPort);
        this.setBaudRateUnconditionally(initialBaud);
        this.settableBaudRate = settableBaudRate;
        this.baudComboBox.setEnabled(settableBaudRate);
        this.baudRateLabel.setEnabled(settableBaudRate);
    }

    public String getPortName() {
        return this.portName;
    }

    public final void setPortName(String portName) {
        if (portName == null || portName.isEmpty()) {
            return;
        }
        this.openToggleButton.setEnabled(this.hardware != null);
        String oldPort = this.portName;
        this.portName = portName;
        this.propertyChangeSupport.firePropertyChange("PROP_PORTNAME", oldPort, portName);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        if (this.settableBaudRate) {
            this.setBaudRateUnconditionally(baudRate);
        }
    }

    private void setBaudRateUnconditionally(int baudRate) {
        int oldBaud = this.baudRate;
        this.baudRate = baudRate;
        this.baudComboBox.setSelectedItem(Integer.toString(baudRate));
        this.propertyChangeSupport.firePropertyChange("PROP_BAUD", oldBaud, baudRate);
    }

    public void setHardware(IHarcHardware hardware) {
        this.hardware = hardware;
        this.openToggleButton.setEnabled(hardware != null);
        this.openToggleButton.setSelected(hardware.isValid());
        this.setVersion();
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        this.version = version;
        this.versionLabel.setEnabled(this.hardware.isValid());
        this.versionLiteralLabel.setEnabled(this.hardware.isValid());
        this.versionLabel.setText(version);
    }

    private void setVersion() {
        try {
            this.setVersion(this.hardware.isValid() ? this.hardware.getVersion() : "<not connected>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setup(String desiredPort) throws IOException {
        ComboBoxModel<String> model = this.portComboBox.getModel();
        if (model == null || model.getSize() == 0 || model.getSize() == 1 && ((String)this.portComboBox.getSelectedItem()).equals(notInitialized)) {
            this.setupPortComboBox(true);
        }
        this.portComboBox.setSelectedItem(desiredPort != null ? desiredPort : this.portName);
    }

    private void setupPortComboBox(boolean useCached) throws IOException {
        if (this.hardware != null) {
            this.hardware.close();
        }
        ArrayList<String> portNames = LocalSerialPort.getSerialPortNames(useCached);
        portNames.add(0, "");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(portNames.toArray(new String[portNames.size()]));
        this.portComboBox.setModel(model);
    }

    public boolean isListenable() {
        return this.listenable;
    }

    private void openClose(boolean opening) throws IOException, HarcHardwareException {
        boolean oldIsOpen = this.hardware.isValid();
        try {
            if (opening) {
                this.hardware.open();
                this.listenable = true;
            } else {
                this.listenable = false;
                this.hardware.close();
            }
            this.enableStuff(opening && this.hardware.isValid());
            this.setVersion();
            this.propertyChangeSupport.firePropertyChange("PROP_ISOPEN", oldIsOpen, this.hardware.isValid());
        }
        catch (Throwable throwable) {
            this.enableStuff(opening && this.hardware.isValid());
            this.setVersion();
            this.propertyChangeSupport.firePropertyChange("PROP_ISOPEN", oldIsOpen, this.hardware.isValid());
            throw throwable;
        }
    }

    private void enableStuff(boolean isOpen) {
        this.baudComboBox.setEnabled(!isOpen && this.settableBaudRate);
        this.portComboBox.setEnabled(!isOpen);
    }

    private Cursor setBusyCursor() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        return oldCursor;
    }

    private void resetCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    private void initComponents() {
        this.portComboBox = new JComboBox();
        this.refreshButton = new JButton();
        this.jLabel1 = new JLabel();
        this.openToggleButton = new JToggleButton();
        this.versionLiteralLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.baudComboBox = new JComboBox();
        this.baudRateLabel = new JLabel();
        this.setPreferredSize(new Dimension(800, 80));
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{notInitialized}));
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSimpleBean.this.portComboBoxActionPerformed(evt);
            }
        });
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/reload.png")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Reload list of available serial ports.");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSimpleBean.this.refreshButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Serial Port");
        this.openToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/connect_creating.png")));
        this.openToggleButton.setText("Open");
        this.openToggleButton.setToolTipText("Open or close connection to device.");
        this.openToggleButton.setEnabled(false);
        this.openToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSimpleBean.this.openToggleButtonActionPerformed(evt);
            }
        });
        this.versionLiteralLabel.setText("Ver:");
        this.versionLiteralLabel.setToolTipText("Version of the firmware on the device, if supported by the device. Verifies that the connection is working.");
        this.versionLiteralLabel.setEnabled(false);
        this.versionLabel.setHorizontalAlignment(4);
        this.versionLabel.setText("no version available");
        this.versionLabel.setToolTipText("Version of firmware on device. Serves to verify the connection.");
        this.versionLabel.setBorder(new SoftBevelBorder(1));
        this.versionLabel.setEnabled(false);
        this.versionLabel.setHorizontalTextPosition(4);
        this.baudComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"115200", "57600", "38400", "19200", "9600", "4800", "2400", "1200"}));
        this.baudComboBox.setSelectedItem("9600");
        this.baudComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialPortSimpleBean.this.baudComboBoxActionPerformed(evt);
            }
        });
        this.baudRateLabel.setText("bits/s");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.portComboBox, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.baudComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openToggleButton).addGap(6, 6, 6).addComponent(this.versionLiteralLabel, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel, -1, 254, Short.MAX_VALUE)).addComponent(this.baudRateLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.baudRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.refreshButton).addComponent(this.openToggleButton).addComponent(this.versionLiteralLabel).addComponent(this.versionLabel).addComponent(this.baudComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButtonActionPerformed(ActionEvent evt) {
        Cursor oldCursor = this.setBusyCursor();
        try {
            this.setupPortComboBox(false);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.resetCursor(oldCursor);
        }
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.setPortName((String)this.portComboBox.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openToggleButtonActionPerformed(ActionEvent evt) {
        Cursor oldCursor = this.setBusyCursor();
        boolean opening = this.openToggleButton.isSelected();
        try {
            this.openClose(opening);
        }
        catch (IOException | HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.openToggleButton.setSelected(this.hardware.isValid());
            this.resetCursor(oldCursor);
        }
    }

    private void baudComboBoxActionPerformed(ActionEvent evt) {
        this.setBaudRate(Integer.parseInt((String)this.baudComboBox.getSelectedItem()));
    }
}

