/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.guicomponents.CopyPastePopupMenu;
import org.harctoolbox.guicomponents.HarcPanel;
import org.harctoolbox.guicomponents.StatusLine;

public class TimeFrequencyCalculator
extends HarcPanel {
    private static final String helpText = "This pane computes, for a carrier frequency given either in Hz or as a Pronto code\n(i.e., the second number in the CCF), either the time for a given number of periods\n(entered as decimal or hexadecimal), or the number of periods as a function of the time entered.\n\nMathematically, time = no_periods/frequency.";
    public static final String versionString = "0.3.0";
    public static final String aboutText = "HexCalculator version 0.3.0.\nCopyright 2012, 2013 by Bengt Martensson.\n\nLicense: GPL3.\n\nProject home page: http://www.harctoolbox.org";
    private static final int seconds2microseconds = 1000000;
    private CopyPastePopupMenu copyPastePopupMenu;
    private JTextField frequencyTextField;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel39;
    private JTextField noPeriodsHexTextField;
    private JTextField noPeriodsTextField;
    private JTextField prontocodeTextField;
    private StatusLine statusLine;
    private JTextField timeTextField;

    public TimeFrequencyCalculator() {
        this.initComponents();
    }

    private void updateFromFrequency() {
        try {
            int freq = Integer.parseInt(this.frequencyTextField.getText());
            this.prontocodeTextField.setText(Pronto.formatInteger(Pronto.getProntoCode(freq)));
            this.updateFromFrequency(freq);
        }
        catch (NumberFormatException ex) {
            this.statusLine.setStatus("Cannot parse `" + this.frequencyTextField.getText() + "'");
        }
    }

    private void updateFromFrequencycode() {
        try {
            int freq = (int)Pronto.getFrequency(Integer.parseInt(this.prontocodeTextField.getText(), 16));
            this.frequencyTextField.setText(Integer.toString(freq));
            this.updateFromFrequency(freq);
        }
        catch (NumberFormatException ex) {
            this.statusLine.setStatus("Cannot parse `" + this.prontocodeTextField.getText() + "'");
        }
    }

    private void updateFromFrequency(int freq) {
        int time = Integer.parseInt(this.timeTextField.getText());
        this.noPeriodsTextField.setText(String.format("%.1f", (double)(time * freq) / 1000000.0));
        this.statusLine.setStatus(null);
    }

    private void selectPeriodTime(boolean selectPeriod, boolean useHex) {
        this.noPeriodsTextField.setEditable(selectPeriod && !useHex);
        this.noPeriodsHexTextField.setEditable(selectPeriod && useHex);
        this.timeTextField.setEditable(!selectPeriod);
    }

    private void initComponents() {
        this.copyPastePopupMenu = new CopyPastePopupMenu(true);
        this.jLabel24 = new JLabel();
        this.frequencyTextField = new JTextField();
        this.prontocodeTextField = new JTextField();
        this.jLabel23 = new JLabel();
        this.jLabel39 = new JLabel();
        this.timeTextField = new JTextField();
        this.jLabel25 = new JLabel();
        this.noPeriodsHexTextField = new JTextField();
        this.jLabel22 = new JLabel();
        this.noPeriodsTextField = new JTextField();
        this.statusLine = new StatusLine();
        this.jLabel24.setText("Time (microseconds)");
        this.frequencyTextField.setHorizontalAlignment(4);
        this.frequencyTextField.setText("40000");
        this.frequencyTextField.setToolTipText("Enter modulation frequency here, then press return.");
        this.frequencyTextField.setMinimumSize(new Dimension(100, 27));
        this.frequencyTextField.setPreferredSize(new Dimension(100, 27));
        this.frequencyTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TimeFrequencyCalculator.this.frequencyTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TimeFrequencyCalculator.this.frequencyTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.frequencyTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFrequencyCalculator.this.frequencyTextFieldActionPerformed(evt);
            }
        });
        this.frequencyTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeFrequencyCalculator.this.frequencyTextFieldFocusLost(evt);
            }
        });
        this.prontocodeTextField.setHorizontalAlignment(4);
        this.prontocodeTextField.setText("0");
        this.prontocodeTextField.setToolTipText("Enter Pronto frequency code here, then press return.");
        this.prontocodeTextField.setMinimumSize(new Dimension(100, 27));
        this.prontocodeTextField.setPreferredSize(new Dimension(100, 27));
        this.prontocodeTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TimeFrequencyCalculator.this.prontocodeTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TimeFrequencyCalculator.this.prontocodeTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.prontocodeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFrequencyCalculator.this.prontocodeTextFieldActionPerformed(evt);
            }
        });
        this.prontocodeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeFrequencyCalculator.this.prontocodeTextFieldFocusLost(evt);
            }
        });
        this.jLabel23.setText("# Periods (dec)");
        this.jLabel39.setText("hex");
        this.timeTextField.setEditable(false);
        this.timeTextField.setHorizontalAlignment(4);
        this.timeTextField.setText("0");
        this.timeTextField.setToolTipText("Duration in microseconds");
        this.timeTextField.setMinimumSize(new Dimension(100, 27));
        this.timeTextField.setPreferredSize(new Dimension(100, 27));
        this.timeTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TimeFrequencyCalculator.this.timeTextFieldMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TimeFrequencyCalculator.this.timeTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TimeFrequencyCalculator.this.timeTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.timeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFrequencyCalculator.this.timeTextFieldActionPerformed(evt);
            }
        });
        this.timeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeFrequencyCalculator.this.timeTextFieldFocusLost(evt);
            }
        });
        this.jLabel25.setText("Pronto");
        this.noPeriodsHexTextField.setEditable(false);
        this.noPeriodsHexTextField.setHorizontalAlignment(4);
        this.noPeriodsHexTextField.setText("1");
        this.noPeriodsHexTextField.setToolTipText("Click to enable");
        this.noPeriodsHexTextField.setMinimumSize(new Dimension(100, 27));
        this.noPeriodsHexTextField.setPreferredSize(new Dimension(100, 27));
        this.noPeriodsHexTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsHexTextFieldMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsHexTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsHexTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.noPeriodsHexTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsHexTextFieldActionPerformed(evt);
            }
        });
        this.noPeriodsHexTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsHexTextFieldFocusLost(evt);
            }
        });
        this.jLabel22.setText("Freq. (Hz)");
        this.noPeriodsTextField.setHorizontalAlignment(4);
        this.noPeriodsTextField.setText("1");
        this.noPeriodsTextField.setToolTipText("Number of periods in selected frequency");
        this.noPeriodsTextField.setMinimumSize(new Dimension(100, 27));
        this.noPeriodsTextField.setPreferredSize(new Dimension(100, 27));
        this.noPeriodsTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsTextFieldMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsTextFieldgenericCopyPasteMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsTextFieldgenericCopyPasteMenu1(evt);
            }
        });
        this.noPeriodsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsTextFieldActionPerformed(evt);
            }
        });
        this.noPeriodsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeFrequencyCalculator.this.noPeriodsTextFieldFocusLost(evt);
            }
        });
        this.statusLine.setText("statusLine1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel24, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frequencyTextField, -2, 67, -2).addComponent(this.noPeriodsTextField, -2, 67, -2).addComponent(this.jLabel23).addComponent(this.jLabel22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel25, GroupLayout.Alignment.TRAILING).addComponent(this.prontocodeTextField, GroupLayout.Alignment.TRAILING, -2, 60, -2).addComponent(this.jLabel39, GroupLayout.Alignment.TRAILING).addComponent(this.noPeriodsHexTextField, GroupLayout.Alignment.TRAILING, -2, 66, -2))).addComponent(this.timeTextField, -2, 67, -2)).addGap(0, 25, Short.MAX_VALUE)).addComponent(this.statusLine, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.jLabel25)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.frequencyTextField, -2, -1, -2).addComponent(this.prontocodeTextField, -2, -1, -2)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel23).addComponent(this.jLabel39)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noPeriodsTextField, -2, -1, -2).addComponent(this.noPeriodsHexTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addComponent(this.statusLine, -2, 29, -2)));
    }

    private void frequencyTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void frequencyTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void frequencyTextFieldActionPerformed(ActionEvent evt) {
        this.updateFromFrequency();
    }

    private void frequencyTextFieldFocusLost(FocusEvent evt) {
        this.updateFromFrequency();
    }

    private void prontocodeTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void prontocodeTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void prontocodeTextFieldActionPerformed(ActionEvent evt) {
        this.updateFromFrequencycode();
    }

    private void prontocodeTextFieldFocusLost(FocusEvent evt) {
        this.updateFromFrequencycode();
    }

    private void timeTextFieldMouseEntered(MouseEvent evt) {
        this.selectPeriodTime(false, false);
    }

    private void timeTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void timeTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void timeTextFieldActionPerformed(ActionEvent evt) {
        try {
            int time = Integer.parseInt(this.timeTextField.getText());
            int freq = Integer.parseInt(this.frequencyTextField.getText());
            double periods = (double)time * (double)freq / 1000000.0;
            this.noPeriodsTextField.setText(String.format("%.1f", periods));
            this.noPeriodsHexTextField.setText(String.format("%04X", Math.round(periods)));
        }
        catch (NumberFormatException ex) {
            this.statusLine.setStatus("Cannot parse `" + this.timeTextField.getText() + "'");
        }
    }

    private void timeTextFieldFocusLost(FocusEvent evt) {
        this.timeTextFieldActionPerformed(null);
    }

    private void noPeriodsHexTextFieldMouseEntered(MouseEvent evt) {
        this.selectPeriodTime(true, true);
    }

    private void noPeriodsHexTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void noPeriodsHexTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void noPeriodsHexTextFieldActionPerformed(ActionEvent evt) {
        try {
            int noPeriods = Integer.parseInt(this.noPeriodsHexTextField.getText(), 16);
            this.noPeriodsTextField.setText(String.format("%d", noPeriods));
            int freq = Integer.parseInt(this.frequencyTextField.getText());
            this.timeTextField.setText(Integer.toString((int)(1000000.0 * (double)noPeriods / (double)freq)));
        }
        catch (NumberFormatException ex) {
            this.statusLine.setStatus("Cannot parse `" + this.noPeriodsHexTextField.getText() + "'");
        }
    }

    private void noPeriodsHexTextFieldFocusLost(FocusEvent evt) {
        this.noPeriodsHexTextFieldActionPerformed(null);
    }

    private void noPeriodsTextFieldMouseEntered(MouseEvent evt) {
        this.selectPeriodTime(true, false);
    }

    private void noPeriodsTextFieldgenericCopyPasteMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void noPeriodsTextFieldgenericCopyPasteMenu1(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.copyPastePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void noPeriodsTextFieldActionPerformed(ActionEvent evt) {
        try {
            double noPeriods = Double.parseDouble(this.noPeriodsTextField.getText());
            this.noPeriodsHexTextField.setText(String.format("%04X", Math.round(noPeriods)));
            int freq = Integer.parseInt(this.frequencyTextField.getText());
            this.timeTextField.setText(Integer.toString((int)(1000000.0 * noPeriods / (double)freq)));
        }
        catch (NumberFormatException ex) {
            this.statusLine.setStatus("Cannot parse `" + this.noPeriodsTextField.getText() + "'");
        }
    }

    private void noPeriodsTextFieldFocusLost(FocusEvent evt) {
        this.noPeriodsTextFieldActionPerformed(null);
    }

    @Override
    public String getHelpMessage() {
        return helpText;
    }

    @Override
    public String getAboutMessage() {
        return aboutText;
    }

    @Override
    public String getProgName() {
        return "TimeFrequencyCalculator";
    }

    @Override
    public String getIconPath() {
        return "/icons/Crystal-Clear/22x22/apps/xclock.png";
    }

    @Override
    public void close() throws IOException {
    }
}

