/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.comm.TcpSocketPort;

public class FramedDevice {
    private ICommandLineDevice hardware;
    private IFramer framer;

    public static void main(String[] args) {
        try (TcpSocketPort denon = new TcpSocketPort("denon", 23, 2000, true, TcpSocketPort.ConnectionMode.keepAlive);){
            FramedDevice commandLineDevice = new FramedDevice(denon, "{0}\r", true);
            String[] result = commandLineDevice.sendString("mvdown", 1, 0);
            System.out.println(result[0]);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public FramedDevice(ICommandLineDevice hardware, IFramer framer) {
        this.hardware = hardware;
        this.framer = framer;
    }

    public FramedDevice(ICommandLineDevice hardware, String format, boolean touppercase) {
        this(hardware, new Framer(format, touppercase));
    }

    public FramedDevice(ICommandLineDevice hardware, String format) {
        this(hardware, new Framer(format, false));
    }

    public FramedDevice(ICommandLineDevice hardware) {
        this(hardware, new Framer());
    }

    public String[] sendString(String[] cmds, int count, int returnLines, int delay, int waitForAnswer) throws IOException {
        if (count < 1) {
            throw new IllegalArgumentException("Count = " + count + " < 1; this is meaningless.");
        }
        boolean sentStuff = false;
        try {
            for (String cmd : cmds) {
                sentStuff = true;
                String command = this.framer.frame(cmd);
                for (int c = 0; c < count; ++c) {
                    if (delay > 0 && c > 0) {
                        Thread.sleep(delay);
                    }
                    this.hardware.sendString(command);
                }
            }
            if (returnLines == 0) {
                return new String[0];
            }
            if (returnLines > 0) {
                String[] result = new String[returnLines];
                for (int i = 0; i < returnLines; ++i) {
                    result[i] = this.hardware.readString(sentStuff);
                }
                return result;
            }
            if (!this.hardware.ready() && waitForAnswer > 0) {
                Thread.sleep(waitForAnswer);
            }
            ArrayList<String> answer = new ArrayList<String>(16);
            while (this.hardware.ready()) {
                String ans = this.hardware.readString(false);
                answer.add(ans);
            }
            return answer.toArray(new String[answer.size()]);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public String[] sendString(String cmd, int returnLines, int waitForAnswer) throws IOException {
        return this.sendString(new String[]{cmd}, 1, returnLines, 0, waitForAnswer);
    }

    public void sendString(String cmd) throws IOException {
        this.sendString(cmd, 0, 0);
    }

    public boolean ready() throws IOException {
        return this.hardware.ready();
    }

    public String readString() throws IOException {
        return this.hardware.readString();
    }

    public String readString(boolean wait) throws IOException {
        return this.hardware.readString(wait);
    }

    public String getVersion() throws IOException {
        return this.hardware.getVersion();
    }

    public void setVerbosity(boolean verbosity) {
        this.hardware.setVerbosity(verbosity);
    }

    public void setDebug(int debug) {
        this.hardware.setDebug(debug);
    }

    public void setTimeout(int timeout) throws IOException {
        this.hardware.setTimeout(timeout);
    }

    public boolean isValid() {
        return this.hardware.isValid();
    }

    public void open() throws HarcHardwareException, IOException {
        this.hardware.open();
    }

    public void close() throws IOException {
        this.hardware.close();
    }

    public static class Framer
    implements IFramer {
        private MessageFormat format;
        private final boolean toUpper;

        public Framer(String format, boolean toUpper) {
            this.format = new MessageFormat(format, IrpUtils.dumbLocale);
            this.toUpper = toUpper;
        }

        public Framer() {
            this("{0}", false);
        }

        @Override
        public String frame(String arg) {
            return this.frame(new Object[]{this.toUpper ? arg.toUpperCase(IrpUtils.dumbLocale) : arg});
        }

        @Override
        public String frame(Object[] args) {
            return this.format.format(args, new StringBuffer(256), new FieldPosition(0)).toString();
        }
    }

    public static interface IFramer {
        public String frame(String var1);

        public String frame(Object[] var1);
    }
}

