/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.harctoolbox.harchardware.FramedDevice;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.comm.UdpSocketPort;
import org.harctoolbox.harchardware.comm.UrlPort;
import org.harctoolbox.harchardware.ir.GlobalCache;

public class MainString {
    private static final int defaultPortNumber = 1;
    private static JCommander argumentParser;
    private static final CommandLineArgs commandLineArgs;

    private static String join(Iterable<String> arr, String separator) {
        StringBuilder result = new StringBuilder(32);
        for (String s : arr) {
            result.append(result.length() == 0 ? "" : separator).append(s);
        }
        return result.toString();
    }

    private static int noTrue(boolean ... bool) {
        int sum = 0;
        for (boolean b : bool) {
            if (!b) continue;
            ++sum;
        }
        return sum;
    }

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(128);
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        MainString.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("HarcHardware");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            MainString.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            MainString.usage(0);
        }
        if (commandLineArgs.versionRequested) {
            System.out.println("HarcHardware version 1.3");
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.out.println();
            System.out.println("Copyright (C) 2011, 2012, 2013, 2014, 2015, 2016 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.");
            System.exit(0);
        }
        if (MainString.noTrue(commandLineArgs.url, commandLineArgs.serial, commandLineArgs.globalcache, commandLineArgs.tcp, commandLineArgs.udp) != 1) {
            System.err.println("Exactly one of --serial, --globalcache, --udp, --url, and --tcp must be given.");
            System.exit(1);
        }
        boolean didSomethingUseful = false;
        try {
            int returnLines;
            ICommandLineDevice hardware;
            if (commandLineArgs.globalcache) {
                GlobalCache globalCache = new GlobalCache(commandLineArgs.ip, commandLineArgs.verbose, commandLineArgs.timeout, false);
                hardware = globalCache.getSerialPort(commandLineArgs.portNumber);
            } else if (commandLineArgs.url) {
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for URL.");
                    System.exit(1);
                }
                UrlPort urlPort = new UrlPort("http", commandLineArgs.ip, commandLineArgs.portNumber, null, null, commandLineArgs.timeout, commandLineArgs.verbose);
                hardware = urlPort;
            } else if (commandLineArgs.tcp) {
                if (commandLineArgs.portNumber == 1) {
                    System.err.println("Must give a sensible port number for TCP.");
                    System.exit(1);
                }
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for TCP.");
                    System.exit(1);
                }
                TcpSocketPort tcpPort = new TcpSocketPort(commandLineArgs.ip, commandLineArgs.portNumber, commandLineArgs.timeout, commandLineArgs.verbose, TcpSocketPort.ConnectionMode.keepAlive);
                hardware = tcpPort;
            } else if (commandLineArgs.udp) {
                if (commandLineArgs.portNumber == 1) {
                    System.err.println("Must give a sensible port number for UDP.");
                    System.exit(1);
                }
                if (commandLineArgs.ip == null) {
                    System.err.println("Must give a sensible hostname for UDP.");
                    System.exit(1);
                }
                if (commandLineArgs.myIp == null) {
                    System.err.print("No own IP address given, let's try the environment...");
                    String localIpAddress = Utils.getHostname();
                    System.err.println("using \"" + localIpAddress + "\"");
                }
                UdpSocketPort udpPort = new UdpSocketPort(commandLineArgs.ip, commandLineArgs.portNumber, commandLineArgs.timeout, commandLineArgs.verbose);
                hardware = udpPort;
            } else if (commandLineArgs.serial) {
                if (commandLineArgs.device == null) {
                    System.err.println("Device name not given.");
                    System.exit(1);
                }
                LocalSerialPortBuffered localSerialPortBuffered = new LocalSerialPortBuffered(commandLineArgs.device, commandLineArgs.baud, commandLineArgs.timeout, commandLineArgs.verbose);
                hardware = localSerialPortBuffered;
            } else {
                hardware = null;
            }
            FramedDevice.Framer framer = new FramedDevice.Framer(commandLineArgs.prefix + "{0}" + commandLineArgs.suffix + (commandLineArgs.appendReturn ? "\r" : "") + (commandLineArgs.appendNewline ? "\n" : ""), commandLineArgs.toUpper);
            if (commandLineArgs.parameters.isEmpty() && didSomethingUseful) {
                System.exit(0);
            }
            if (hardware == null) {
                System.err.println("hardware not assigned.");
                System.exit(3);
            }
            hardware.open();
            if (commandLineArgs.openDelay > 0) {
                try {
                    Thread.sleep(commandLineArgs.openDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            FramedDevice stringCommander = new FramedDevice(hardware, framer);
            int n = commandLineArgs.oneLine ? 1 : (returnLines = commandLineArgs.twoLines ? 2 : 0);
            if (commandLineArgs.parameters.isEmpty()) {
                System.err.println("This version does not support interactive mode; must give at least one argument");
                System.exit(1);
            } else {
                String[] result;
                String command = framer.frame(MainString.join(commandLineArgs.parameters, " "));
                for (String s : result = stringCommander.sendString(new String[]{command}, commandLineArgs.count, returnLines, commandLineArgs.delay, 0)) {
                    System.out.println(s);
                }
            }
            hardware.close();
        }
        catch (PortInUseException | UnsupportedCommOperationException | IOException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (NoSuchPortException ex) {
            System.err.println("No such port: " + ex.getMessage());
            System.exit(3);
        }
    }

    private MainString() {
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-1"}, description="Expect one line of response")
        private boolean oneLine;
        @Parameter(names={"-2"}, description="Expect two line of response")
        private boolean twoLines;
        @Parameter(names={"-#", "--count"}, description="Number of times to send sequence")
        private int count = 1;
        @Parameter(names={"-b", "--baud"}, description="Baud rate for the serial port")
        private int baud = 115200;
        @Parameter(names={"--delay"}, description="Delay between commands in milliseconds")
        private int delay = 0;
        @Parameter(names={"-d", "--device"}, description="Device name for serial device")
        private String device = null;
        @Parameter(names={"-g", "--globalcache"}, description="Use GlobalCache")
        private boolean globalcache = false;
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"--http", "--url"}, description="Use URLs (http)")
        private boolean url = false;
        @Parameter(names={"-i", "--ip"}, description="IP address or name")
        private String ip = null;
        @Parameter(names={"--opendelay"}, description="Delay after opening, in milliseconds")
        private int openDelay = 0;
        @Parameter(names={"-m", "--myip"}, description="For UPD only: IP number to listen to")
        private String myIp = null;
        @Parameter(names={"-p", "--port"}, description="Port number, either TCP port number, or serial port number (counting the first as 1).")
        private int portNumber = 1;
        @Parameter(names={"--prefix"}, description="Prefix to be prepended to all sent commands.")
        private String prefix = "";
        @Parameter(names={"-n", "--newline"}, description="Append a newline at the end of the command.")
        private boolean appendNewline;
        @Parameter(names={"-r", "--return"}, description="Append a carrage return at the end of the command.")
        private boolean appendReturn;
        @Parameter(names={"-s", "--serial"}, description="Use local serial port.")
        private boolean serial;
        @Parameter(names={"--suffix"}, description="Sufffix to be appended to all sent commands.")
        private String suffix = "";
        @Parameter(names={"-t", "--tcp"}, description="Use tcp sockets")
        private boolean tcp;
        @Parameter(names={"-T", "--timeout"}, description="Timeout in milliseconds")
        private int timeout = 15000;
        @Parameter(names={"-u", "--upper"}, description="Translate commands to upper case.")
        private boolean toUpper;
        @Parameter(names={"--udp"}, description="Use Udp sockets.")
        private boolean udp;
        @Parameter(names={"-v", "--version"}, description="Display version information")
        private boolean versionRequested;
        @Parameter(names={"-V", "--verbose"}, description="Turn on verbose reporting")
        private boolean verbose;
        @Parameter(description="[parameters]")
        private ArrayList<String> parameters = new ArrayList(16);

        private CommandLineArgs() {
        }
    }
}

