/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.harchardware.TimeoutException;

public class Utils {
    public static final int invalid = -1;

    public static String getHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null) {
            hostname = System.getenv("HOSTNAME");
        }
        if (hostname == null) {
            hostname = System.getenv("COMPUTERNAME");
        }
        return hostname;
    }

    public static String getMacAddress(InetAddress address) {
        try {
            byte[] mac;
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            StringBuilder macAddress = new StringBuilder(32);
            if (ni != null && (mac = ni.getHardwareAddress()) != null) {
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i == mac.length - 1 ? "" : "-"));
                }
            }
            return macAddress.toString();
        }
        catch (SocketException ex) {
            return null;
        }
    }

    public static byte[] readBytes(InputStream inStream, int length) throws TimeoutException, IOException {
        int bytesRead;
        byte[] result = new byte[length];
        for (int index = 0; index < length; index += bytesRead) {
            bytesRead = inStream.read(result, index, length - index);
            if (bytesRead != 0) continue;
            throw new TimeoutException("Timeout in readBytes");
        }
        return result;
    }

    public static void main(String[] args) {
        String hostname = Utils.getHostname();
        String macAddress = null;
        try {
            macAddress = Utils.getMacAddress(InetAddress.getByName(hostname));
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
        System.out.println(hostname + " " + macAddress);
    }
}

