/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.beacon;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.harchardware.Utils;

public class AmxBeacon
implements Serializable {
    public static final String broadcastIp = "239.255.250.250";
    public static final int broadcastPort = 9131;
    public static final String beaconPreamble = "AMXB";
    private static final int beaconPeriod = 30000;
    private final String payload;

    private static String pack(String key, String value) {
        return "<" + key + "=" + value + ">";
    }

    private static String createPayload(String uuid, String utility, String make, String model, String revision, String configName, String configUrl) {
        return beaconPreamble + AmxBeacon.pack("-UUID", uuid) + AmxBeacon.pack("-SDKClass", utility) + AmxBeacon.pack("-Make", make) + AmxBeacon.pack("-Model", model) + AmxBeacon.pack("-Revision", revision) + AmxBeacon.pack("Config-Name", configName) + AmxBeacon.pack("Config-URL", configUrl);
    }

    public static void main(String[] args) {
        try {
            String hostname = Utils.getHostname();
            String macAddress = Utils.getMacAddress(InetAddress.getByName(hostname));
            AmxBeacon amx = new AmxBeacon(AmxBeacon.createPayload(hostname + "@" + macAddress, "HarcToolbox", "zzz", "0000", "0.0.0", "xyz", "http://localhost"));
            BeaconThread thread = new BeaconThread(amx);
            thread.start();
        }
        catch (UnknownHostException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public AmxBeacon(String payload) {
        this.payload = payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandUdp() throws UnknownHostException, IOException {
        DatagramSocket sock;
        try {
            sock = new DatagramSocket();
        }
        catch (SocketException ex) {
            System.err.println(ex);
            return;
        }
        try {
            InetAddress addr = InetAddress.getByName(broadcastIp);
            try {
                byte[] buf = this.payload.getBytes("US-ASCII");
                DatagramPacket dp = new DatagramPacket(buf, buf.length, addr, 9131);
                sock.send(dp);
            }
            catch (UnsupportedEncodingException ex) {
                assert (false);
            }
        }
        finally {
            sock.close();
        }
    }

    private static class BeaconThread
    extends Thread {
        AmxBeacon beacon;

        BeaconThread(AmxBeacon beacon) {
            this.beacon = beacon;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.beacon.sendCommandUdp();
                        Thread.sleep(30000L);
                    }
                }
                catch (IOException | InterruptedException ex) {
                    System.err.println(ex.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

