/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import org.harctoolbox.harchardware.comm.InvalidEthernetAddressException;

public class EthernetAddress {
    public static final int noBytes = 6;
    public static final String separator = ":";
    private byte[] data;

    private static byte[] parse(String str) throws InvalidEthernetAddressException {
        try {
            byte[] addr = new byte[6];
            if (str.length() == 12) {
                for (int i = 0; i < 6; ++i) {
                    addr[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * (i + 1)), 16);
                }
            } else {
                String[] chunks = str.split(separator);
                if (chunks.length != 6) {
                    throw new InvalidEthernetAddressException(str);
                }
                int i = 0;
                for (String s : chunks) {
                    addr[i++] = (byte)Integer.parseInt(s, 16);
                }
            }
            return addr;
        }
        catch (NumberFormatException ex) {
            throw new InvalidEthernetAddressException(str);
        }
    }

    public EthernetAddress(byte[] data) throws InvalidEthernetAddressException {
        if (data.length != 6) {
            throw new InvalidEthernetAddressException();
        }
        this.data = new byte[6];
        System.arraycopy(data, 0, this.data, 0, 6);
    }

    public EthernetAddress(String str) throws InvalidEthernetAddressException {
        this(EthernetAddress.parse(str));
    }

    public byte[] toBytes() {
        byte[] answer = new byte[6];
        System.arraycopy(this.data, 0, answer, 0, 6);
        return answer;
    }

    private int byte2uint(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(32);
        for (int i = 0; i < 6; ++i) {
            str.append(Integer.toHexString(this.byte2uint(this.data[i])));
            if (i >= 5) continue;
            str.append(separator);
        }
        return str.toString();
    }
}

