/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;

public abstract class LocalSerialPort
implements IHarcHardware {
    public static final String defaultPort = "/dev/ttyS0";
    private static final int msToWaitForPort = 100;
    private static ArrayList<String> cachedPortNames = null;
    private static final int maxtries = 3;
    protected InputStream inStream;
    protected OutputStream outStream;
    private CommPort commPort;
    private final String portName;
    private final int baud;
    private final int length;
    private final int stopBits;
    private final Parity parity;
    private final FlowControl flowControl;
    private int timeout;
    protected boolean verbose = false;

    public static String getSerialPortName(int portNumber) throws IOException, NoSuchPortException {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        int nr = 0;
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() == 1) {
                ++nr;
            }
            if (nr != portNumber) continue;
            return portIdentifier.getName();
        }
        throw new NoSuchPortException();
    }

    public static ArrayList<String> getSerialPortNames(boolean useCached) throws IOException {
        if (useCached && cachedPortNames != null) {
            return cachedPortNames;
        }
        Enumeration portEnum = null;
        try {
            portEnum = CommPortIdentifier.getPortIdentifiers();
        }
        catch (UnsatisfiedLinkError ex) {
            throw new IOException(ex.getMessage());
        }
        ArrayList<String> names = new ArrayList<String>(8);
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            if (portIdentifier.getPortType() != 1) continue;
            names.add(portIdentifier.getName());
        }
        cachedPortNames = names;
        return names;
    }

    private static String canonicalizePortName(String portName) throws IOException {
        return portName.startsWith("/dev") ? new File(portName).getCanonicalPath() : portName;
    }

    public LocalSerialPort(String portName, int baud, int length, int stopBits, Parity parity, FlowControl flowControl, int timeout) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this.portName = portName;
        this.baud = baud;
        this.length = length;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
        this.timeout = timeout;
    }

    public LocalSerialPort(String portName, int baud) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, 8, 1, Parity.NONE, FlowControl.NONE, 0);
        this.verbose = false;
    }

    public LocalSerialPort(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, 8, 1, Parity.NONE, FlowControl.NONE, 0);
        this.verbose = false;
    }

    public LocalSerialPort(int portNumber) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        this(LocalSerialPort.getSerialPortName(portNumber), 9600, 8, 1, Parity.NONE, FlowControl.NONE, 0);
        this.verbose = false;
    }

    private void lowLevelOpen() throws NoSuchPortException, PortInUseException, IOException {
        String realPath = LocalSerialPort.canonicalizePortName(this.portName);
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(realPath);
        this.commPort = portIdentifier.open(this.getClass().getName(), 100);
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        boolean success = false;
        try {
            this.lowLevelOpen();
            success = true;
        }
        catch (NoSuchPortException | PortInUseException ex) {
            this.commPort = null;
            throw new HarcHardwareException(ex);
        }
        if (!success) {
            throw new HarcHardwareException("Could not open LocalSerialPort " + this.portName);
        }
        if (this.commPort instanceof SerialPort) {
            SerialPort serialPort = (SerialPort)this.commPort;
            try {
                serialPort.setSerialPortParams(this.baud, this.length, this.stopBits, this.parity.ordinal());
            }
            catch (UnsupportedCommOperationException ex) {
                throw new HarcHardwareException(ex);
            }
            this.inStream = serialPort.getInputStream();
            this.outStream = serialPort.getOutputStream();
        }
        if (this.commPort instanceof RXTXPort) {
            ((RXTXPort)this.commPort).setFlowControlMode(this.flowControl.ordinal());
        }
        this.setTimeout();
    }

    public void flushInput() throws IOException {
        while (this.inStream.available() > 0) {
            this.inStream.read();
        }
    }

    @Override
    public boolean isValid() {
        return this.commPort != null;
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        this.timeout = timeout;
        this.setTimeout();
    }

    private void setTimeout() throws IOException {
        if (this.timeout > 0) {
            try {
                this.commPort.enableReceiveTimeout(this.timeout);
            }
            catch (UnsupportedCommOperationException ex) {
                throw new IOException("timeout not supported");
            }
        } else {
            this.commPort.disableReceiveTimeout();
        }
    }

    @Override
    public String getVersion() {
        return "n/a";
    }

    public String getPortName() {
        return this.portName;
    }

    @Override
    public void close() {
        if (!this.isValid()) {
            return;
        }
        try {
            this.inStream.close();
            this.outStream.close();
            this.commPort.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.commPort = null;
        }
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void setDTR(boolean state) {
        if (this.commPort instanceof RXTXPort) {
            ((SerialPort)this.commPort).setDTR(state);
        }
    }

    public void dropDTR(int duration) {
        this.setDTR(false);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setDTR(true);
    }

    public static enum FlowControl {
        NONE,
        RTSCTS_IN,
        RTSCTS_OUT,
        RTSCTS,
        XONXOFF_IN,
        dummy2,
        dummy3,
        dummy4,
        XONXOFF_OUT,
        dummy5,
        dummy6,
        dummy7,
        XONXOFF;

    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN,
        MARK,
        SPACE;

    }
}

