/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.comm.LocalSerialPort;

public final class LocalSerialPortBuffered
extends LocalSerialPort
implements ICommandLineDevice {
    private BufferedReader bufferedInStream;

    public static void main(String[] args) {
        try (LocalSerialPortBuffered port = new LocalSerialPortBuffered("/dev/ttyS0", 9600, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 10000, true);){
            ArrayList<String> names = LocalSerialPortBuffered.getSerialPortNames(false);
            for (String name : names) {
                System.out.println(name);
            }
            String cmd = "#POW\r";
            port.open();
            port.sendString(cmd);
            System.out.println(port.readString());
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public LocalSerialPortBuffered(String portName, int baud, int length, int stopBits, LocalSerialPort.Parity parity, LocalSerialPort.FlowControl flowControl, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(portName, baud, length, stopBits, parity, flowControl, timeout);
        this.verbose = verbose;
    }

    public LocalSerialPortBuffered(String portName, int baud, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, verbose);
    }

    public LocalSerialPortBuffered(String portName, int baud, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, timeout, verbose);
    }

    public LocalSerialPortBuffered(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, false);
    }

    public LocalSerialPortBuffered(int portNumber) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        this(LocalSerialPortBuffered.getSerialPortName(portNumber), 9600, 8, 1, LocalSerialPort.Parity.NONE, LocalSerialPort.FlowControl.NONE, 0, false);
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        super.open();
        this.bufferedInStream = new BufferedReader(new InputStreamReader(this.inStream, IrpUtils.dumbCharset));
    }

    @Override
    public void sendString(String cmd) throws IOException {
        if (this.verbose) {
            System.err.println("LocalSerialPortBuffered.sendString: Sent '" + cmd + "'.");
        }
        this.sendBytes(cmd.getBytes(IrpUtils.dumbCharset));
    }

    public void sendBytes(byte[] data) throws IOException {
        this.outStream.write(data);
    }

    public void sendBytes(byte[] data, int offset, int length) throws IOException {
        this.outStream.write(data, offset, length);
    }

    public void sendByte(byte b) throws IOException {
        this.outStream.write(b);
    }

    @Override
    public String readString() throws IOException {
        return this.readString(false);
    }

    @Override
    public String readString(boolean wait) throws IOException {
        if (!wait && !this.bufferedInStream.ready()) {
            return null;
        }
        try {
            String result = this.bufferedInStream.readLine();
            if (this.verbose) {
                System.err.println("LocalSerialPortBuffered.readString: received " + (result != null ? "\"" + result + "\"" : "<null>"));
            }
            return result;
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                if (this.verbose) {
                    System.err.println("LocalSerialPortBuffered.readString: TIMEOUT");
                }
                return null;
            }
            throw ex;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.bufferedInStream.ready();
    }

    @Override
    public void setDebug(int debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

