/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Ping {
    public static final int defaultTimeout = 2000;
    private int timeout;
    private InetAddress inetAddress;

    public static boolean ping(String hostname) throws UnknownHostException, IOException {
        return new Ping(hostname).ping();
    }

    public static boolean ping(String hostname, int timeout) throws UnknownHostException, IOException {
        return new Ping(hostname, timeout).ping();
    }

    public static void main(String[] args) {
        try {
            boolean result = Ping.ping(args[0]);
            System.out.println(args[0] + " is " + (result ? "alive" : "not alive"));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public Ping(String hostname, int timeout) throws UnknownHostException {
        this.timeout = timeout;
        this.inetAddress = InetAddress.getByName(hostname);
    }

    public Ping(String hostname) throws UnknownHostException {
        this(hostname, 2000);
    }

    public boolean ping() throws IOException {
        return this.inetAddress.isReachable(this.timeout);
    }
}

