/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.IBytesCommand;
import org.harctoolbox.harchardware.comm.TcpSocketPort;

public class TcpSocketChannel
implements ICommandLineDevice,
IBytesCommand {
    private InetAddress inetAddress = null;
    private int portNumber;
    private boolean verbose;
    private int timeout;
    private TcpSocketPort.ConnectionMode connectionMode;
    private Socket socket = null;
    private OutputStream outStream = null;
    private InputStream inStream = null;
    private BufferedReader bufferedInStream = null;

    public TcpSocketChannel(String hostIp, int portNumber, int timeout, boolean verbose, TcpSocketPort.ConnectionMode connectionMode) throws UnknownHostException {
        this(InetAddress.getByName(hostIp), portNumber, timeout, verbose, connectionMode);
    }

    public TcpSocketChannel(InetAddress inetAddress, int portNumber, int timeout, boolean verbose, TcpSocketPort.ConnectionMode connectionMode) {
        this.inetAddress = inetAddress;
        this.portNumber = portNumber;
        this.timeout = timeout;
        this.verbose = verbose;
        this.connectionMode = connectionMode;
    }

    public void connect() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            this.socket = new Socket();
            if (this.verbose) {
                System.err.println("Connecting socket to " + this.inetAddress.getHostAddress() + ":" + this.portNumber);
            }
            this.socket.connect(new InetSocketAddress(this.inetAddress, this.portNumber), this.timeout);
            this.socket.setSoTimeout(this.timeout);
            this.socket.setKeepAlive(this.connectionMode == TcpSocketPort.ConnectionMode.keepAlive);
        }
        if (this.outStream == null) {
            this.outStream = this.socket.getOutputStream();
        }
        if (this.inStream == null) {
            this.inStream = this.socket.getInputStream();
            this.bufferedInStream = new BufferedReader(new InputStreamReader(this.inStream, IrpUtils.dumbCharset));
        }
    }

    public void close(boolean force) throws IOException {
        if (force || this.connectionMode == TcpSocketPort.ConnectionMode.justInTime) {
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
                this.bufferedInStream = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
    }

    public OutputStream getOut() {
        return this.outStream;
    }

    public InputStream getIn() {
        return this.inStream;
    }

    public BufferedReader getBufferedIn() {
        return this.bufferedInStream;
    }

    @Override
    public boolean isValid() {
        return this.socket != null;
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public void sendString(String cmd) throws IOException {
        this.sendBytes(cmd.getBytes(IrpUtils.dumbCharset));
    }

    @Override
    public String readString() throws IOException {
        return this.readString(true);
    }

    @Override
    public String readString(boolean wait) throws IOException {
        if (!wait && !this.bufferedInStream.ready()) {
            if (this.verbose) {
                System.err.println("<(null)");
            }
            return null;
        }
        String line = this.bufferedInStream.readLine();
        if (this.verbose) {
            System.err.println("<" + line);
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public void sendBytes(byte[] cmd) throws IOException {
        this.outStream.write(cmd);
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        return Utils.readBytes(this.inStream, length);
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void open() {
    }

    @Override
    public boolean ready() throws IOException {
        return this.bufferedInStream != null && this.bufferedInStream.ready();
    }

    @Override
    public void flushInput() throws IOException {
        while (this.inStream.available() > 0) {
            this.inStream.read();
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }
}

