/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.IBytesCommand;
import org.harctoolbox.harchardware.comm.TcpSocketChannel;

public class TcpSocketPort
implements ICommandLineDevice,
IBytesCommand,
IHarcHardware {
    public static final int defaultTimeout = 2000;
    private TcpSocketChannel tcpSocketChannel;

    public static void main(String[] args) {
        try (TcpSocketPort port = new TcpSocketPort("denon", 23, 2000, true, ConnectionMode.keepAlive);){
            port.sendString("MVDOWN\r");
            String result = port.readString();
            System.out.println(result);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public TcpSocketPort(String hostIp, int portNumber, int timeout, boolean verbose, ConnectionMode connectionMode) throws UnknownHostException {
        this.tcpSocketChannel = new TcpSocketChannel(hostIp, portNumber, timeout, verbose, connectionMode);
    }

    public TcpSocketPort(String hostIp, int portNumber, boolean verbose, ConnectionMode connectionMode) throws UnknownHostException {
        this.tcpSocketChannel = new TcpSocketChannel(hostIp, portNumber, 2000, verbose, connectionMode);
    }

    @Override
    public void open() throws IOException {
        this.tcpSocketChannel.connect();
    }

    @Override
    public boolean ready() throws IOException {
        return this.tcpSocketChannel.ready();
    }

    @Override
    public void flushInput() throws IOException {
        this.tcpSocketChannel.flushInput();
    }

    @Override
    public void sendBytes(byte[] cmd) throws IOException {
        this.tcpSocketChannel.connect();
        this.tcpSocketChannel.getOut().write(cmd);
        this.tcpSocketChannel.close(false);
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        this.tcpSocketChannel.connect();
        byte[] result = Utils.readBytes(this.tcpSocketChannel.getIn(), length);
        this.tcpSocketChannel.close(false);
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.tcpSocketChannel != null) {
                this.tcpSocketChannel.close(true);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.tcpSocketChannel = null;
        }
    }

    @Override
    public void sendString(String str) throws IOException {
        if (this.tcpSocketChannel.getVerbose()) {
            System.err.println(">" + str);
        }
        this.sendBytes(str.getBytes(IrpUtils.dumbCharset));
    }

    @Override
    public String readString() throws IOException {
        String str = this.readString(true);
        if (this.tcpSocketChannel.getVerbose()) {
            System.err.println("<" + str);
        }
        return str;
    }

    @Override
    public String readString(boolean wait) throws IOException {
        this.tcpSocketChannel.connect();
        String result = this.tcpSocketChannel.readString(wait);
        this.tcpSocketChannel.close(false);
        return result;
    }

    @Override
    public boolean isValid() {
        return this.tcpSocketChannel != null && this.tcpSocketChannel.isValid();
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public void setTimeout(int timeout) {
        try {
            this.tcpSocketChannel.setTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.tcpSocketChannel.setVerbosity(verbose);
    }

    @Override
    public void setDebug(int debug) {
        this.tcpSocketChannel.setDebug(debug);
    }

    public static enum ConnectionMode {
        keepAlive,
        justInTime;

    }
}

