/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.IrpMaster.IrpUtils;

public class UdpSocketChannel {
    private static final int BUFFERSIZE = 65000;
    private final InetAddress inetAddress;
    private final int portNumber;
    private boolean verbose;
    private DatagramSocket socket = null;
    private PrintStream outStream = null;
    private final byte[] byteBuffer = new byte[65000];

    public static void main(String[] args) {
        try {
            UdpSocketChannel ch = new UdpSocketChannel("irtrans", 21000, 2000, true);
            ch.sendString("snd philips_37pfl9603,power_toggle");
            String response = ch.readString();
            System.out.println(response);
            ch.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public UdpSocketChannel(InetAddress inetAddress, int portNumber, int timeout, boolean verbose) throws UnknownHostException, SocketException {
        this.inetAddress = inetAddress;
        this.portNumber = portNumber;
        this.verbose = verbose;
        this.socket = new DatagramSocket();
        this.socket.setSoTimeout(timeout);
        try {
            this.outStream = new PrintStream((OutputStream)new FilteredStream(new ByteArrayOutputStream()), false, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public UdpSocketChannel(String hostIp, int portNumber, int timeout, boolean verbose) throws UnknownHostException, SocketException {
        this(InetAddress.getByName(hostIp), portNumber, timeout, verbose);
    }

    private void send(byte[] buf) throws IOException {
        if (this.verbose) {
            System.err.println("Sending command `" + new String(buf, IrpUtils.dumbCharset) + "' over UDP to " + this.inetAddress.getCanonicalHostName() + ":" + this.portNumber);
        }
        DatagramPacket dp = new DatagramPacket(buf, buf.length, this.inetAddress, this.portNumber);
        this.socket.send(dp);
    }

    public void sendString(String string) throws IOException {
        this.send(string.getBytes("US-ASCII"));
    }

    public void close() throws IOException {
        if (this.outStream != null) {
            this.outStream.close();
            this.outStream = null;
        }
        if (this.socket != null) {
            this.socket.disconnect();
            this.socket.close();
            this.socket = null;
        }
    }

    public PrintStream getOut() {
        return this.outStream;
    }

    public String readString() throws SocketException, IOException {
        DatagramPacket pack = new DatagramPacket(this.byteBuffer, this.byteBuffer.length);
        if (this.verbose) {
            System.err.println("listening at:" + this.portNumber + "...");
        }
        this.socket.receive(pack);
        String payload = new String(pack.getData(), 0, pack.getLength(), IrpUtils.dumbCharset);
        InetAddress a = pack.getAddress();
        int port = pack.getPort();
        if (this.verbose) {
            System.err.println("Got package for " + a + ":" + port + ": " + payload);
        }
        return payload;
    }

    public boolean isValid() {
        return this.socket != null;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(int debug) {
    }

    private class FilteredStream
    extends FilterOutputStream {
        FilteredStream(OutputStream stream) {
            super(stream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            UdpSocketChannel.this.send(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] buf = new byte[len];
            System.arraycopy(b, off, buf, 0, len);
            UdpSocketChannel.this.send(buf);
        }
    }
}

