/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.UdpSocketChannel;

public class UdpSocketPort
implements ICommandLineDevice,
IHarcHardware {
    private UdpSocketChannel udpSocketChannel;

    public static void main(String[] args) {
        try {
            UdpSocketPort port = new UdpSocketPort("irtrans", 21000, 2000, true);
            port.sendString("snd philips_37pfl9603,power_toggle");
            String result = port.readString();
            System.out.println(result);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public UdpSocketPort(String hostIp, int portNumber, int timeout, boolean verbose) throws UnknownHostException, SocketException {
        this.udpSocketChannel = new UdpSocketChannel(hostIp, portNumber, timeout, verbose);
    }

    @Override
    public void close() throws IOException {
        this.udpSocketChannel.close();
        this.udpSocketChannel = null;
    }

    @Override
    public void sendString(String str) throws IOException {
        this.udpSocketChannel.sendString(str);
    }

    @Override
    public String readString() throws IOException {
        return this.udpSocketChannel.readString();
    }

    @Override
    public String readString(boolean wait) throws IOException {
        if (wait) {
            return this.readString();
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean isValid() {
        return this.udpSocketChannel != null && this.udpSocketChannel.isValid();
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public void setTimeout(int timeout) {
        try {
            this.udpSocketChannel.setTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.udpSocketChannel.setVerbosity(verbose);
    }

    @Override
    public void setDebug(int debug) {
        this.udpSocketChannel.setDebug(debug);
    }

    @Override
    public void open() {
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void flushInput() throws IOException {
    }
}

