/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;

public class UrlPort
implements ICommandLineDevice {
    private String answer = null;
    private int timeout;
    private boolean verbose;
    private final String hostIp;
    private final int portNumber;
    private final String prefix;
    private final String suffix;
    private final String protocol;

    public static void main(String[] args) {
        UrlPort port = new UrlPort("http", "t10", -1, "/preset?switch=", "&value=ON", 2000, true);
        try {
            port.sendString("4");
            String str = port.readString();
            System.out.println("-->" + str + "<--");
            str = port.readString();
            System.out.println("-->" + str + "<--");
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public UrlPort(String protocol, String hostIp, int portNumber, String prefix, String suffix, int timeout, boolean verbose) {
        this.protocol = protocol;
        this.hostIp = hostIp;
        this.portNumber = portNumber;
        this.prefix = prefix;
        this.suffix = suffix;
        this.verbose = verbose;
        this.timeout = timeout;
    }

    public void connect() throws IOException {
    }

    @Override
    public void close() {
    }

    @Override
    public void sendString(String payload) throws IOException {
        URL url = new URL(this.protocol, this.hostIp, this.portNumber, this.prefix + payload + this.suffix);
        if (this.verbose) {
            System.err.println("Getting " + url);
        }
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(this.timeout);
        this.answer = (String)connection.getContent();
    }

    @Override
    public String readString() {
        String s = this.answer;
        this.answer = null;
        return s;
    }

    @Override
    public String readString(boolean wait) {
        return this.readString();
    }

    @Override
    public String getVersion() throws IOException {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
    }

    @Override
    public boolean ready() throws IOException {
        return this.answer != null;
    }

    @Override
    public void flushInput() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

