/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.comm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.comm.EthernetAddress;
import org.harctoolbox.harchardware.comm.InvalidEthernetAddressException;
import org.harctoolbox.harchardware.misc.Ethers;

public class Wol {
    private static Ethers ethers = null;
    public static final String defaultIP = "255.255.255.255";
    public static final int defaultPort = 9;
    private EthernetAddress ethernetAddress;
    private boolean verbose = false;
    private InetAddress ip;
    private final int port;

    public static void wol(String str) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str).wol();
    }

    public static void wol(String str, boolean verbose) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str, verbose).wol();
    }

    public static void wol(String str, boolean verbose, InetAddress ip) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str, verbose, ip).wol();
    }

    public static void wol(String str, boolean verbose, InetAddress ip, int port) throws IOException, FileNotFoundException, FileNotFoundException, HarcHardwareException {
        new Wol(str, verbose, ip, port).wol();
    }

    public static void main(String[] args) {
        try {
            int arg_i = 0;
            if (args[arg_i].equals("-f")) {
                int n = ++arg_i;
                ++arg_i;
                String ethersPath = args[n];
                Ethers.setPathname(ethersPath);
            }
            String thing = args[arg_i];
            Wol.wol(thing, true);
        }
        catch (IOException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public Wol(String str) throws FileNotFoundException, HarcHardwareException {
        this(str, false, null, 9);
    }

    public Wol(String str, boolean verbose) throws FileNotFoundException, HarcHardwareException {
        this(str, verbose, null, 9);
    }

    public Wol(String str, boolean verbose, InetAddress ip) throws FileNotFoundException, HarcHardwareException {
        this(str, verbose, ip, 9);
    }

    public Wol(String str, boolean verbose, InetAddress ip, int port) throws FileNotFoundException, HarcHardwareException {
        this.verbose = verbose;
        this.ip = ip;
        this.port = port;
        try {
            if (ip == null) {
                this.ip = InetAddress.getByName(defaultIP);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            this.ethernetAddress = new EthernetAddress(str);
        }
        catch (InvalidEthernetAddressException ex) {
            this.setupEthers();
            String mac = ethers.getMac(str);
            if (mac == null) {
                throw new HarcHardwareException("No MAC address for " + str + " found");
            }
            try {
                this.ethernetAddress = new EthernetAddress(mac);
            }
            catch (InvalidEthernetAddressException ex1) {
                throw new HarcHardwareException("Invalid Ethernet address for " + str + " found (" + mac + ")");
            }
        }
    }

    private synchronized void setupEthers() throws FileNotFoundException {
        if (ethers == null) {
            ethers = new Ethers();
        }
    }

    public String toString() {
        return "wol " + this.ethernetAddress.toString();
    }

    private byte[] createWakeupFrame() {
        byte[] ethernetAddressBytes = this.ethernetAddress.toBytes();
        byte[] wakeupFrame = new byte[6 + 16 * ethernetAddressBytes.length];
        Arrays.fill(wakeupFrame, 0, 6, (byte)-1);
        for (int j = 6; j < wakeupFrame.length; j += ethernetAddressBytes.length) {
            System.arraycopy(ethernetAddressBytes, 0, wakeupFrame, j, ethernetAddressBytes.length);
        }
        return wakeupFrame;
    }

    public void wol() throws SocketException, IOException {
        if (this.verbose) {
            System.err.println("Sent WOL to " + this.ethernetAddress.toString());
        }
        try (DatagramSocket socket = new DatagramSocket();){
            byte[] wakeupFrame = this.createWakeupFrame();
            DatagramPacket packet = new DatagramPacket(wakeupFrame, wakeupFrame.length, this.ip, this.port);
            socket.send(packet);
        }
    }
}

