/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IReceive;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class Arduino
extends IrSerial<LocalSerialPortBuffered>
implements IRawIrSender,
ICapture,
IReceive,
ICommandLineDevice {
    private static final String sendCommand = "send";
    private static final String captureCommand = "analyze";
    private static final String versionCommand = "version";
    public static final String defaultPortName = "/dev/ttyACM0";
    public static final String okString = "OK";
    public static final String timeoutString = ".";
    private static final String separator = " ";
    public static final int defaultBaudRate = 115200;
    private static final int dataSize = 8;
    private static final int stopBits = 1;
    private static final LocalSerialPort.Parity parity = LocalSerialPort.Parity.NONE;
    private static final LocalSerialPort.FlowControl defaultFlowControl = LocalSerialPort.FlowControl.NONE;
    private static final int serialTimeout = 12345;
    private String lineEnding = "\r";
    private double fallbackFrequency = 38000.0;
    private boolean stopRequested = false;
    private String versionString = "n/a";
    private boolean pendingCapture = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String portName = defaultPortName;
        Arduino w = null;
        boolean verbose = true;
        try {
            w = new Arduino(portName, 10000, verbose);
            w.open();
            System.out.println(w.getVersion());
            ModulatedIrSequence seq = w.capture();
            if (seq == null) {
                System.err.println("No input");
                w.close();
                System.exit(1);
            }
            System.out.println(seq);
            DecodeIR.invoke(seq);
        }
        catch (IOException ex) {
            System.err.println("exception: " + ex.toString() + ex.getMessage());
        }
        catch (NoSuchPortException ex) {
            System.err.println("No such port: " + portName);
        }
        catch (UnsupportedCommOperationException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
        catch (PortInUseException ex) {
            System.err.println("Port " + portName + " in use.");
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(0);
    }

    public Arduino() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(defaultPortName, 115200, 5000, 500, 100, false);
    }

    public Arduino(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, 5000, 500, 100, false);
    }

    public Arduino(String portName, int baudRate) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, 5000, 500, 100, false);
    }

    public Arduino(String portName, int baudRate, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, 5000, 500, 100, verbose);
    }

    public Arduino(String portName, int baudRate, int beginTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, beginTimeout, 500, 100, verbose);
    }

    public Arduino(String portName, int beginTimeout, int captureMaxSize, int endingTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, beginTimeout, captureMaxSize, 100, verbose);
    }

    public Arduino(String portName, int baudRate, int beginTimeout, int captureMaxSize, int endingTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(LocalSerialPortBuffered.class, portName, baudRate, 8, 1, parity, defaultFlowControl, 12345, verbose);
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    public void setFallbackFrequency(double fallbackFrequency) {
        this.fallbackFrequency = fallbackFrequency;
    }

    @Override
    public synchronized boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws NoSuchTransmitterException, IrpMasterException, IOException {
        String response;
        String payload = this.formatString(irSignal, count);
        ((LocalSerialPortBuffered)this.serialPort).sendString(payload + this.lineEnding);
        if (this.verbose) {
            System.err.println(payload);
        }
        return (response = ((LocalSerialPortBuffered)this.serialPort).readString(true)) != null && response.trim().equals(okString);
    }

    @Override
    public void open() throws IOException, HarcHardwareException {
        super.open();
        this.waitFor(okString, this.lineEnding, 100, 10);
        ((LocalSerialPortBuffered)this.serialPort).sendString(versionCommand + this.lineEnding);
        this.versionString = ((LocalSerialPortBuffered)this.serialPort).readString(true).trim();
        if (this.verbose) {
            System.err.println("version returned '" + this.versionString + "'.");
        }
    }

    public void waitFor(String goal, String areUThere, int delay, int tries) throws IOException, HarcHardwareException {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.flushIn();
        for (int i = 0; i < tries; ++i) {
            this.sendString(areUThere);
            String answer = this.readString(true);
            if (answer == null) continue;
            if ((answer = answer.trim()).startsWith(goal)) {
                this.flushIn();
                return;
            }
            if (delay <= 0) continue;
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        throw new HarcHardwareException("Hardware not responding");
    }

    private void flushIn() {
        block3: {
            try {
                String junk;
                while ((junk = this.readString()) != null) {
                    if (!this.verbose) continue;
                    System.err.println("LocalSerialPortBuffered.flushIn: junked '" + junk + "'.");
                }
            }
            catch (IOException ex) {
                if (!this.verbose) break block3;
                System.err.println("IOException in LocalSerialPortBuffered.flushIn ignored: " + ex.getMessage());
            }
        }
    }

    private StringBuilder join(IrSequence irSequence, String separator) {
        if (irSequence == null || irSequence.isEmpty()) {
            return new StringBuilder(0);
        }
        StringBuilder str = new StringBuilder(128);
        for (int i = 0; i < irSequence.getLength(); ++i) {
            str.append(separator).append(Integer.toString(irSequence.iget(i)));
        }
        return str;
    }

    private String formatString(IrSignal irSignal, int count) {
        if (irSignal == null) {
            throw new IllegalArgumentException("irSignal cannot be null");
        }
        StringBuilder str = new StringBuilder(sendCommand);
        str.append(separator).append(Integer.toString(count));
        str.append(separator).append(Integer.toString((int)irSignal.getFrequency()));
        str.append(separator).append(Integer.toString(2 * irSignal.getIntroBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getRepeatBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getEndingBursts()));
        str.append((CharSequence)this.join(irSignal.getIntroSequence(), separator));
        str.append((CharSequence)this.join(irSignal.getRepeatSequence(), separator));
        str.append((CharSequence)this.join(irSignal.getEndingSequence(), separator));
        return str.toString();
    }

    @Override
    public String getVersion() {
        return this.versionString;
    }

    @Override
    public void setBeginTimeout(int beginTimeout) throws IOException {
    }

    @Override
    public void setCaptureMaxSize(int captureMaxSize) {
    }

    @Override
    public void setEndTimeout(int endTimeout) {
    }

    @Override
    public ModulatedIrSequence capture() throws IOException, HarcHardwareException {
        if (this.stopRequested) {
            return null;
        }
        if (!this.isValid()) {
            throw new HarcHardwareException("Port not initialized");
        }
        if (!this.pendingCapture) {
            ((LocalSerialPortBuffered)this.serialPort).sendString(captureCommand + this.lineEnding);
            this.pendingCapture = true;
        }
        ModulatedIrSequence seq = null;
        try {
            String str = ((LocalSerialPortBuffered)this.serialPort).readString(true);
            this.pendingCapture = false;
            if (str == null || str.length() == 0 || str.startsWith("null") || str.startsWith(timeoutString)) {
                return null;
            }
            str = str.trim();
            double frequency = this.fallbackFrequency;
            if (str.startsWith("f=")) {
                int indx = str.indexOf(32);
                if (indx < 0) {
                    return null;
                }
                frequency = Integer.parseInt(str.substring(2, indx));
                str = str.substring(indx + 1);
            }
            seq = new ModulatedIrSequence(new IrSequence(str), frequency, -1.0);
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                return null;
            }
            throw ex;
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException(ex);
        }
        return seq;
    }

    @Override
    public boolean stopCapture() {
        this.stopRequested = true;
        return true;
    }

    @Override
    public IrSequence receive() throws HarcHardwareException, IOException, IrpMasterException {
        if (this.stopRequested) {
            return null;
        }
        if (!this.isValid()) {
            throw new HarcHardwareException("Port not initialized");
        }
        IrSequence seq = null;
        try {
            String str = ((LocalSerialPortBuffered)this.serialPort).readString(true);
            if (str == null || str.length() == 0 || str.startsWith("null") || str.startsWith(timeoutString)) {
                return null;
            }
            str = str.trim();
            seq = new IrSequence(str);
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                return null;
            }
            throw ex;
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException(ex);
        }
        return seq;
    }

    @Override
    public boolean stopReceive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
        ((LocalSerialPortBuffered)this.serialPort).dropDTR(100);
    }

    @Override
    public void sendString(String cmd) throws IOException {
        ((LocalSerialPortBuffered)this.serialPort).sendString(cmd);
    }

    @Override
    public String readString() throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).readString();
    }

    @Override
    public String readString(boolean wait) throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).readString(wait);
    }

    @Override
    public boolean ready() throws IOException {
        return ((LocalSerialPortBuffered)this.serialPort).ready();
    }

    @Override
    public void setDebug(int debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void flushInput() throws IOException {
        ((LocalSerialPortBuffered)this.serialPort).flushInput();
    }
}

