/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortRaw;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.harchardware.ir.Transmitter;

public class CommandFusion
extends IrSerial<LocalSerialPortRaw>
implements IRawIrSender,
ICapture {
    private static final int defaultEndTimeout = -1;
    private static final int defaultSerialTimeout = 30000;
    private static final int middleTimeout = 2000;
    private static final int portId = 1;
    private static final byte[] introBytes = new byte[]{-14, 1, -13};
    private static final byte middleToken = -12;
    private static final byte endingToken = -11;
    private static final byte transmitToken = 84;
    private static final byte receiveToken = 82;
    private static final byte queryToken = 81;
    private static final int commandLength = 3;
    private static final String learnerName = "IRL";
    private static final String sendCommand = "SND";
    private static final String captureCommand = "LIR";
    private static final String readCommand = "RIR";
    private static final String versionCommand = "WHO";
    private static final String timeout = "TIMEOUT";
    private static final String start = "START";
    private static final String signal = "SIGNAL";
    private static final String ircode = "IRCODE";
    private static final String end = "END";
    private static final int tick = 25;
    public static final String defaultPortName = "/dev/ttyUSB0";
    public static final int defaultBaudRate = 115200;
    private static final int dataSize = 8;
    private static final int stopBits = 1;
    private static final LocalSerialPort.Parity parity = LocalSerialPort.Parity.NONE;
    private static final LocalSerialPort.FlowControl defaultFlowControl = LocalSerialPort.FlowControl.NONE;
    private boolean stopRequested = false;
    private int serialTimeout = 30000;
    private String versionString = "n/a";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String portName = defaultPortName;
        CommandFusion commandFusion = null;
        boolean verbose = true;
        boolean send = true;
        try {
            commandFusion = new CommandFusion(portName, verbose);
            commandFusion.open();
            System.out.println("Version: " + commandFusion.getVersion());
            if (send) {
                IrSignal irSignal = new IrSignal("/local/irscrutinizer/IrpProtocols.ini", "rc5", "D=0 F=0");
                boolean success = commandFusion.sendIr(irSignal, 1, null);
                System.out.println(success ? "Sending succeeded" : "Sending failed");
            } else {
                System.out.println("Press a key");
                ModulatedIrSequence seq = commandFusion.capture();
                if (seq == null) {
                    System.err.println("No input");
                    commandFusion.close();
                    System.exit(1);
                }
                System.out.println(seq);
                DecodeIR.invoke(seq);
            }
        }
        catch (IOException ex) {
            System.err.println("exception: " + ex.toString() + ex.getMessage());
        }
        catch (NoSuchPortException ex) {
            System.err.println("No such port: " + portName);
        }
        catch (PortInUseException ex) {
            System.err.println("Port " + portName + " in use.");
        }
        catch (UnsupportedCommOperationException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
        catch (IrpMasterException ex) {
            Logger.getLogger(CommandFusion.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (commandFusion != null) {
                try {
                    commandFusion.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
        System.exit(0);
    }

    public CommandFusion() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(defaultPortName, 115200, 5000, false);
    }

    public CommandFusion(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, 5000, false);
    }

    public CommandFusion(String portName, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 115200, 5000, verbose);
    }

    public CommandFusion(String portName, int baudRate, int beginTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(LocalSerialPortRaw.class, portName, baudRate, 8, 1, parity, defaultFlowControl, beginTimeout, verbose);
        this.serialTimeout = beginTimeout;
    }

    @Override
    public void setDebug(int debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        Payload payload;
        try {
            super.open();
            this.send(this.encode(versionCommand, "", (byte)81));
            byte[] response = this.readUntilTwoEndTokens();
            payload = this.decode(response, (byte)82);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this.verbose) {
            System.err.println("<Received " + payload);
        }
        if (payload == null) {
            this.close();
            throw new HarcHardwareException("Cannot open CommandFusion.");
        }
        if (payload.command.equals(versionCommand)) {
            String[] s = payload.data.split(":");
            this.versionString = s[2];
        }
    }

    public boolean sendIr(int deviceType, int codeset, int key) throws IOException {
        return this.sendIr(this.encode(sendCommand, String.format("P%02d:DBA:%02d:%04d:%02d", 1, deviceType, codeset, key)));
    }

    @Override
    public boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws IncompatibleArgumentException, IOException {
        return this.sendIr(this.encode(irSignal, count));
    }

    private synchronized boolean sendIr(byte[] data) throws IOException {
        this.send(data);
        return this.expect(sendCommand, "") == Status.ok;
    }

    private Status expect(String command, String data) throws IOException {
        byte[] response = this.readUntilTwoEndTokens();
        Payload payload = this.decode(response, (byte)82);
        if (this.verbose) {
            System.err.println("<Received " + payload);
        }
        return payload == null ? Status.error : (payload.data.equals(timeout) ? Status.timeout : (payload.command.equals(command) && payload.data.equals(data) ? Status.ok : Status.error));
    }

    private byte[] encode(IrSignal irSignal, int count) throws IncompatibleArgumentException {
        if (irSignal == null) {
            throw new IllegalArgumentException("irSignal cannot be null");
        }
        String data = "P0" + Integer.toString(1) + ":RAW:" + irSignal.toOneShot(count).ccfString();
        return this.encode(sendCommand, data);
    }

    private Payload decode(byte[] data, Byte token) {
        int i;
        int index = 0;
        for (i = 0; i < introBytes.length; ++i) {
            if (data[index++] == introBytes[i]) continue;
            return null;
        }
        if (token != null && data[index] != token) {
            return null;
        }
        ++index;
        for (i = 0; i < learnerName.length(); ++i) {
            if (data[index++] == learnerName.charAt(i)) continue;
            return null;
        }
        Payload payload = new Payload();
        payload.command = new String(data, index, 3, Charset.forName("US-ASCII"));
        index += 3;
        if (data[index++] != -12) {
            return null;
        }
        for (int i2 = data.length - 2; i2 < data.length; ++i2) {
            if (data[i2] == -11) continue;
            return null;
        }
        payload.data = new String(data, index, data.length - index - 2, Charset.forName("US-ASCII"));
        return payload;
    }

    private byte[] encode(String cmd, String data) {
        return this.encode(cmd, data, (byte)84);
    }

    private byte[] encode(String cmd, String data, byte token) {
        int i;
        byte[] result = new byte[7 + learnerName.length() + cmd.length() + data.length()];
        int index = 0;
        for (i = 0; i < introBytes.length; ++i) {
            result[index++] = introBytes[i];
        }
        result[index++] = token;
        for (i = 0; i < learnerName.length(); ++i) {
            result[index++] = (byte)learnerName.charAt(i);
        }
        for (i = 0; i < cmd.length(); ++i) {
            result[index++] = (byte)cmd.charAt(i);
        }
        result[index++] = -12;
        for (i = 0; i < data.length(); ++i) {
            result[index++] = (byte)data.charAt(i);
        }
        result[index++] = -11;
        result[index++] = -11;
        return result;
    }

    private byte[] encode(String cmd) {
        return this.encode(cmd, "");
    }

    private byte[] readUntilTwoEndTokens() throws IOException {
        ArrayList<Byte> data = new ArrayList<Byte>(200);
        int noEndingTokensFound = 0;
        while (noEndingTokensFound < 2) {
            int x = ((LocalSerialPortRaw)this.serialPort).readByte();
            if (x == -1) {
                throw new IOException("EOF from CommandFusion");
            }
            data.add((byte)x);
            if ((byte)x != -11) continue;
            ++noEndingTokensFound;
        }
        byte[] result = new byte[data.size()];
        int i = 0;
        for (Byte b : data) {
            result[i++] = b;
        }
        return result;
    }

    private void send(byte[] buf) throws IOException {
        Payload payload;
        if (this.verbose && (payload = this.decode(buf, null)) != null) {
            System.err.println(">Sending " + payload);
        }
        ((LocalSerialPortRaw)this.serialPort).sendBytes(buf);
    }

    @Override
    public ModulatedIrSequence capture() throws IOException, IncompatibleArgumentException {
        this.send(this.encode(captureCommand));
        Status status = this.expect(captureCommand, start);
        if (status != Status.ok) {
            return null;
        }
        status = this.expect(captureCommand, signal);
        if (status != Status.ok) {
            return null;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.send(this.encode(readCommand));
        ModulatedIrSequence modulatedIrSequence = null;
        try {
            modulatedIrSequence = this.readCapture();
        }
        catch (IncompatibleArgumentException ex) {
            throw ex;
        }
        finally {
            status = this.expect(captureCommand, end);
        }
        if (status != Status.ok) {
            return null;
        }
        return modulatedIrSequence;
    }

    ModulatedIrSequence readCapture() throws IOException, IncompatibleArgumentException {
        byte[] response = this.readUntilTwoEndTokens();
        Payload payload = this.decode(response, (byte)82);
        if (this.verbose) {
            System.err.println("<Received " + payload);
        }
        if (payload == null || !payload.command.equals(captureCommand)) {
            return null;
        }
        if (!payload.data.startsWith("IRCODE:")) {
            return null;
        }
        int index = ircode.length() + 1;
        double frequency = Pronto.getFrequency(Integer.parseInt(payload.data.substring(index, index + 4), 16));
        if ((payload.data.length() - (index += 4)) % 4 != 0) {
            throw new IncompatibleArgumentException("Receive length erroneous");
        }
        ArrayList<Integer> durations = new ArrayList<Integer>(payload.data.length() - index);
        boolean lastState = false;
        int accumulated = 0;
        for (int i = index; i < payload.data.length(); i += 4) {
            boolean state = payload.data.substring(i, i + 2).equals("01");
            int duration = Integer.parseInt(payload.data.substring(i + 2, i + 4), 16);
            if (lastState != state) {
                if (accumulated > 0) {
                    durations.add(25 * accumulated);
                }
                accumulated = duration;
            } else {
                accumulated += duration;
            }
            lastState = state;
        }
        durations.add(25 * accumulated);
        int[] data = new int[durations.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Integer)durations.get(i);
        }
        ModulatedIrSequence result = new ModulatedIrSequence(data, frequency, -1.0);
        return result;
    }

    @Override
    public boolean stopCapture() {
        this.stopRequested = true;
        return true;
    }

    @Override
    public String getVersion() {
        return this.versionString;
    }

    @Override
    public void setBeginTimeout(int integer) {
    }

    @Override
    public void setCaptureMaxSize(int integer) {
    }

    @Override
    public void setEndTimeout(int integer) {
    }

    private static class Payload {
        public String command;
        public String data;

        private Payload() {
        }

        public String toString() {
            return "command \"" + this.command + "\", data \"" + this.data + "\"";
        }
    }

    private static enum Status {
        ok,
        timeout,
        error;

    }
}

