/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.devslashlirc.LircDeviceException;
import org.harctoolbox.devslashlirc.Mode2LircDevice;
import org.harctoolbox.devslashlirc.NotSupportedException;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IIrSenderStop;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IReceive;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.LircTransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class DevLirc
implements IRawIrSender,
IReceive,
ICapture,
ITransmitter,
IIrSenderStop {
    public static final String DEV = "/dev";
    public static final String DEVSLASHLIRC = "/dev/lirc";
    public static final String LIRCDEVPATTERN = "lirc\\d+";
    private boolean verbose = false;
    private Mode2LircDevice device = null;
    private boolean canSend = false;
    private boolean canReceive = false;
    private int numberTransmitters = -1;
    private boolean canSetCarrier = false;
    private boolean canSetTransmitter = false;
    private boolean stopRequested;

    public static File[] getCandidates() {
        if (!new File(DEV).isDirectory()) {
            return new File[0];
        }
        return new File(DEVSLASHLIRC).isDirectory() ? new File(DEVSLASHLIRC).listFiles() : new File(DEV).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(DevLirc.LIRCDEVPATTERN);
            }
        });
    }

    public static void main(String[] args) {
        File[] candidates;
        for (File f : candidates = DevLirc.getCandidates()) {
            System.out.println(f);
        }
        try (DevLirc instance = new DevLirc();){
            double nec1_frequency = 38400.0;
            int[] nec1_122_27 = new int[]{9024, 4512, 564, 564, 564, 1692, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 1692, 564, 564, 564, 1692, 564, 564, 564, 1692, 564, 564, 564, 564, 564, 564, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 564, 564, 1692, 564, 1692, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 1692, 564, 564, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 39756};
            int[] nec1_repeat = new int[]{9024, 2256, 564, 96156};
            IrSignal yama_volume_down = new IrSignal(nec1_frequency, -1.0, new IrSequence(nec1_122_27), new IrSequence(nec1_repeat), null);
            instance.open();
            System.out.println(instance);
            System.out.println(">>>>>>>>>>>>> Now send IR <<<<<<<<<<<<<<<");
            IrSequence irSequence = instance.receive();
            System.out.println(irSequence);
            instance.sendIr(yama_volume_down, 10, new LircTransmitter(1));
        }
        catch (IncompatibleArgumentException | LircDeviceException | HarcHardwareException ex) {
            Logger.getLogger(DevLirc.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DevLirc(String deviceName, boolean verbose) throws LircDeviceException {
        this.device = new Mode2LircDevice(deviceName);
        this.verbose = verbose;
    }

    public DevLirc(String deviceName) throws LircDeviceException {
        this(deviceName, false);
    }

    public DevLirc() throws LircDeviceException {
        this("/dev/lirc0", false);
    }

    public boolean canSend() {
        return this.canSend;
    }

    public boolean canReceive() {
        return this.canReceive;
    }

    public int getNumberTransmitters() {
        return this.numberTransmitters;
    }

    public boolean canSetCarrier() {
        return this.canSetCarrier;
    }

    public boolean canSetTransmitter() {
        return this.canSetTransmitter;
    }

    private void sendIr(IrSequence irSequence) throws NotSupportedException {
        if (irSequence.isEmpty()) {
            return;
        }
        this.device.send(irSequence.toInts());
    }

    @Override
    public boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws HarcHardwareException {
        if (transmitter != null && !(transmitter instanceof LircTransmitter)) {
            throw new NoSuchTransmitterException("erroneous transmitter");
        }
        return this.sendIr(irSignal, count, (LircTransmitter)transmitter);
    }

    public boolean sendIr(IrSignal irSignal, int count, LircTransmitter transmitter) throws HarcHardwareException {
        this.stopRequested = false;
        try {
            int mask;
            if (transmitter != null && this.canSetTransmitter && (mask = transmitter.toMask()) != -1) {
                this.device.setTransmitterMask(mask);
                if (this.verbose) {
                    System.err.println("Setting transmitter mask " + mask);
                }
            }
            if (this.verbose) {
                System.err.println("DevLirc sending " + count + " IrSignals: " + irSignal);
            }
            this.device.setSendCarrier((int)irSignal.getFrequency());
            this.sendIr(irSignal.getIntroSequence());
            for (int i = 0; i < irSignal.repeatsPerCountSemantic(count) && !this.stopRequested; ++i) {
                this.sendIr(irSignal.getRepeatSequence());
            }
            this.sendIr(irSignal.getEndingSequence());
        }
        catch (LircDeviceException ex) {
            throw new HarcHardwareException(ex);
        }
        return true;
    }

    @Override
    public IrSequence receive() throws HarcHardwareException, IncompatibleArgumentException {
        int[] data;
        try {
            data = this.device.receive();
        }
        catch (NotSupportedException ex) {
            throw new HarcHardwareException(ex);
        }
        IrSequence irSequence = new IrSequence(data);
        if (this.verbose) {
            System.err.println("Received " + irSequence);
        }
        return irSequence;
    }

    @Override
    public boolean stopReceive() {
        return false;
    }

    @Override
    public boolean stopIr(Transmitter transmitter) {
        this.stopRequested = true;
        return true;
    }

    @Override
    public String getVersion() throws IOException {
        return this.device.getVersion();
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public boolean isValid() {
        return this.device != null && this.device.isValid();
    }

    @Override
    @Deprecated
    public void setTimeout(int timeout) throws IOException {
        this.device.setBeginTimeout(timeout);
    }

    @Override
    public void setBeginTimeout(int timeout) throws IOException {
        this.device.setBeginTimeout(timeout);
    }

    @Override
    public void setCaptureMaxSize(int integer) {
        this.device.setMaxCaptureLength(integer);
    }

    @Override
    public void setEndTimeout(int integer) {
        this.device.setEndTimeout(integer);
    }

    @Override
    public void open() throws HarcHardwareException {
        try {
            this.device.open();
            this.canSetTransmitter = this.device.canSetTransmitterMask();
            this.numberTransmitters = this.device.getNumberTransmitters();
            this.canSend = this.device.canSend();
            this.canReceive = this.device.canRec();
            this.canSetCarrier = this.device.canSetSendCarrier();
        }
        catch (LircDeviceException ex) {
            throw new HarcHardwareException(ex);
        }
    }

    @Override
    public void close() {
        if (this.device != null) {
            this.device.close();
        }
    }

    @Override
    public Transmitter getTransmitter() {
        return new LircTransmitter();
    }

    @Override
    public LircTransmitter getTransmitter(String connector) throws NoSuchTransmitterException {
        return new LircTransmitter(connector);
    }

    public LircTransmitter getTransmitter(int number) throws NoSuchTransmitterException {
        return new LircTransmitter(number);
    }

    @Override
    public String[] getTransmitterNames() {
        String[] result = new String[this.numberTransmitters];
        for (int i = 1; i <= this.numberTransmitters; ++i) {
            result[i - 1] = Integer.toString(i);
        }
        return result;
    }

    public String toString() {
        return this.device.toString();
    }

    @Override
    public ModulatedIrSequence capture() throws HarcHardwareException, IncompatibleArgumentException {
        IrSequence irSequence = this.receive();
        return irSequence.isEmpty() ? null : new ModulatedIrSequence(irSequence, 38000.0, -1.0);
    }

    @Override
    public boolean stopCapture() {
        return false;
    }
}

