/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ICommandLineDevice;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IIrSenderStop;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IRawIrSenderRepeat;
import org.harctoolbox.harchardware.ir.IReceive;
import org.harctoolbox.harchardware.ir.IRemoteCommandIrSender;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class GirsClient<T extends ICommandLineDevice & IHarcHardware>
implements IHarcHardware,
IReceive,
IRawIrSender,
IRawIrSenderRepeat,
IRemoteCommandIrSender,
IIrSenderStop,
ITransmitter,
ICapture,
ICommandLineDevice {
    private static final String defaultLineEnding = "\r";
    private static final String sendCommand = "send";
    private static final String captureCommand = "analyze";
    private static final String receiveCommand = "receive";
    private static final String versionCommand = "version";
    private static final String modulesCommand = "modules";
    private static final String resetCommand = "reset";
    private static final String ledCommand = "led";
    private static final String lcdCommand = "lcd";
    private static final String okString = "OK";
    private static final String timeoutString = ".";
    private static final String separator = " ";
    private String version;
    private List<String> modules;
    private final T hardware;
    private boolean verbose = false;
    private int debug;
    private boolean useReceiveForCapture;
    private String lineEnding = "\r";
    private int beginTimeout;
    private int maxCaptureLength;
    private int endingTimeout;
    private int fallbackFrequency = 38000;
    private boolean stopRequested = false;
    private boolean pendingCapture = false;

    public static void main(String[] args) {
        GirsClient.testGirsTcp("arduino", 33333, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGirsTcp(String ip, int portnumber, boolean verbose) {
        GirsClient<TcpSocketPort> gc = null;
        try {
            TcpSocketPort tcp = new TcpSocketPort(ip, portnumber, verbose, TcpSocketPort.ConnectionMode.keepAlive);
            gc = new GirsClient<TcpSocketPort>(tcp);
            GirsClient.testGirs(gc);
        }
        catch (IOException | HarcHardwareException ex) {
            Logger.getLogger(GirsClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (gc != null) {
                try {
                    gc.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void testGirs(GirsClient<?> gc) {
        try {
            IrSequence irSequence;
            gc.open();
            System.out.println(gc.getVersion());
            if (gc.hasModule(lcdCommand)) {
                gc.setLcd("Now send an IR signal");
            }
            if ((irSequence = gc.receive()) == null) {
                System.err.println("No input");
                gc.close();
                System.exit(1);
            }
            ModulatedIrSequence seq = new ModulatedIrSequence(irSequence, 38000.0);
            System.out.println(seq);
            DecodeIR.invoke(seq);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GirsClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            gc.close();
        }
        catch (IOException | IrpMasterException | HarcHardwareException ex) {
            Logger.getLogger(GirsClient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public GirsClient(T hardware) throws HarcHardwareException, IOException {
        this.hardware = hardware;
        this.useReceiveForCapture = false;
    }

    public void setUseReceiveForCapture(boolean val) {
        this.useReceiveForCapture = val;
    }

    @Override
    public void close() throws IOException {
        this.hardware.close();
    }

    @Override
    public String getVersion() throws IOException {
        return this.version;
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.hardware.setVerbosity(verbose);
        this.verbose = verbose;
    }

    @Override
    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    @Deprecated
    public void setTimeout(int timeout) throws IOException {
        this.setBeginTimeout(timeout);
    }

    public int getBeginTimeout() {
        return this.beginTimeout;
    }

    @Override
    public void setBeginTimeout(int beginTimeout) {
        this.beginTimeout = beginTimeout;
    }

    public int getMaxCaptureLength() {
        return this.maxCaptureLength;
    }

    @Override
    public void setCaptureMaxSize(int maxCaptureLength) {
        this.maxCaptureLength = maxCaptureLength;
    }

    public int getEndTimeout() {
        return this.endingTimeout;
    }

    @Override
    public void setEndTimeout(int endingTimeout) {
        this.endingTimeout = endingTimeout;
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    @Override
    public boolean isValid() {
        return this.hardware.isValid() && this.version != null && this.modules != null && this.modules.contains("base");
    }

    public List<String> getModules() {
        return this.modules;
    }

    public boolean hasModule(String module) {
        return this.modules.contains(module.toLowerCase(Locale.US));
    }

    public void setFallbackFrequency(int fallbackFrequency) {
        this.fallbackFrequency = fallbackFrequency;
    }

    @Override
    public synchronized boolean sendIr(IrSignal irSignal, int count, Transmitter transmitter) throws NoSuchTransmitterException, IrpMasterException, IOException {
        String response;
        String payload = this.formatSendString(irSignal, count);
        this.hardware.sendString(payload + this.lineEnding);
        if (this.verbose) {
            System.err.println(payload);
        }
        return (response = this.hardware.readString(true)) != null && response.trim().equals(okString);
    }

    @Override
    public void open() throws IOException, HarcHardwareException {
        this.hardware.open();
        this.waitFor(okString, this.lineEnding, 100, 3);
        this.hardware.sendString(versionCommand + this.lineEnding);
        this.version = this.hardware.readString(true).trim();
        if (this.verbose) {
            System.err.println("version returned '" + this.version + "'.");
        }
        this.hardware.sendString(modulesCommand + this.lineEnding);
        String line = this.hardware.readString(true);
        if (this.verbose) {
            System.err.println("version returned '" + this.version + "'.");
        }
        if (line != null) {
            this.modules = Arrays.asList(line.toLowerCase(Locale.US).split("\\s+"));
        }
    }

    public void waitFor(String goal, String areUThere, int delay, int tries) throws IOException, HarcHardwareException {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.flushIn();
        for (int i = 0; i < tries; ++i) {
            this.sendString(areUThere);
            String answer = this.readString(true);
            if (answer == null) continue;
            if ((answer = answer.trim()).startsWith(goal)) {
                this.flushIn();
                return;
            }
            if (delay <= 0) continue;
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        throw new HarcHardwareException("Hardware not responding");
    }

    private void flushIn() {
        block3: {
            try {
                String junk;
                while ((junk = this.readString(false)) != null) {
                    if (!this.verbose) continue;
                    System.err.println("LocalSerialPortBuffered.flushIn: junked '" + junk + "'.");
                }
            }
            catch (IOException ex) {
                if (!this.verbose) break block3;
                System.err.println("IOException in LocalSerialPortBuffered.flushIn ignored: " + ex.getMessage());
            }
        }
    }

    private StringBuilder join(IrSequence irSequence, String separator) {
        if (irSequence == null || irSequence.isEmpty()) {
            return new StringBuilder(0);
        }
        StringBuilder str = new StringBuilder(128);
        for (int i = 0; i < irSequence.getLength(); ++i) {
            str.append(separator).append(Integer.toString(irSequence.iget(i)));
        }
        return str;
    }

    private String formatSendString(IrSignal irSignal, int count) {
        if (irSignal == null) {
            throw new IllegalArgumentException("irSignal cannot be null");
        }
        StringBuilder str = new StringBuilder(sendCommand);
        str.append(separator).append(Integer.toString(count));
        str.append(separator).append(Integer.toString((int)irSignal.getFrequency()));
        str.append(separator).append(Integer.toString(2 * irSignal.getIntroBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getRepeatBursts()));
        str.append(separator).append(Integer.toString(2 * irSignal.getEndingBursts()));
        str.append((CharSequence)this.join(irSignal.getIntroSequence(), separator));
        str.append((CharSequence)this.join(irSignal.getRepeatSequence(), separator));
        str.append((CharSequence)this.join(irSignal.getEndingSequence(), separator));
        return str.toString();
    }

    @Override
    public ModulatedIrSequence capture() throws IOException, HarcHardwareException, IrpMasterException {
        return this.useReceiveForCapture ? this.mockModulatedIrSequence() : this.realCapture();
    }

    private ModulatedIrSequence mockModulatedIrSequence() throws HarcHardwareException, IOException, IrpMasterException {
        IrSequence irSequence = this.receive();
        return irSequence == null ? null : new ModulatedIrSequence(irSequence, (double)this.fallbackFrequency);
    }

    private ModulatedIrSequence realCapture() throws HarcHardwareException, IOException {
        if (this.stopRequested) {
            return null;
        }
        if (!this.isValid()) {
            throw new HarcHardwareException("Port not initialized");
        }
        if (!this.pendingCapture) {
            this.hardware.sendString(captureCommand + this.lineEnding);
            this.pendingCapture = true;
        }
        ModulatedIrSequence seq = null;
        try {
            String str = this.hardware.readString(true);
            this.pendingCapture = false;
            if (str == null || str.length() == 0 || str.startsWith("null") || str.startsWith(timeoutString)) {
                return null;
            }
            str = str.trim();
            double frequency = this.fallbackFrequency;
            if (str.startsWith("f=")) {
                int indx = str.indexOf(32);
                if (indx < 0) {
                    return null;
                }
                frequency = Integer.parseInt(str.substring(2, indx));
                str = str.substring(indx + 1);
            }
            seq = new ModulatedIrSequence(new IrSequence(str), frequency, -1.0);
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                return null;
            }
            throw ex;
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException(ex);
        }
        return seq;
    }

    @Override
    public boolean stopCapture() {
        this.stopRequested = true;
        return true;
    }

    @Override
    public IrSequence receive() throws HarcHardwareException, IOException, IrpMasterException {
        if (this.stopRequested) {
            return null;
        }
        if (!this.isValid()) {
            throw new HarcHardwareException("Port not initialized");
        }
        if (!this.pendingCapture) {
            this.hardware.sendString(receiveCommand + this.lineEnding);
            this.pendingCapture = true;
        }
        IrSequence seq = null;
        try {
            String str = this.hardware.readString(true);
            this.pendingCapture = false;
            if (str == null || str.length() == 0 || str.startsWith("null") || str.startsWith(timeoutString)) {
                return null;
            }
            str = str.trim();
            seq = new IrSequence(str);
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
        catch (IOException ex) {
            if (ex.getMessage().equals("Underlying input stream returned zero bytes")) {
                return null;
            }
            throw ex;
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException(ex);
        }
        return seq;
    }

    @Override
    public boolean stopReceive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() throws IOException {
        this.hardware.sendString(resetCommand);
        if (this.hardware instanceof LocalSerialPortBuffered) {
            ((LocalSerialPort)this.hardware).dropDTR(100);
        }
    }

    @Override
    public void sendString(String cmd) throws IOException {
        this.hardware.sendString(cmd);
    }

    @Override
    public String readString() throws IOException {
        return this.hardware.readString();
    }

    @Override
    public String readString(boolean wait) throws IOException {
        return this.hardware.readString(wait);
    }

    @Override
    public boolean ready() throws IOException {
        return this.hardware.ready();
    }

    @Override
    public void flushInput() throws IOException {
        this.hardware.flushInput();
    }

    @Override
    public Transmitter getTransmitter() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean stopIr(Transmitter transmitter) throws NoSuchTransmitterException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Transmitter getTransmitter(String connector) throws NoSuchTransmitterException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getTransmitterNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean sendIrRepeat(IrSignal irSignal, Transmitter transmitter) throws NoSuchTransmitterException, IOException, IrpMasterException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getRemotes() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getCommands(String remote) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean sendIrCommand(String remote, String command, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean sendIrCommandRepeat(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLed(int led, boolean state) throws IOException, HarcHardwareException {
        this.sendStringWaitOk("led " + led + separator + (state ? "1" : "0"));
    }

    public void setLed(int led, int flashTime) {
    }

    public void setLcd(String message) throws IOException, HarcHardwareException {
        this.sendStringWaitOk("lcd " + message);
    }

    public void setLcd(String message, int x, int y) {
    }

    public void setLcdBacklight(boolean state) {
    }

    public void setLcdBacklight(int flashTime) {
    }

    private void sendStringWaitOk(String line) throws IOException, HarcHardwareException {
        this.hardware.sendString(line + this.lineEnding);
        String answer = this.readString(true);
        if (answer == null) {
            throw new HarcHardwareException("No \"OK\" received.");
        }
        if (!(answer = answer.trim()).startsWith(okString)) {
            throw new HarcHardwareException("No \"OK\" received, instead \"" + answer + "\".");
        }
    }
}

