/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InterpretString;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.harchardware.ir.GlobalCache;

public class InterpretStringHardware {
    private static CommandLineArgs commandLineArgs;
    private static JCommander argumentParser;

    public static IrSignal interpretString(String string, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner, double absoluteTolerance, double relativeTolerance) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        return string.startsWith("sendir") ? GlobalCache.parse(string) : InterpretString.interpretString(string, frequency, invokeRepeatFinder, invokeCleaner, absoluteTolerance, relativeTolerance);
    }

    public static IrSignal interpretString(String string, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        return string.startsWith("sendir") ? GlobalCache.parse(string) : InterpretString.interpretString(string, frequency, invokeRepeatFinder, invokeCleaner);
    }

    public static void main(String[] args) {
        commandLineArgs = new CommandLineArgs();
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("HarcHardware");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            argumentParser.usage();
            System.exit(1);
        }
        if (commandLineArgs.helpRequested) {
            argumentParser.usage();
            System.exit(0);
        }
        String payload = IrpUtils.join(commandLineArgs.arguments, " ");
        try {
            IrSignal irSignal = InterpretStringHardware.interpretString(payload, commandLineArgs.frequency, commandLineArgs.invokeRepeatFinder, commandLineArgs.invokeCleaner, commandLineArgs.absouteTolerance, commandLineArgs.relativeTolerance);
            System.out.println(irSignal);
        }
        catch (DomainViolationException | IncompatibleArgumentException | InvalidRepeatException | ParseException | UnassignedException ex) {
            System.err.println(ex);
            System.exit(3);
        }
    }

    private InterpretStringHardware() {
    }

    private static final class CommandLineArgs {
        private static final int defaultTimeout = 2000;
        @Parameter(names={"-h", "-?", "--clean"}, description="Invoke help")
        private boolean helpRequested = false;
        @Parameter(names={"-c", "--clean"}, description="Invoke cleaner")
        private boolean invokeCleaner = false;
        @Parameter(names={"-r", "--repeatfinder"}, description="Invoke repeatfinder")
        private boolean invokeRepeatFinder = false;
        @Parameter(names={"-f", "--frequency"}, description="Modulation frequency")
        private double frequency = 38000.0;
        @Parameter(names={"-a", "--absolutetolearance"}, description="Absoulte Tolerance")
        private double absouteTolerance = 60.0;
        @Parameter(names={"-r", "--relativetolearance"}, description="Relative Tolerance")
        private double relativeTolerance = 0.2;
        @Parameter(description="[arguments]")
        private ArrayList<String> arguments = new ArrayList(8);

        private CommandLineArgs() {
        }
    }
}

