/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.ir.Transmitter;

public abstract class IrSerial<T extends LocalSerialPort>
implements IHarcHardware {
    protected boolean verbose;
    private int timeout;
    protected T serialPort;
    private String portName;
    private int baudRate;
    private int dataSize;
    private int stopBits;
    private LocalSerialPort.Parity parity;
    private LocalSerialPort.FlowControl flowControl;
    private final Class<T> clazz;

    public IrSerial(Class<T> clazz, String portName, int baudRate, int dataSize, int stopBits, LocalSerialPort.Parity parity, LocalSerialPort.FlowControl flowControl, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this.clazz = clazz;
        this.portName = portName;
        this.baudRate = baudRate;
        this.dataSize = dataSize;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
        this.timeout = timeout;
        this.verbose = verbose;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public void setParity(LocalSerialPort.Parity parity) {
        this.parity = parity;
    }

    public void setFlowControl(LocalSerialPort.FlowControl flowControl) {
        this.flowControl = flowControl;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Override
    public String getVersion() throws IOException {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        if (!this.isValid()) {
            throw new IOException("Port not valid, cannot set timeout.");
        }
        this.timeout = timeout;
        ((LocalSerialPort)this.serialPort).setTimeout(timeout);
    }

    @Override
    public boolean isValid() {
        return this.serialPort != null && ((LocalSerialPort)this.serialPort).isValid();
    }

    @Override
    public void close() throws IOException {
        if (!this.isValid()) {
            return;
        }
        try {
            ((LocalSerialPort)this.serialPort).flush();
        }
        finally {
            try {
                ((LocalSerialPort)this.serialPort).close();
            }
            finally {
                this.serialPort = null;
            }
        }
    }

    public Transmitter getTransmitter() {
        return null;
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        try {
            Constructor<T> constructor = this.clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, LocalSerialPort.Parity.class, LocalSerialPort.FlowControl.class, Integer.TYPE, Boolean.TYPE);
            this.serialPort = (LocalSerialPort)constructor.newInstance(new Object[]{this.portName, this.baudRate, this.dataSize, this.stopBits, this.parity, this.flowControl, this.timeout, this.verbose});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException("Programming error in IrSerial");
        }
        ((LocalSerialPort)this.serialPort).open();
    }
}

