/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortRaw;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IRawIrSender;
import org.harctoolbox.harchardware.ir.IReceive;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.harchardware.ir.Transmitter;

public final class IrToy
extends IrSerial<LocalSerialPortRaw>
implements IRawIrSender,
ICapture,
IReceive {
    public static final String defaultPortName = "/dev/ttyACM0";
    public static final int defaultBaudRate = 9600;
    public static final LocalSerialPort.FlowControl defaultFlowControl = LocalSerialPort.FlowControl.RTSCTS;
    private static final int dataSize = 8;
    private static final int stopBits = 1;
    private static final LocalSerialPort.Parity parity = LocalSerialPort.Parity.NONE;
    private static final double oscillatorFrequency = 4.8E7;
    private static final double period = 21.3333;
    private static final double PICClockFrequency = 1.2E7;
    private static final byte dutyCycle = 0;
    private static final boolean transmitNotifyEnabled = true;
    private static final boolean transmitByteCountReportEnabled = true;
    private static final boolean transmitHandshakeEnabled = true;
    private static final byte cmdReset = 0;
    private static final byte cmdTransmit = 3;
    private static final byte cmdFrequencyReport = 4;
    private static final byte cmdSetFrequency = 6;
    private static final byte cmdLedMuteOn = 16;
    private static final byte cmdLedMuteOff = 17;
    private static final byte cmdLedOn = 18;
    private static final byte cmdLedOff = 19;
    private static final byte cmdTransmitByteCountReport = 36;
    private static final byte cmdTransmitNotify = 37;
    private static final byte cmdTransmitHandshake = 38;
    private static final byte cmdIOwrite = 48;
    private static final byte cmdIOdirection = 49;
    private static final byte cmdIOread = 50;
    private static final byte cmdUARTsetup = 64;
    private static final byte cmdUARTclose = 65;
    private static final byte cmdUARTwrite = 66;
    private static final byte cmdSamplingMode = 115;
    private static final byte cmdSelfTest = 116;
    private static final byte cmdVersion = 118;
    private static final byte cmdBootloaderMode = 36;
    private static final byte endOfData = -1;
    private static final int transmitByteCountToken = 116;
    private static final int transmitCompleteSuccess = 67;
    private static final int transmitCompleteFailure = 70;
    private static final int lengthVersionString = 4;
    private static final int lengthSelftestVersionString = 4;
    private static final int lengthProtocolVersionString = 3;
    private static final String expectedProtocolVersion = "S01";
    private static final int emptyBufferSize = 62;
    private static final int powerPin = 5;
    private static final int receivePin = 3;
    private static final int sendingPin = 4;
    private boolean stopCaptureRequest = true;
    private String protocolVersion;
    private String version;
    private int captureMaxSize = 500;
    private int IOdirections = -1;
    private int IOdata = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String portName = defaultPortName;
        IrToy toy = null;
        try {
            toy = new IrToy(portName);
            toy.open();
            if (args.length >= 1 && args[0].equals("-b")) {
                toy.bootloaderMode();
            } else {
                System.out.println(toy.getVersion());
                toy.setLed(true);
                toy.setLedMute(false);
                IrSignal signal = new IrSignal("../IrpMaster/data/IrpProtocols.ini", "nec1", "D=122 F=26");
                boolean success = toy.sendIr(signal, 10, null);
                toy.setPin(5, true);
                toy.setPin(3, true);
                toy.setPin(4, true);
                System.out.println(success);
            }
        }
        catch (NoSuchPortException ex) {
            System.err.println("Port for IRToy " + portName + " was not found");
        }
        catch (PortInUseException ex) {
            System.err.println("Port for IRToy in use");
        }
        catch (UnsupportedCommOperationException | IOException | IrpMasterException | HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (toy != null) {
                try {
                    toy.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public IrToy() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(defaultPortName, 9600, defaultFlowControl, 5000, 500, false);
    }

    public IrToy(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, defaultFlowControl, 5000, 500, false);
    }

    public IrToy(String portName, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, defaultFlowControl, timeout, 500, verbose);
    }

    public IrToy(String portName, int baudRate, int timeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baudRate, defaultFlowControl, timeout, 500, verbose);
    }

    public IrToy(String portName, int beginTimeout, int captureMaxSize, int endingTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, 9600, defaultFlowControl, beginTimeout, captureMaxSize, verbose);
    }

    public IrToy(String portName, int baud, int beginTimeout, int captureSize, int endTimeout, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        this(portName, baud, defaultFlowControl, beginTimeout, captureSize, verbose);
    }

    public IrToy(String portName, int baudRate, LocalSerialPort.FlowControl flowControl, int timeout, int maxLearnLength, boolean verbose) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        super(LocalSerialPortRaw.class, portName, baudRate, 8, 1, parity, flowControl, timeout, verbose);
        this.captureMaxSize = maxLearnLength;
    }

    private void goSamplingMode() throws IOException, HarcHardwareException {
        this.send((byte)115);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.protocolVersion = this.readString(3);
        if (!this.protocolVersion.equals(expectedProtocolVersion)) {
            throw new HarcHardwareException("Unsupported IrToy protocol version: " + this.protocolVersion);
        }
    }

    private void setupSendingModes() throws IOException {
        this.send((byte)37);
        this.send((byte)38);
        this.send((byte)36);
    }

    private byte[] prepare3(byte cmd, int data) {
        byte[] array = new byte[]{cmd, (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
        return array;
    }

    private void setIOData() throws IOException {
        this.send(this.prepare3((byte)49, this.IOdirections));
        this.send(this.prepare3((byte)48, this.IOdata));
    }

    public void setPin(int pin, boolean state) throws IOException {
        int mask = 1 << pin;
        this.IOdirections &= ~mask;
        this.IOdata = state ? (this.IOdata |= mask) : (this.IOdata &= ~mask);
        this.setIOData();
    }

    @Override
    public void open() throws IOException, HarcHardwareException {
        super.open();
        this.reset(5);
        this.send((byte)118);
        this.version = this.readString(4);
        this.goSamplingMode();
        this.setupSendingModes();
        this.setPin(5, true);
    }

    @Override
    public void close() throws IOException {
        if (this.isValid()) {
            this.IOdirections = -1;
            this.setIOData();
            this.reset(1);
        }
        super.close();
    }

    public void reset(int times) throws IOException {
        for (int i = 0; i < times; ++i) {
            this.send((byte)0);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((LocalSerialPortRaw)this.serialPort).flushInput();
    }

    private void send(byte[] buf) throws IOException {
        ((LocalSerialPortRaw)this.serialPort).sendBytes(buf);
    }

    private void send(byte[] buf, int offset, int length) throws IOException {
        ((LocalSerialPortRaw)this.serialPort).sendBytes(buf, offset, length);
    }

    private void send(byte b) throws IOException {
        ((LocalSerialPortRaw)this.serialPort).sendByte(b);
    }

    private byte[] toByteArray(int[] data) {
        byte[] buf = new byte[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            int periods = (int)Math.round((double)data[i] / 21.3333);
            buf[2 * i] = (byte)(periods / 256);
            buf[2 * i + 1] = (byte)(periods % 256);
        }
        buf[2 * data.length - 2] = -1;
        buf[2 * data.length - 1] = -1;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] recv() throws IOException {
        int[] result = null;
        try {
            int ms;
            ArrayList<Integer> array = new ArrayList<Integer>(16);
            this.stopCaptureRequest = false;
            long maxLearnLengthMicroSeconds = (long)this.captureMaxSize * 1000L;
            this.setPin(3, true);
            for (long sum = 0L; !this.stopCaptureRequest && sum <= maxLearnLengthMicroSeconds; sum += (long)ms) {
                int val = this.read2Bytes();
                ms = (int)Math.round((double)val * 21.3333);
                array.add(ms);
                if (val != 65535) continue;
                break;
            }
            if (this.stopCaptureRequest) {
                this.setPin(3, false);
                int[] val = null;
                return val;
            }
            result = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                result[i] = (Integer)array.get(i);
            }
        }
        finally {
            this.setPin(3, false);
        }
        return result;
    }

    private double getFrequency(int onTimes) throws IOException {
        this.send((byte)4);
        this.read2Bytes();
        this.read2Bytes();
        this.read2Bytes();
        int count = this.read2Bytes();
        return (double)count / ((double)onTimes * 1.0E-6);
    }

    @Override
    public ModulatedIrSequence capture() throws HarcHardwareException, IOException {
        this.reset(5);
        this.goSamplingMode();
        int[] data = this.recv();
        if (this.stopCaptureRequest || data == null) {
            return null;
        }
        int sum = 0;
        for (int i = 0; i < data.length / 2; ++i) {
            sum += data[2 * i];
        }
        double frequency = this.getFrequency(sum);
        ModulatedIrSequence seq = null;
        try {
            seq = new ModulatedIrSequence(data, frequency);
        }
        catch (IncompatibleArgumentException ex) {
            throw new HarcHardwareException("IrToy: Erroneous data received.");
        }
        return seq;
    }

    @Override
    public boolean stopCapture() {
        this.stopCaptureRequest = true;
        return true;
    }

    @Override
    public IrSequence receive() throws HarcHardwareException, IOException {
        return this.capture();
    }

    @Override
    public boolean stopReceive() {
        return this.stopCapture();
    }

    private boolean transmit(int[] data, double frequency) throws IOException, HarcHardwareException {
        if (frequency > 0.0) {
            this.setFrequency(frequency);
        }
        return this.transmit(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transmit(int[] data) throws IOException, HarcHardwareException {
        this.reset(1);
        this.goSamplingMode();
        this.setupSendingModes();
        this.setPin(4, true);
        byte[] buf = this.toByteArray(data);
        this.send((byte)3);
        boolean succcess = true;
        try {
            int token;
            int bytesSent = 0;
            while (bytesSent < buf.length) {
                int noBytes = this.readByte();
                if (noBytes != 62) continue;
                int toSend = Math.min(noBytes, buf.length - bytesSent);
                this.send(buf, bytesSent, toSend);
                bytesSent += toSend;
            }
            int noBytes = this.readByte();
            if (noBytes != 62) {
                System.err.println("got " + noBytes + " should: " + 62);
                succcess = false;
            }
            if (succcess) {
                token = this.readByte();
                if (token == 116) {
                    int bytesSent2 = this.read2Bytes();
                    if (bytesSent2 != data.length * 2) {
                        System.err.println("sent " + bytesSent2 + " should: " + data.length * 2);
                        succcess = false;
                    }
                } else {
                    System.err.println("did not get t but " + token);
                    succcess = false;
                }
            }
            if (succcess && (token = this.readByte()) != 67) {
                System.err.println("Status: " + token);
                succcess = false;
            }
        }
        finally {
            this.setPin(4, false);
        }
        return succcess;
    }

    private int byte2unsignedInt(byte b) {
        return b >= 0 ? b : b + 256;
    }

    private String readString(int length) throws IOException {
        byte[] buf = ((LocalSerialPortRaw)this.serialPort).readBytes(length);
        return new String(buf, 0, length, IrpUtils.dumbCharset);
    }

    private int readByte() throws IOException {
        byte[] a = ((LocalSerialPortRaw)this.serialPort).readBytes(1);
        return a.length > 0 ? this.byte2unsignedInt(a[0]) : -1;
    }

    private int read2Bytes() throws IOException {
        byte[] a = ((LocalSerialPortRaw)this.serialPort).readBytes(2);
        return a.length < 2 ? -1 : 256 * this.byte2unsignedInt(a[0]) + this.byte2unsignedInt(a[1]);
    }

    public String selftest() throws IOException {
        this.reset(5);
        this.send((byte)116);
        String ver = this.readString(4);
        return ver;
    }

    public void bootloaderMode() throws IOException {
        this.reset(5);
        this.send((byte)36);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setLedMute(boolean status) throws IOException {
        this.send(status ? (byte)16 : 17);
    }

    public void setLed(boolean status) throws IOException {
        this.send(status ? (byte)18 : 19);
    }

    private void setFrequency(double frequency) throws IOException {
        byte pr2 = (byte)Math.round(4.8E7 / (16.0 * frequency) - 1.0);
        byte[] buf = new byte[]{6, pr2, 0};
        this.send(buf);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setBeginTimeout(int beginTimeout) throws IOException {
        super.setTimeout(beginTimeout);
    }

    @Override
    public void setCaptureMaxSize(int captureMaxSize) {
        this.captureMaxSize = captureMaxSize;
    }

    @Override
    public void setEndTimeout(int timeout) {
    }

    @Override
    public boolean sendIr(IrSignal code, int count, Transmitter transmitter) throws IrpMasterException, IOException, HarcHardwareException {
        return this.transmit(code.toIntArrayCount(count), code.getFrequency());
    }

    public boolean sendCcf(String ccf, int count, Transmitter transmitter) throws IOException, IrpMasterException, HarcHardwareException {
        return this.sendIr(Pronto.ccfSignal(ccf), count, transmitter);
    }

    public boolean sendCcfRepeat(String ccf, Transmitter transmitter) {
        throw new UnsupportedOperationException("Not supported due to hardware restrictions.");
    }

    @Override
    public void setDebug(int debug) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

