/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.harchardware.ir.IRemoteCommandIrSender;
import org.harctoolbox.harchardware.ir.IrTrans;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class IrTransIRDB
extends IrTrans
implements IRemoteCommandIrSender {
    private static final String sendFlashedCommandAck = "**00018 RESULT OK";

    public static String makeUrl(String hostname, String remote, String command, IrTrans.Led led) {
        return "http://" + (hostname != null ? hostname : "192.168.0.32") + "/send.htm?remote=" + remote + "&command=" + command + "&led=" + IrTrans.Led.ledChar(led);
    }

    private static void usage(int exitstatus) {
        System.err.println("Usage:");
        System.err.println("\tIrTrans [-v][-h <hostname>] -r [<remotename>]");
        IrTransIRDB.doExit(exitstatus);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        boolean verbose = false;
        String IrTransHost = "192.168.0.32";
        String configfilename = "listen.xml";
        int optarg = 0;
        if (args.length > optarg && args[optarg].equals("-v")) {
            ++optarg;
            verbose = true;
        }
        if (args.length > optarg + 1 && args[optarg].equals("-h")) {
            IrTransHost = args[optarg + 1];
            optarg += 2;
        }
        try {
            IrTransIRDB irt = new IrTransIRDB(IrTransHost, verbose, 2000, IrTrans.Interface.tcpAscii);
            if (verbose) {
                System.out.println(irt.getVersion());
            }
            if (args.length > optarg && args[optarg].equals("-r")) {
                if (args.length == optarg + 1) {
                    String[] remotes;
                    for (String remote : remotes = irt.getRemotes()) {
                        System.err.println(remote);
                    }
                } else {
                    String[] commands;
                    String remote = args[optarg + 1];
                    for (String command : commands = irt.getCommands(remote)) {
                        System.err.println(command);
                    }
                }
            } else if (args.length > optarg && args[optarg].equals("-c")) {
                StringBuilder ccf = new StringBuilder(128);
                for (int i = optarg + 1; i < args.length; ++i) {
                    ccf.append(' ').append(args[i]);
                }
                irt.sendCcf(ccf.toString(), 1, IrTrans.Led.intern);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            IrTransIRDB.usage(1);
        }
    }

    public IrTransIRDB(String hostname, boolean verbose, int timeout, IrTrans.Interface interfaze) throws UnknownHostException {
        super(hostname, verbose, timeout, interfaze);
    }

    public IrTransIRDB(String hostname, boolean verbose, int timeout) throws UnknownHostException {
        super(hostname, verbose, timeout);
    }

    public IrTransIRDB(String hostname, boolean verbose) throws UnknownHostException {
        super(hostname, verbose);
    }

    public IrTransIRDB(String hostname) throws UnknownHostException {
        super(hostname);
    }

    private String[] getTable(String str) throws IOException, NumberFormatException {
        if (this.verbose) {
            System.err.println("Sending command `" + str + "0' to IrTrans");
        }
        Socket sock = new Socket();
        sock.connect(new InetSocketAddress(this.inetAddress, 21000), this.timeout);
        PrintStream outToServer = new PrintStream(sock.getOutputStream(), false, "US-ASCII");
        BufferedReader inFromServer = new BufferedReader(new InputStreamReader(sock.getInputStream(), IrpUtils.dumbCharset));
        ArrayList<String> items = new ArrayList<String>(64);
        try {
            int chunk;
            outToServer.print("ASCI");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int noRemotes = 99999;
            for (int index = 0; index < noRemotes; index += chunk) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                outToServer.print(str + index + "\r");
                String result = inFromServer.readLine();
                if (result == null) {
                    throw new IOException("Unexpected end of file");
                }
                int secondSpace = result.indexOf(32, 9);
                if (this.verbose) {
                    System.err.println(result);
                }
                String[] words = result.substring(secondSpace + 1, result.length()).split(",");
                index = Integer.parseInt(words[0]);
                noRemotes = Integer.parseInt(words[1]);
                chunk = Integer.parseInt(words[2]);
                for (int c = 0; c < chunk; ++c) {
                    items.add(words[3 + c]);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw ex;
        }
        finally {
            outToServer.close();
            inFromServer.close();
            sock.close();
        }
        return items.toArray(new String[items.size()]);
    }

    @Override
    public String[] getRemotes() throws IOException {
        return this.getTable("Agetremotes ");
    }

    @Override
    public String[] getCommands(String remote) throws IOException {
        return this.getTable("Agetcommands " + remote + ",");
    }

    public String makeUrl(String remote, String command, IrTrans.Led led) {
        return IrTransIRDB.makeUrl(this.irTransIP, remote, command, led);
    }

    private boolean sendFlashedCommandHttp(String remote, String command, IrTrans.Led led) throws MalformedURLException, IOException {
        return this.getUrl(this.makeUrl(remote, command, led));
    }

    @Override
    public boolean sendIrCommand(String remote, String command, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        if (!IrTrans.IrTransTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        boolean success = true;
        IrTrans.Led led = ((IrTrans.IrTransTransmitter)transmitter).getLed();
        for (int i = 0; i < count; ++i) {
            success = success && this.sendIrCommand(remote, command, i > 0, led);
        }
        return success;
    }

    public boolean sendIrCommand(String remote, String command, int count, IrTrans.Led led) throws IOException, NoSuchTransmitterException {
        return this.sendIrCommand(remote, command, count, this.newTransmitter(led));
    }

    @Override
    public boolean sendIrCommandRepeat(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.sendIrCommand(remote, command, 1000, transmitter);
    }

    private boolean sendIrCommand(String remote, String command, boolean repeat, IrTrans.Led led) throws IOException {
        return this.sendIrCommand(remote, command, repeat, led, this.interfaze);
    }

    private boolean sendIrCommand(String remote, String command, boolean repeat, IrTrans.Led led, IrTrans.Interface interf) throws IOException {
        boolean result;
        switch (interf) {
            case tcpAscii: {
                result = this.sendFlashedCommandTCP(remote, command, led, repeat);
                break;
            }
            case udp: {
                result = this.sendFlashedCommandUdp(remote, command, led, repeat);
                break;
            }
            case http: {
                result = this.sendFlashedCommandHttp(remote, command, led);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sending named commands on IrTrans using interface " + (Object)((Object)this.interfaze) + " not supported");
            }
        }
        return result;
    }

    private boolean sendFlashedCommandTCP(String remote, String command, IrTrans.Led led, boolean repeat) throws IOException {
        return this.sendCommand("Asnd" + (repeat ? "r" : "") + " " + remote + "," + command + "," + IrTrans.Led.ledChar(led)).equals(sendFlashedCommandAck);
    }

    private boolean sendFlashedCommandUdp(String remote, String command, IrTrans.Led led, boolean repeat) throws IOException {
        return this.sendCommandUdp("snd" + (repeat ? "r" : "") + " " + remote + "," + command + "," + IrTrans.Led.ledChar(led));
    }
}

