/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.ICapture;

public class IrWidget
implements IHarcHardware,
ICapture {
    public static final int msPerTick = 100;
    public static final String defaultPortName = "/dev/ttyUSB0";
    private static final int baudRate = 115200;
    private static final int mask = 63;
    private static final Modes defaultMode = Modes.irwidgetPulse;
    private static final int shortDelay = 20;
    private static final int longDelay = 200;
    private CommPortIdentifier portIdentifier;
    private CommPort commPort;
    private Modes mode;
    private String portName;
    private int debug;
    private byte[] data;
    private int[] times;
    private int dataLength;
    private double frequency;
    private boolean stopRequested;
    private boolean verbose;
    private int beginTimeout;
    private int captureMaxSize;
    private int endTimeout;

    private static int toIntAsUnsigned(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static void main(String[] args) {
        try (IrWidget w = new IrWidget();){
            w.open();
            ModulatedIrSequence seq = w.capture();
            System.out.println(seq);
            if (seq == null) {
                System.err.println("No input");
            } else {
                DecodeIR.invoke(seq);
            }
        }
        catch (IOException ex) {
            System.err.println("exception: " + ex.toString() + ex.getMessage());
        }
        catch (HarcHardwareException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public IrWidget() {
        this(defaultPortName, false, 0);
    }

    public IrWidget(String portName, boolean verbose, int debug) {
        this(portName, defaultMode, 5000, 500, 100, verbose, debug);
    }

    public IrWidget(String portName, int startTimeout, int runTimeout, int endTimeout, boolean verbose) {
        this(portName, defaultMode, startTimeout, runTimeout, endTimeout, verbose, 0);
    }

    private IrWidget(String portName, Modes mode, int beginTimeout, int captureMaxSize, int endTimeout, boolean verbose, int debug) {
        this.mode = mode;
        this.portName = portName;
        this.debug = debug;
        this.verbose = verbose;
        this.beginTimeout = beginTimeout;
        this.captureMaxSize = captureMaxSize;
        this.endTimeout = endTimeout;
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        try {
            this.portIdentifier = CommPortIdentifier.getPortIdentifier(this.portName);
        }
        catch (NoSuchPortException ex) {
            throw new HarcHardwareException(ex);
        }
        try {
            this.commPort = this.portIdentifier.open(this.getClass().getName(), 2000);
        }
        catch (PortInUseException ex) {
            throw new HarcHardwareException(ex);
        }
        if (!(this.commPort instanceof SerialPort)) {
            throw new RuntimeException("Internal error: " + this.portName + " not a serial port");
        }
        RXTXPort serialPort = (RXTXPort)this.commPort;
        try {
            serialPort.setSerialPortParams(115200, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException ex) {
            throw new HarcHardwareException(ex);
        }
        serialPort.setFlowControlMode(0);
        serialPort.disableReceiveThreshold();
        serialPort.disableReceiveFraming();
    }

    @Override
    public void close() {
        this.portIdentifier = null;
        if (this.commPort != null) {
            this.commPort.close();
        }
        this.commPort = null;
    }

    @Override
    public void setTimeout(int timeout) {
        this.setBeginTimeout(timeout);
    }

    @Override
    public void setBeginTimeout(int timeout) {
        this.beginTimeout = timeout;
    }

    @Override
    public void setCaptureMaxSize(int maxCaptureMaxSize) {
        this.captureMaxSize = maxCaptureMaxSize;
    }

    @Override
    public void setEndTimeout(int endTimeout) {
        this.endTimeout = endTimeout;
    }

    @Override
    public ModulatedIrSequence capture() throws IOException {
        long startTime;
        int bytesRead = 0;
        ModulatedIrSequence seq = null;
        RXTXPort serialPort = (RXTXPort)this.commPort;
        this.setMode(this.mode);
        try {
            serialPort.clearCommInput();
        }
        catch (UnsupportedCommOperationException ex) {
            throw new RuntimeException(ex);
        }
        InputStream inputStream = serialPort.getInputStream();
        int toRead = (int)Math.round((double)this.captureMaxSize * 1000.0 / 100.0);
        this.data = new byte[toRead];
        byte last = -1;
        long lastEvent = startTime = System.currentTimeMillis();
        this.stopRequested = false;
        while (bytesRead < toRead && !this.stopRequested) {
            int i;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (inputStream.available() == 0) {
                if (!(bytesRead == 0 ? this.beginTimeout > 0 && System.currentTimeMillis() - startTime >= (long)this.beginTimeout : this.endTimeout > 0 && System.currentTimeMillis() - lastEvent >= (long)this.endTimeout)) continue;
                break;
            }
            int x = inputStream.read(this.data, bytesRead, toRead - bytesRead);
            bytesRead += x;
            for (i = 0; i < x && this.data[bytesRead - x + i] == last; ++i) {
            }
            if (i == x) {
                if (System.currentTimeMillis() - lastEvent >= (long)this.endTimeout) {
                    break;
                }
            } else {
                lastEvent = System.currentTimeMillis();
            }
            last = this.data[bytesRead - 1];
            if (this.debug <= 10) continue;
            System.out.print(x + "\t" + bytesRead);
            for (i = 0; i < x; ++i) {
                byte num = this.data[bytesRead - x + i];
                System.out.print("\t" + num);
            }
            System.out.println();
        }
        boolean success = this.compute(bytesRead);
        try {
            seq = success ? new ModulatedIrSequence(new IrSequence(this.times, true), this.frequency, -1.0) : null;
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println("Internal error: " + ex.getMessage());
        }
        this.unsetMode();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return seq;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public void setVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isValid() {
        return this.portIdentifier != null;
    }

    @Override
    public boolean stopCapture() {
        if (this.debug > 0) {
            System.err.println("captureStop called");
        }
        this.stopRequested = true;
        return true;
    }

    private boolean compute(int noBytes) {
        if (noBytes == 0) {
            return false;
        }
        return this.mode.pulse() ? this.computePulses(noBytes) : this.computeTimes(noBytes);
    }

    private boolean computeTimes(int noBytes) {
        int offset = 2;
        this.dataLength = noBytes - offset;
        this.times = new int[this.dataLength / 2];
        for (int i = 0; i < this.dataLength / 2; ++i) {
            int t = IrWidget.toIntAsUnsigned(this.data[2 * i + offset]) | IrWidget.toIntAsUnsigned(this.data[2 * i + 1 + offset]) << 8;
            t = (t & 0x8000) != 0 ? t & Short.MAX_VALUE : -t;
            this.times[i] = t * 16;
        }
        return true;
    }

    private boolean computePulses(int noBytes) {
        for (int i = 0; i < noBytes - 1; ++i) {
            this.data[i] = (byte)(0x3F & this.data[i + 1] - this.data[i]);
        }
        this.dataLength = noBytes - 1;
        int periods = 0;
        int bins = 0;
        int pulses = 1;
        int gaps = 0;
        for (int i = 1; i < this.dataLength; ++i) {
            if (i < this.dataLength - 1 && this.data[i] > 0 && this.data[i - 1] > 0 && this.data[i + 1] > 0) {
                periods += this.data[i];
                ++bins;
            }
            if (this.data[i] > 0 && this.data[i - 1] == 0) {
                ++pulses;
            }
            if (this.data[i] != 0 || this.data[i - 1] <= 0) continue;
            ++gaps;
        }
        if (bins == 0) {
            return false;
        }
        if (this.debug > 0) {
            System.out.println("IrWidget read pulses = " + pulses + ", gaps = " + gaps);
        }
        this.frequency = (double)periods / ((double)(bins * 100) * 1.0E-6);
        this.times = new int[pulses + gaps];
        int index = 0;
        int currentCount = 0;
        int currentGap = 0;
        boolean previousState = false;
        boolean currentState = false;
        for (int i = 0; i < this.dataLength; ++i) {
            boolean bl = currentState = this.data[i] > 0;
            if (currentState == previousState) {
                if (currentState) {
                    currentCount += this.data[i];
                } else {
                    currentGap += 100;
                }
            } else if (currentState) {
                currentGap += this.gapDuration(this.data[i]);
                if (index > 0) {
                    this.times[index++] = -currentGap;
                }
                currentCount = this.data[i];
                currentGap = 0;
            } else {
                this.times[index++] = this.pulseDuration(currentCount);
                currentGap = this.gapDuration(this.data[i - 1]) + 100;
                currentCount = 0;
            }
            previousState = currentState;
        }
        int n = this.times[index++] = currentState ? this.pulseDuration(currentCount) : -currentGap;
        if (this.debug > 0) {
            System.out.println(index + " " + pulses + " " + gaps);
        }
        if (this.debug > 0) {
            System.out.println(index + " " + pulses + " " + gaps);
        }
        return true;
    }

    private int pulseDuration(int pulses) {
        int x = (int)Math.round((double)pulses / this.frequency * 1000000.0);
        return x;
    }

    private int gapDuration(int pulses) {
        return 100 - this.pulseDuration(pulses);
    }

    private void setMode(Modes mode) {
        try {
            RXTXPort serial = (RXTXPort)this.commPort;
            serial.setDTR(false);
            serial.setRTS(false);
            Thread.sleep(20L);
            switch (mode) {
                case irwidgetPulse: {
                    serial.setDTR(true);
                    Thread.sleep(200L);
                    serial.setRTS(true);
                    break;
                }
                case miniPovPulse: {
                    serial.setRTS(true);
                    Thread.sleep(200L);
                    serial.setDTR(true);
                    break;
                }
                case irwidgetTime: {
                    serial.setRTS(true);
                    serial.setDTR(true);
                    break;
                }
                case miniPovTime: {
                    serial.setDTR(true);
                    serial.setRTS(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (InterruptedException ex) {
            System.err.println("Interrupted; likely programming error.");
        }
    }

    private void unsetMode() {
        RXTXPort serial = (RXTXPort)this.commPort;
        serial.setDTR(false);
        serial.setRTS(false);
    }

    private static enum Modes {
        irwidgetPulse,
        irwidgetTime,
        miniPovPulse,
        miniPovTime;


        public static boolean pulse(Modes m) {
            return m == irwidgetPulse || m == miniPovPulse;
        }

        public boolean pulse() {
            return this == irwidgetPulse || this == miniPovPulse;
        }

        public static Modes lanidro(int i) {
            int j = 0;
            for (Modes m : Modes.values()) {
                if (i == j) {
                    return m;
                }
                ++j;
            }
            return null;
        }

        public String toString() {
            return this == irwidgetPulse ? "IrWidget count" : (this == irwidgetTime ? "IrWidget time" : (this == miniPovPulse ? "MiniPOV count" : (this == miniPovTime ? "MiniPOV time" : "?")));
        }

        public static String toString(Modes m) {
            return m.toString();
        }
    }
}

