/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.TcpSocketChannel;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.IIrSenderStop;
import org.harctoolbox.harchardware.ir.IRemoteCommandIrSender;
import org.harctoolbox.harchardware.ir.ITransmitter;
import org.harctoolbox.harchardware.ir.LircTransmitter;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class LircClient
implements IHarcHardware,
IRemoteCommandIrSender,
IIrSenderStop,
ITransmitter {
    public static final int lircDefaultPort = 8765;
    public static final String defaultLircIP = "127.0.0.1";
    public static final int defaultTimeout = 5000;
    private static final int P_BEGIN = 0;
    private static final int P_MESSAGE = 1;
    private static final int P_STATUS = 2;
    private static final int P_DATA = 3;
    private static final int P_N = 4;
    private static final int P_DATA_N = 5;
    private static final int P_END = 6;
    private static JCommander argumentParser;
    private static CommandLineArgs commandLineArgs;
    private String lircServerIp;
    private int lircPort;
    private final int portMin = 1;
    private final int portMax = 8;
    private boolean verbose = true;
    private int debug = 0;
    private int timeout = 5000;
    private InetAddress inetAddress = null;
    private String lastRemote = null;
    private String lastCommand = null;
    private String version = null;
    private LircTransmitter lircTransmitter = new LircTransmitter();

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(256);
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        LircClient.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    private static void doExit(boolean success) {
        if (!success) {
            System.err.println("Failed");
        }
        System.exit(success ? 0 : 7);
    }

    private static void doExit(String message, int exitcode) {
        System.err.println(message);
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setCaseSensitiveOptions(false);
        argumentParser.setAllowAbbreviatedOptions(true);
        argumentParser.setProgramName("LircClient");
        CommandSendOnce cmdSendOnce = new CommandSendOnce();
        argumentParser.addCommand("send_once", cmdSendOnce);
        CommandSendStart cmdSendStart = new CommandSendStart();
        argumentParser.addCommand("send_start", cmdSendStart);
        CommandSendStop cmdSendStop = new CommandSendStop();
        argumentParser.addCommand("send_stop", cmdSendStop);
        CommandList cmdList = new CommandList();
        argumentParser.addCommand("list", cmdList);
        CommandSetTransmitters cmdSetTransmitters = new CommandSetTransmitters();
        argumentParser.addCommand("set_transmitters", cmdSetTransmitters);
        CommandSimulate cmdSimulate = new CommandSimulate();
        argumentParser.addCommand("simulate", cmdSimulate);
        CommandVersion cmdVersion = new CommandVersion();
        argumentParser.addCommand("version", cmdVersion);
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            LircClient.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            LircClient.usage(0);
        }
        if (commandLineArgs.versionRequested) {
            System.out.println("HarcHardware version 1.3");
            LircClient.doExit(true);
        }
        String[] splitAddress = commandLineArgs.address.split(":");
        String hostname = splitAddress[0];
        int port = splitAddress.length == 2 ? Integer.parseInt(splitAddress[1]) : commandLineArgs.port;
        try (LircClient lircClient = new LircClient(hostname, port, commandLineArgs.verbose, commandLineArgs.timeout);){
            if (commandLineArgs.listen) {
                lircClient.readLoop();
                System.exit(0);
            }
            if (argumentParser.getParsedCommand() == null) {
                LircClient.usage(1);
            }
            boolean success = true;
            switch (argumentParser.getParsedCommand()) {
                case "send_once": {
                    String command;
                    String remote = (String)cmdSendOnce.commands.get(0);
                    cmdSendOnce.commands.remove(0);
                    Iterator iterator = cmdSendOnce.commands.iterator();
                    while (iterator.hasNext() && (success = lircClient.sendIrCommand(remote, command = (String)iterator.next(), cmdSendOnce.count, null))) {
                    }
                    break;
                }
                case "send_start": {
                    success = lircClient.sendIrCommandRepeat((String)cmdSendStart.args.get(0), (String)cmdSendStart.args.get(1), null);
                    break;
                }
                case "send_stop": {
                    success = lircClient.stopIr((String)cmdSendStop.args.get(0), (String)cmdSendStop.args.get(1), null);
                    break;
                }
                case "list": {
                    String[] result;
                    for (String s : result = cmdList.remote.isEmpty() ? lircClient.getRemotes() : lircClient.getCommands((String)cmdList.remote.get(0))) {
                        System.out.println(s);
                    }
                    break;
                }
                case "set_transmitters": {
                    if (cmdSetTransmitters.transmitters.size() < 1) {
                        LircClient.doExit("Command \"set_transmitters\" requires at least one argument", 1);
                    }
                    LircTransmitter xmitter = new LircTransmitter(cmdSetTransmitters.transmitters);
                    success = lircClient.setTransmitters(xmitter);
                    break;
                }
                case "simulate": {
                    LircClient.doExit("Command \"simulate\" not implemented", 1);
                    break;
                }
                case "version": {
                    System.out.println(lircClient.getVersion());
                    break;
                }
                default: {
                    LircClient.doExit("Unknown command", 1);
                }
            }
            LircClient.doExit(success);
        }
        catch (IOException ex) {
            LircClient.doExit(ex.getMessage(), 3);
        }
        catch (IndexOutOfBoundsException ex) {
            LircClient.doExit("Too few arguments to command", 1);
        }
        catch (NoSuchTransmitterException ex) {
            LircClient.doExit("No such transmitter " + ex.getMessage(), 2);
        }
    }

    public LircClient(String hostname, int port, boolean verbose, int timeout) throws UnknownHostException, IOException {
        this.timeout = timeout;
        this.lircServerIp = hostname != null ? hostname : defaultLircIP;
        this.inetAddress = InetAddress.getByName(hostname);
        this.lircPort = port;
        this.verbose = verbose;
        String[] result = this.sendCommand("VERSION", false);
        this.version = result == null || result.length == 0 ? null : result[0];
    }

    public LircClient(String hostname, boolean verbose, int timeout) throws UnknownHostException, IOException {
        this(hostname, 8765, verbose, timeout);
    }

    public LircClient(String hostname, boolean verbose) throws UnknownHostException, IOException {
        this(hostname, verbose, 5000);
    }

    public LircClient(String hostname) throws UnknownHostException, IOException {
        this(hostname, false);
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public LircTransmitter getTransmitter() {
        return new LircTransmitter();
    }

    public LircTransmitter getTransmitter(int portNo) throws NoSuchTransmitterException {
        if (portNo < 1 || portNo > 8) {
            throw new NoSuchTransmitterException(Integer.toString(portNo));
        }
        return new LircTransmitter(portNo);
    }

    @Override
    public LircTransmitter getTransmitter(String port) throws NoSuchTransmitterException {
        return new LircTransmitter(port);
    }

    @Override
    public String[] getTransmitterNames() {
        String[] result = new String[9];
        int index = 0;
        result[index++] = "default";
        for (int i = 1; i <= 8; ++i) {
            result[index++] = Integer.toString(i);
        }
        return result;
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void readLoop() throws IOException {
        TcpSocketChannel tcpSocketChannel = new TcpSocketChannel(this.lircServerIp, this.lircPort, 0, this.verbose, TcpSocketPort.ConnectionMode.keepAlive);
        tcpSocketChannel.connect();
        BufferedReader inFromServer = tcpSocketChannel.getBufferedIn();
        if (inFromServer == null) {
            throw new IOException("Could not open socket connection to LIRC server " + this.lircServerIp);
        }
        while (true) {
            String line = inFromServer.readLine();
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String[] sendCommand(String packet, boolean oneWord) throws IOException {
        if (this.verbose) {
            System.err.println("Sending command `" + packet + "' to Lirc@" + this.lircServerIp);
        }
        TcpSocketChannel tcpSocketChannel = new TcpSocketChannel(this.lircServerIp, this.lircPort, this.timeout, this.verbose, TcpSocketPort.ConnectionMode.justInTime);
        tcpSocketChannel.connect();
        OutputStream outToServer = tcpSocketChannel.getOut();
        BufferedReader inFromServer = tcpSocketChannel.getBufferedIn();
        if (outToServer == null || inFromServer == null) {
            throw new IOException("Could not open socket connection to LIRC server " + this.lircServerIp);
        }
        tcpSocketChannel.sendString(packet + '\n');
        ArrayList<String> result = new ArrayList<String>(8);
        int status = 0;
        try {
            int state = 0;
            int n = 0;
            boolean done = false;
            int dataN = -1;
            block46: while (!done) {
                String string = inFromServer.readLine();
                if (this.verbose) {
                    System.err.println("Received `" + string + "'");
                }
                if (string == null) {
                    done = true;
                    status = -1;
                    continue;
                }
                switch (state) {
                    case 0: {
                        if (!string.equals("BEGIN")) {
                            System.err.println("!begin");
                            continue block46;
                        }
                        state = 1;
                        continue block46;
                    }
                    case 1: {
                        if (!string.trim().equalsIgnoreCase(packet)) {
                            state = 0;
                            continue block46;
                        }
                        state = 2;
                        continue block46;
                    }
                    case 2: {
                        switch (string) {
                            case "SUCCESS": {
                                status = 0;
                                break;
                            }
                            case "END": {
                                status = 0;
                                done = true;
                                break;
                            }
                            case "ERROR": {
                                System.err.println("command failed: " + packet);
                                status = -1;
                                break;
                            }
                            default: {
                                throw new BadPacketException();
                            }
                        }
                        state = 3;
                        continue block46;
                    }
                    case 3: {
                        switch (string) {
                            case "END": {
                                done = true;
                                continue block46;
                            }
                            case "DATA": {
                                state = 4;
                                continue block46;
                            }
                        }
                        throw new BadPacketException();
                    }
                    case 4: {
                        dataN = Integer.parseInt(string);
                        state = dataN == 0 ? 6 : 5;
                        continue block46;
                    }
                    case 5: {
                        result.add(oneWord ? string.replaceAll("\\S*\\s+", "") : string);
                        if (++n != dataN) continue block46;
                        state = 6;
                        continue block46;
                    }
                    case 6: {
                        if (string.equals("END")) {
                            done = true;
                            continue block46;
                        }
                        throw new BadPacketException();
                    }
                }
                assert (false) : "Unhandled case";
            }
        }
        catch (BadPacketException e) {
            System.err.println("bad return packet");
            status = -1;
        }
        catch (SocketTimeoutException e) {
            System.err.println("Sockettimeout Lirc: " + e.getMessage());
            result = null;
            status = -1;
        }
        catch (IOException e) {
            System.err.println("Couldn't read from " + this.lircServerIp);
            status = -1;
        }
        finally {
            try {
                tcpSocketChannel.close(true);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        if (this.verbose) {
            System.err.println("Lirc command " + (status == 0 ? "succeded." : "failed."));
        }
        return status == 0 && result != null ? result.toArray(new String[result.size()]) : null;
    }

    @Override
    public boolean sendIrCommand(String remote, String command, int count, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        this.lastRemote = remote;
        this.lastCommand = command;
        if (transmitter != null) {
            boolean result;
            if (!LircTransmitter.class.isInstance(transmitter)) {
                throw new NoSuchTransmitterException(transmitter);
            }
            LircTransmitter trans = (LircTransmitter)transmitter;
            if (!trans.isTrivial() && !(result = this.setTransmitters(transmitter))) {
                throw new NoSuchTransmitterException("Error selecting transmitter " + transmitter);
            }
        }
        return this.sendCommand("SEND_ONCE " + remote + " " + command + " " + (count - 1), false) != null;
    }

    public boolean sendIrCommand(String remote, String command, int count, int connector) throws IOException, NoSuchTransmitterException {
        return this.sendIrCommand(remote, command, count, new LircTransmitter(connector));
    }

    @Override
    public boolean sendIrCommandRepeat(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        this.lastRemote = remote;
        this.lastCommand = command;
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_START " + remote + " " + command, false) != null;
    }

    public boolean stopIr(String remote, String command, Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.setTransmitters(transmitter) && this.sendCommand("SEND_STOP " + remote + " " + command, false) != null;
    }

    public boolean stopIr(String remote, String command, int port) throws IOException, NoSuchTransmitterException {
        return this.stopIr(remote, command, new LircTransmitter(port));
    }

    @Override
    public boolean stopIr(Transmitter transmitter) throws IOException, NoSuchTransmitterException {
        return this.stopIr(this.lastRemote, this.lastCommand, transmitter);
    }

    @Override
    public String[] getRemotes() throws IOException {
        return this.sendCommand("LIST", false);
    }

    @Override
    public String[] getCommands(String remote) throws IOException {
        if (remote == null || remote.isEmpty()) {
            throw new NullPointerException("Null remote");
        }
        return this.sendCommand("LIST " + remote, true);
    }

    public boolean setTransmitters(Transmitter transmitter) throws NoSuchTransmitterException, IOException {
        if (transmitter == null) {
            return true;
        }
        if (!LircTransmitter.class.isInstance(transmitter)) {
            throw new NoSuchTransmitterException(transmitter);
        }
        this.lircTransmitter = (LircTransmitter)transmitter;
        return this.setTransmitters();
    }

    public boolean setTransmitters(int port) throws NoSuchTransmitterException, IOException {
        return this.setTransmitters(new LircTransmitter(port));
    }

    public boolean setTransmitters(boolean[] ports) throws NoSuchTransmitterException, IOException {
        LircTransmitter transmitter = new LircTransmitter(ports);
        return this.setTransmitters(transmitter);
    }

    private boolean setTransmitters() throws IOException {
        if (this.lircTransmitter.isTrivial()) {
            return true;
        }
        String s = "SET_TRANSMITTERS " + this.lircTransmitter.toString();
        return this.sendCommand(s, false) != null;
    }

    @Override
    public String getVersion() throws IOException {
        return this.version;
    }

    @Override
    public boolean isValid() {
        return this.version != null;
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    @Parameters(commandDescription="Inquire version of lircd")
    public static final class CommandVersion {
    }

    @Parameters(commandDescription="Simulate sending")
    public static final class CommandSimulate {
    }

    @Parameters(commandDescription="Set transmitters")
    public static final class CommandSetTransmitters {
        @Parameter(description="transmitter...")
        private List<Integer> transmitters = new ArrayList<Integer>(8);
    }

    @Parameters(commandDescription="Inquire the known remotes, or the commands in a remote")
    public static final class CommandList {
        @Parameter(arity=1, description="[remote]")
        private List<String> remote = new ArrayList<String>(1);
    }

    @Parameters(commandDescription="Send one commands many times")
    public static final class CommandSendStop {
        @Parameter(arity=2, description="remote command")
        private List<String> args = new ArrayList<String>(2);
    }

    @Parameters(commandDescription="Send one commands many times")
    public static final class CommandSendStart {
        @Parameter(arity=2, description="remote command")
        private List<String> args = new ArrayList<String>(2);
    }

    @Parameters(commandDescription="Send one or many commands")
    public static final class CommandSendOnce {
        @Parameter(names={"-#", "-c", "--count"}, description="Number of times to send command in send_once")
        private int count = 1;
        @Parameter(description="remote command...")
        private List<String> commands = new ArrayList<String>(16);
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-a", "--address"}, description="IP name or address of lircd host")
        private String address = "localhost";
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"-l", "--listen"}, description="Listen for messages, like irw")
        private boolean listen = false;
        @Parameter(names={"-p", "--port"}, description="Port of lircd")
        private int port = 8765;
        @Parameter(names={"-t", "--timeout"}, description="Timeout in milliseconds")
        private int timeout = 5000;
        @Parameter(names={"--version"}, description="Display version information")
        private boolean versionRequested;
        @Parameter(names={"-v", "--verbose"}, description="Have some commands executed verbosely")
        private boolean verbose;

        private CommandLineArgs() {
        }
    }

    private static class BadPacketException
    extends Exception {
        BadPacketException() {
        }

        BadPacketException(String message) {
            super(message);
        }
    }
}

