/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.ir;

import java.util.ArrayList;
import java.util.List;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;
import org.harctoolbox.harchardware.ir.Transmitter;

public class LircTransmitter
extends Transmitter {
    public static final int NOMASK = -1;
    private int[] transmitters;

    private static List<Integer> parseBoolean(boolean[] ports) {
        ArrayList<Integer> prts = new ArrayList<Integer>(8);
        for (int i = 0; i < ports.length; ++i) {
            if (!ports[i]) continue;
            prts.add(i + 1);
        }
        return prts;
    }

    private static List<Integer> parseString(String str) {
        if (str.equals("default")) {
            return null;
        }
        String[] pieces = str.split("\\D+");
        ArrayList<Integer> result = new ArrayList<Integer>(8);
        for (String s : pieces) {
            result.add(Integer.parseInt(s));
        }
        return result;
    }

    public LircTransmitter() {
        this.transmitters = null;
    }

    public LircTransmitter(int[] transmitters) {
        this.transmitters = transmitters;
    }

    public LircTransmitter(int xmitter) throws NoSuchTransmitterException {
        if (xmitter < 0) {
            throw new NoSuchTransmitterException("Invalid transmitter: " + xmitter);
        }
        this.transmitters = new int[]{xmitter};
    }

    public LircTransmitter(boolean[] ports) {
        this(LircTransmitter.parseBoolean(ports));
    }

    public LircTransmitter(String str) {
        this(LircTransmitter.parseString(str));
    }

    public LircTransmitter(List<Integer> ports) {
        if (ports == null || ports.isEmpty()) {
            this.transmitters = null;
        } else {
            this.transmitters = new int[ports.size()];
            for (int i = 0; i < ports.size(); ++i) {
                this.transmitters[i] = ports.get(i);
            }
        }
    }

    public String toString() {
        if (this.isTrivial()) {
            return "";
        }
        StringBuilder s = new StringBuilder(16);
        for (int i = 0; i < this.transmitters.length; ++i) {
            if (i > 0) {
                s.append(" ");
            }
            s.append(this.transmitters[i]);
        }
        return s.toString();
    }

    public int toMask() {
        if (this.transmitters == null) {
            return -1;
        }
        int mask = 0;
        for (int t : this.transmitters) {
            mask |= 1 << t - 1;
        }
        return mask;
    }

    public boolean isTrivial() {
        return this.transmitters == null || this.transmitters.length == 0;
    }
}

