/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.misc;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.harchardware.Utils;
import org.harctoolbox.harchardware.comm.UdpSocketChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OppoIp
implements Closeable {
    private static final int broadcastPort = 7624;
    private static final int defaultTimeout = 2000;
    private static final String discoverString = "NOTIFY OREMOTE LOGIN";
    private static final String namespace = "http://schemas.xmlsoap.org/soap/oppo/oremote/";
    private static final String myId = "fffbebbfa7060200180373d48892";
    private static final String requesttag = "OSeWFcV78yJe8f9D";
    private static final String password = "oppo80031722";
    private static final String commandName = "command";
    private static final String signinName = "signin";
    private static final String signoutName = "signout";
    private static final String responseAckName = "response_ack";
    private static final String signintype = "1";
    private static final String signouttype = "0";
    private static final String requestName = "request";
    private static final String ackName = "ack";
    private boolean verbose;
    private InetAddress ip;
    private int port;
    private UdpSocketChannel udpSocketChannel;
    private final int timeout;

    private static InetAddress myBroadcastAddress() {
        try {
            InetAddress myIp = InetAddress.getByName(Utils.getHostname());
            byte[] ipNumeric = myIp.getAddress();
            ipNumeric[3] = 0;
            return InetAddress.getByAddress(ipNumeric);
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    private static String dom2String(Document doc) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return output;
    }

    public static void main(String[] args) {
        try (OppoIp oppoIp = new OppoIp(true);){
            oppoIp.sendCommand(args[0]);
        }
        catch (IOException | TransformerException ex) {
            Logger.getLogger(OppoIp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public OppoIp(String broadcast, int timeout, boolean verbose) throws IOException, TransformerException {
        this(InetAddress.getByName(broadcast), timeout, verbose);
    }

    public OppoIp() throws IOException, TransformerException {
        this(OppoIp.myBroadcastAddress(), 2000, false);
    }

    public OppoIp(boolean verbose) throws IOException, TransformerException {
        this(OppoIp.myBroadcastAddress(), 2000, verbose);
    }

    public OppoIp(InetAddress broadcast, int timeout, boolean verbose) throws IOException, TransformerException {
        this.timeout = timeout;
        this.verbose = verbose;
        this.discover(broadcast);
        this.udpSocketChannel = new UdpSocketChannel(this.ip, this.port, timeout, verbose);
        this.signIn();
    }

    private void discover(InetAddress broadcast) throws IOException {
        UdpSocketChannel broadcaster = new UdpSocketChannel(broadcast, 7624, this.timeout, this.verbose);
        broadcaster.sendString(discoverString);
        String answer = broadcaster.readString();
        String[] arr = answer.split(":");
        this.ip = InetAddress.getByName(arr[1].trim());
        this.port = Integer.parseInt(arr[2].trim());
    }

    private void signIn() throws TransformerException, IOException {
        this.udpSocketChannel.sendString(OppoIp.dom2String(this.mkDom(requestName, signinName, signintype, password, null)));
        String ans = this.udpSocketChannel.readString();
        System.out.println(ans);
        this.checkResponse(ans);
        this.udpSocketChannel.sendString(OppoIp.dom2String(this.mkDom(ackName, responseAckName, null, null, null)));
    }

    private void signOut() throws IOException, TransformerException {
        this.udpSocketChannel.sendString(OppoIp.dom2String(this.mkDom(requestName, signoutName, signouttype, null, null)));
        String ans = this.udpSocketChannel.readString();
        System.out.println(ans);
    }

    @Override
    public void close() {
        try {
            this.signOut();
            this.udpSocketChannel.close();
        }
        catch (IOException | TransformerException ex) {
            Logger.getLogger(OppoIp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean checkResponse(String ans) {
        return true;
    }

    public void sendCommand(String cmd) throws IOException, TransformerException {
        this.udpSocketChannel.sendString(OppoIp.dom2String(this.mkDom(requestName, commandName, null, null, cmd)));
    }

    private Document mkDom(String typeName, String nameContent, String signinTypeContent, String passwordContent, String contentContent) {
        Document doc = XmlUtils.newDocument(true);
        Element root = doc.createElementNS(namespace, "s:Envelope");
        doc.appendChild(root);
        Element body = doc.createElement("body");
        root.appendChild(body);
        Element request = doc.createElement(typeName);
        body.appendChild(request);
        Element name = doc.createElement("name");
        request.appendChild(name);
        name.setTextContent(nameContent);
        Element uid = doc.createElement("uid");
        uid.setTextContent(myId);
        request.appendChild(uid);
        Element requestTag = doc.createElement("requesttag");
        requestTag.setTextContent(requesttag);
        request.appendChild(requestTag);
        if (passwordContent != null) {
            Element passWord = doc.createElement("password");
            passWord.setTextContent(passwordContent);
            request.appendChild(passWord);
        }
        if (contentContent != null) {
            Element content = doc.createElement("content");
            content.setTextContent(contentContent);
            request.appendChild(content);
        }
        if (signinTypeContent != null) {
            Element signinType = doc.createElement("signintype");
            signinType.setTextContent(signinTypeContent);
            request.appendChild(signinType);
        }
        return doc;
    }
}

