/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.harchardware.misc;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortRaw;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;

public class SonySerialCommand {
    public static final int size = 8;
    private static final byte startToken = -87;
    private static final byte stopToken = -102;
    private byte[] data;

    public static byte[] bytes(int n1, int n2, Type sg, int payload) {
        return (byte[])new SonySerialCommand((int)n1, (int)n2, (Type)sg, (int)payload).data.clone();
    }

    public static byte[] bytes(int n1, int n2, Type sg) {
        return SonySerialCommand.bytes(n1, n2, sg, 0);
    }

    public static byte[] bytes(int n1, int n2) {
        return SonySerialCommand.bytes(n1, n2, Type.set, 0);
    }

    public static Command interpret(byte[] data) {
        SonySerialCommand ssc = new SonySerialCommand(data);
        if (data[0] != -87 || data[7] != -102) {
            return null;
        }
        if (ssc.checksum() != ssc.data[6]) {
            return null;
        }
        return new Command(ssc);
    }

    public static void main(String[] args) {
        boolean useGlobalCache = true;
        IHarcHardware port = null;
        if (useGlobalCache) {
            try {
                GlobalCache gc = new GlobalCache("gc", true);
                gc.setSerial(1, "38400,FLOW_NONE,PARITY_EVEN");
                port = gc.getSerialPort(1);
            }
            catch (IOException | NoSuchTransmitterException ex) {
                System.err.println(ex.getMessage());
                System.exit(7);
            }
        } else {
            try {
                port = new LocalSerialPortRaw("/dev/ttyS0", 38400, 8, 1, LocalSerialPort.Parity.EVEN, LocalSerialPort.FlowControl.NONE, 2000, true);
                ((IHarcHardware)port).open();
            }
            catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | HarcHardwareException ex) {
                System.err.println(ex.getMessage());
                System.exit(7);
            }
        }
        if (port == null) {
            System.err.println("Could not set up the serial port, bailing out");
            System.exit(7);
        }
        int upper = 1;
        int lower = 19;
        Type type = Type.get;
        byte[] cmd = SonySerialCommand.bytes(upper, lower, type);
        try {
            port.sendBytes(cmd);
            if (upper <= 1) {
                byte[] answer = port.readBytes(8);
                Command response = SonySerialCommand.interpret(answer);
                System.out.println(response);
                System.out.println(response.getData());
            }
            port.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private SonySerialCommand() {
    }

    private SonySerialCommand(byte[] data) {
        if (data.length != 8) {
            throw new IllegalArgumentException("Wrong size data, " + data.length);
        }
        this.data = data;
    }

    private SonySerialCommand(int n1, int n2, Type sg, int payload) {
        int index = 0;
        this.data = new byte[8];
        this.data[index++] = -87;
        this.data[index++] = (byte)(n1 & 0xFF);
        this.data[index++] = (byte)(n2 & 0xFF);
        this.data[index++] = (byte)sg.toInt();
        this.data[index++] = (byte)(payload >> 8 & 0xFF);
        this.data[index++] = (byte)(payload & 0xFF);
        this.data[index++] = this.checksum();
        this.data[index] = -102;
    }

    private SonySerialCommand(int n1, int n2, Type sg) {
        this(n1, n2, sg, 0);
    }

    private SonySerialCommand(int n1, int n2) {
        this(n1, n2, Type.set, 0);
    }

    private byte checksum() {
        int sum = 0;
        for (int i = 1; i <= 5; ++i) {
            sum |= this.data[i];
        }
        return (byte)sum;
    }

    public static enum Type {
        set,
        get,
        replyWithData,
        replyWithoutData;


        int toInt() {
            return this.ordinal();
        }
    }

    public static class Command {
        private final int n1;
        private final int n2;
        private final Type type;
        private final int data;

        public Command(int[] data) {
            this.n1 = data[0];
            this.n2 = data[1];
            this.type = Type.values()[data[2]];
            this.data = data[3];
        }

        public Command(SonySerialCommand ssc) {
            this.n1 = ssc.data[1];
            this.n2 = ssc.data[2];
            this.type = Type.values()[ssc.data[3]];
            this.data = 256 * this.unsigned(ssc.data[4]) + this.unsigned(ssc.data[5]);
        }

        private int unsigned(byte b) {
            return b >= 0 ? b : b + 256;
        }

        public String toString() {
            StringBuilder str = new StringBuilder(32);
            str.append("n1 = ").append(this.n1);
            str.append("; n2 = ").append(this.n2);
            str.append("; type = ").append((Object)this.type);
            str.append("; data = ").append(this.data);
            return str.toString();
        }

        public int getData() {
            return this.data;
        }
    }
}

