/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpMaster;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.irscrutinizer.GuiMain;
import org.harctoolbox.irscrutinizer.Props;
import org.xml.sax.SAXException;

public class IrScrutinizer {
    public static final String feedbackMail = "feedback@harctoolbox.org";
    public static final String issuesUrl = "https://github.com/bengtmartensson/harctoolboxbundle/issues";
    public static final String gitUrl = "https://github.com/bengtmartensson/harctoolboxbundle/";
    public static final long invalid = -1L;
    private static final String backupsuffix = "back";
    private static JCommander argumentParser;
    private static final CommandLineArgs commandLineArgs;

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(256);
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        IrScrutinizer.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("--irpmaster")) {
            try {
                String appHome = IrScrutinizer.findApplicationHome(null);
                Props properties = new Props(appHome);
                String[] newargs = new String[args.length + 1];
                newargs[0] = "--config";
                newargs[1] = properties.mkPathAbsolute(properties.getIrpProtocolsIniPath());
                System.arraycopy(args, 1, newargs, 2, newargs.length - 2);
                IrpMaster.main(newargs);
                System.exit(0);
            }
            catch (URISyntaxException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
        }
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("IrScrutinizer");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            IrScrutinizer.usage(1);
        }
        if (commandLineArgs.irpmaster) {
            IrScrutinizer.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            IrScrutinizer.usage(0);
        }
        if (commandLineArgs.versionRequested) {
            System.out.println("IrScrutinizer version 1.3");
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.out.println();
            System.out.println("Copyright (C) 2013, 2014, 2015, 2016 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the termsof the GNU General Public License as published by the Free Software Foundation;either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public Licensealong with this program. If not, see http://www.gnu.org/licenses/.");
            System.exit(0);
        }
        if (commandLineArgs.nukeProperties) {
            IrScrutinizer.nukeProperties(true);
            System.exit(0);
        }
        try {
            String applicationHome = IrScrutinizer.findApplicationHome(commandLineArgs.applicationHome);
            if (commandLineArgs.debug > 0) {
                System.err.println("applicationHome = " + applicationHome);
            }
            IrScrutinizer.guiExecute(applicationHome, commandLineArgs.propertiesFilename, commandLineArgs.verbose, commandLineArgs.debug, commandLineArgs.experimental ? 1 : 0, commandLineArgs.arguments);
        }
        catch (URISyntaxException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
    }

    private static String findApplicationHome(String appHome) throws URISyntaxException {
        String applicationHome;
        String string = applicationHome = appHome != null ? appHome : System.getenv("IRSCRUTINIZERHOME");
        if (applicationHome == null) {
            URL url = IrScrutinizer.class.getProtectionDomain().getCodeSource().getLocation();
            File dir = new File(url.toURI()).getParentFile();
            String string2 = applicationHome = dir.getName().equals("build") || dir.getName().equals("dist") ? dir.getParent() : dir.getPath();
        }
        if (applicationHome != null && !applicationHome.endsWith(File.separator)) {
            applicationHome = applicationHome + File.separator;
        }
        return applicationHome;
    }

    private static String nukeProperties(boolean verbose) {
        Props properties = new Props(commandLineArgs.propertiesFilename, commandLineArgs.applicationHome);
        String filename = properties.getFilename();
        String newFilename = filename + "." + backupsuffix;
        if (verbose) {
            System.out.println("Renaming the properties file " + filename + " to " + newFilename + ".");
        }
        new File(filename).deleteOnExit();
        try {
            return Files.copy(new File(filename).toPath(), new File(newFilename).toPath(), StandardCopyOption.REPLACE_EXISTING).toString();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    private static void guiExecute(final String applicationHome, final String propsfilename, final boolean verbose, final int debug, final int userlevel, final List<String> arguments) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new GuiMain(applicationHome, propsfilename, verbose, debug, userlevel, arguments).setVisible(true);
                }
                catch (HeadlessException ex) {
                    System.err.println("This program does not run in headless mode.");
                }
                catch (IOException | RuntimeException | URISyntaxException | ParseException | IncompatibleArgumentException ex) {
                    GuiUtils.fatal(ex, 5, new GuiUtils.EmergencyFixer(){
                        private String backupfile;

                        @Override
                        public void fix() {
                            this.backupfile = IrScrutinizer.nukeProperties(false);
                        }

                        @Override
                        public String getQuestion() {
                            return "Remove the properites file?";
                        }

                        @Override
                        public String getYesMessage() {
                            return "Renamed the properties file to " + this.backupfile + ".";
                        }

                        @Override
                        public String getNoMessage() {
                            return null;
                        }
                    });
                }
                catch (ParserConfigurationException ex) {
                    GuiUtils.fatal(ex, 4);
                }
                catch (SAXException ex) {
                    GuiUtils.fatal(ex, 8);
                }
            }
        });
    }

    private IrScrutinizer() {
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-D", "--debug"}, description="Debug code")
        private int debug = 0;
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"-H", "--home", "--applicationhome", "--apphome"}, description="Set application home (where files are located)")
        private String applicationHome = null;
        @Parameter(names={"--nuke-properties"}, description="Get rid of present properties file")
        private boolean nukeProperties = false;
        @Parameter(names={"--irpmaster"}, description="Invoke IrpMaster on the rest of the parameters; must be first option.")
        private boolean irpmaster = false;
        @Parameter(names={"-p", "--properties"}, description="Pathname of properties file")
        private String propertiesFilename = null;
        @Parameter(names={"-V", "--version"}, description="Display version information")
        private boolean versionRequested;
        @Parameter(names={"-v", "--verbose"}, description="Have some commands executed verbosely")
        private boolean verbose;
        @Parameter(names={"-x", "--experimental"}, description="Enable experimental features")
        private boolean experimental;
        @Parameter(description="Arguments to the program")
        private List<String> arguments = new ArrayList<String>(4);

        private CommandLineArgs() {
        }
    }
}

