/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;

public abstract class NamedIrSignal {
    private static int count = 0;
    private final Date date;
    private boolean validated;
    private String name;
    private String comment;
    private final int numeral = NamedIrSignal.incrementCount();

    private static synchronized int incrementCount() {
        return ++count;
    }

    protected static synchronized void decrementCount() {
        --count;
    }

    public NamedIrSignal(String name, String comment) {
        this.date = new Date();
        this.name = name;
        this.comment = comment;
        this.validated = false;
    }

    public int getNumeral() {
        return this.numeral;
    }

    public String getDate() {
        return new SimpleDateFormat("HH:mm:ss").format(this.date);
    }

    public boolean getValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String csvString(String separator) {
        StringBuilder str = new StringBuilder(128);
        str.append(this.numeral).append(separator);
        str.append(this.name).append(separator);
        str.append(this.validated ? "true" : "false");
        return str.toString();
    }

    public String toPrintString() {
        return this.csvString(", ");
    }

    public static abstract class LearnedIrSignalTableModel
    extends DefaultTableModel {
        private final AbstractColumnFunction columnsFunc;
        private boolean scrollRequest = false;
        protected boolean unsavedChanges = false;

        protected LearnedIrSignalTableModel(AbstractColumnFunction columnFunc) {
            super(columnFunc.headers(), 0);
            this.columnsFunc = columnFunc;
        }

        public abstract String getType();

        public abstract Command toCommand(int var1) throws IrpMasterException;

        public HashMap<String, Command> getCommands(boolean forgiveSillySignals) throws IrpMasterException {
            LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(this.getRowCount() + 10);
            for (int row = 0; row < this.getRowCount(); ++row) {
                try {
                    Command command = this.toCommand(row);
                    if (command == null) continue;
                    commands.put(command.getName(), command);
                    continue;
                }
                catch (IrpMasterException ex) {
                    if (forgiveSillySignals) {
                        String commandName = (String)this.getValueAt(row, this.columnsFunc.getPosName());
                        String commandComment = (String)this.getValueAt(row, this.columnsFunc.getPosComment());
                        System.err.println("Warning: Signal named " + commandName + " (" + commandComment + ") could not be rendered (" + ex.getMessage() + "); ignored.");
                        continue;
                    }
                    throw ex;
                }
            }
            return commands;
        }

        public synchronized void clearComment() {
            for (int row = 0; row < this.getRowCount(); ++row) {
                NamedIrSignal nir = (NamedIrSignal)this.getValueAt(row, this.columnsFunc.getPosIrSignal());
                nir.setComment(null);
                this.setValueAt(null, row, this.columnsFunc.getPosComment());
            }
            this.unsavedChanges = true;
        }

        public ArrayList<String> getNonUniqueNames() {
            ArrayList<String> duplicates = new ArrayList<String>(32);
            ArrayList<String> allNames = new ArrayList<String>(this.getRowCount() + 10);
            for (int row = 0; row < this.getRowCount(); ++row) {
                String name = (String)this.getValueAt(row, this.columnsFunc.getPosName());
                if (allNames.contains(name)) {
                    if (duplicates.contains(name)) continue;
                    duplicates.add(name);
                    continue;
                }
                allNames.add(name);
            }
            return duplicates;
        }

        public ArrayList<Integer> getUnusedColumns() {
            ArrayList<Integer> list = new ArrayList<Integer>(16);
            if (this.getRowCount() > 0) {
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    if (this.isUsedColumn(column)) continue;
                    list.add(column);
                }
            }
            return list;
        }

        @Override
        public final Class<?> getColumnClass(int columnIndex) {
            return this.columnsFunc.clazz(columnIndex);
        }

        public final String columnName(int i) {
            return this.columnsFunc.name(i);
        }

        public boolean isUsedColumn(int column) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object thing = this.getValueAt(row, column);
                if (thing == null || !(this.getColumnClass(column) == Boolean.class ? (Boolean)this.getValueAt(row, column) != false : (this.getColumnClass(column) == String.class ? !((String)this.getValueAt(row, column)).isEmpty() : this.getValueAt(row, column) != null))) continue;
                return true;
            }
            return false;
        }

        public ArrayList<Integer> getUninterestingColumns() {
            ArrayList<Integer> list = new ArrayList<Integer>(16);
            if (this.getRowCount() > 0) {
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    if (this.isInterestingColumn(column)) continue;
                    list.add(column);
                }
            }
            return list;
        }

        public boolean isInterestingColumn(int column) {
            if (this.columnsFunc.getPosDate() == column || this.columnsFunc.getPosNumber() == column) {
                return false;
            }
            if (this.columnsFunc.getPosName() == column) {
                return true;
            }
            if (this.getRowCount() < 2) {
                return true;
            }
            Object firstThing = this.getValueAt(0, column);
            for (int row = 1; row < this.getRowCount(); ++row) {
                Object thing = this.getValueAt(row, column);
                if (!(firstThing == null ? thing != null : !firstThing.equals(thing))) continue;
                return true;
            }
            return false;
        }

        protected synchronized void addSignal(NamedIrSignal cir) {
            this.addRow(this.columnsFunc.toObjectArray(cir));
            this.scrollRequest = true;
            this.unsavedChanges = true;
        }

        public synchronized boolean getAndResetScrollRequest() {
            boolean old = this.scrollRequest;
            this.scrollRequest = false;
            return old;
        }

        public boolean validRow(int row) {
            return row >= 0 && row < this.getRowCount();
        }

        @Override
        public final boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.columnsFunc.isEditable(columnIndex);
        }

        public String toPrintString(int modelRow) {
            if (modelRow < 0) {
                return null;
            }
            StringBuilder str = new StringBuilder(64);
            for (int i = 0; i < this.columnsFunc.noFields(); ++i) {
                Object thing = this.getValueAt(modelRow, i);
                str.append(" ").append(thing != null ? thing.toString() : "null");
            }
            return str.toString();
        }

        void clearUnsavedChanges() {
            this.unsavedChanges = false;
        }

        boolean hasUnsavedChanges() {
            return this.unsavedChanges;
        }
    }

    public static abstract class LearnedIrSignalTableColumnModel
    extends DefaultTableColumnModel {
        private final AbstractColumnFunction columnFunc;

        public LearnedIrSignalTableColumnModel(AbstractColumnFunction icolumn) {
            this.columnFunc = icolumn;
            this.setup();
        }

        private void setup() {
            for (int i = 0; i < this.columnFunc.noFields(); ++i) {
                TableColumn column = new TableColumn(i, this.columnFunc.width(i));
                column.setHeaderValue(this.columnFunc.name(i));
                column.setIdentifier(i);
                this.addColumn(column);
            }
        }

        public void removeColumn(int i) {
            this.removeColumn(this.getColumn(i));
        }

        public void reset() {
            this.tableColumns.clear();
            this.setup();
        }

        protected void setup(String[] columnNames, int[] widths, int noFields) {
            for (int i = 0; i < noFields; ++i) {
                TableColumn column = new TableColumn(i, widths[i]);
                column.setHeaderValue(columnNames[i]);
                this.addColumn(column);
            }
        }

        public void removeColumns(Collection<Integer> list) {
            for (int column = this.getColumnCount() - 1; column >= 0; --column) {
                TableColumn col = this.getColumn(column);
                if (!list.contains(col.getModelIndex())) continue;
                this.removeColumn(col);
            }
        }
    }

    protected static abstract class AbstractColumnFunction {
        private final String[] columnNames;
        private final int[] widths;
        private Class[] classes;
        private int toIgnore;

        AbstractColumnFunction(String[] columnNames, int[] widths, Class[] classes, int toIgnore) {
            this.columnNames = columnNames;
            this.widths = widths;
            if (widths.length != columnNames.length) {
                throw new IllegalArgumentException();
            }
            this.classes = classes;
            if (classes.length != columnNames.length) {
                throw new IllegalArgumentException();
            }
            this.toIgnore = toIgnore;
        }

        public abstract boolean isEditable(int var1);

        public abstract Object[] toObjectArray(NamedIrSignal var1);

        public abstract int getPosName();

        public abstract int getPosComment();

        public abstract int getPosIrSignal();

        public abstract int getPosDate();

        public abstract int getPosNumber();

        public int noFields() {
            return this.columnNames.length - this.toIgnore;
        }

        public String name(int i) {
            return this.columnNames[i];
        }

        public int width(int i) {
            return this.widths[i];
        }

        public Class<?> clazz(int i) {
            return this.classes[i];
        }

        public Object[] headers() {
            Object[] result = new Object[this.columnNames.length];
            System.arraycopy(this.columnNames, 0, result, 0, this.columnNames.length);
            return result;
        }
    }
}

