/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMaster;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.irscrutinizer.NamedIrSignal;

public class ParametrizedIrSignal
extends NamedIrSignal {
    private static boolean generateRaw = true;
    private static boolean generateCcf = true;
    private static IrpMaster irpMaster = null;
    private HashMap<String, Long> parameters;
    private String protocolName;

    public static void setGenerateRaw(boolean aGenerateRaw) {
        generateRaw = aGenerateRaw;
    }

    public static void setGenerateCcf(boolean aGenerateCcf) {
        generateCcf = aGenerateCcf;
    }

    public static void setIrpMaster(IrpMaster aIrpMaster) {
        irpMaster = aIrpMaster;
    }

    private static String formatMiscParams(HashMap<String, Long> params) {
        if (params == null) {
            return "";
        }
        StringBuilder str = new StringBuilder(16);
        for (Map.Entry<String, Long> kvp : params.entrySet()) {
            String key = kvp.getKey();
            if (key.equals("D") || key.equals("S") || key.equals("F") || key.equals("T")) continue;
            if (str.length() > 0) {
                str.append(" ");
            }
            str.append(key).append("=").append(kvp.getValue());
        }
        return str.toString();
    }

    public ParametrizedIrSignal(Command command) throws IrpMasterException {
        super(command.getName(), command.getComment());
        this.protocolName = command.getProtocolName();
        this.parameters = command.getParameters();
    }

    public ParametrizedIrSignal(String protocolName, HashMap<String, Long> parameters, String name, String comment) {
        super(name, comment);
        this.parameters = parameters;
        this.protocolName = protocolName;
    }

    public ParametrizedIrSignal(String protocolName, long device, long subdevice, long function, String name, String comment) {
        super(name, comment);
        this.parameters = new HashMap(3);
        this.setParameter("F", function);
        this.setParameter("D", device);
        this.setParameter("S", subdevice);
        this.protocolName = protocolName;
    }

    public ParametrizedIrSignal(String protocolName, long device, long function, String name, String comment) {
        this(protocolName, device, -1L, function, name, comment);
    }

    public ParametrizedIrSignal(DecodeIR.DecodedSignal decode, String name, String comment) {
        this(decode.getProtocol(), decode.getParameters(), name, comment);
    }

    public ParametrizedIrSignal(IrSignal irSignal, String name, String comment, boolean ignoreT) throws DecodeIR.DecodeIrException {
        super(name, comment);
        DecodeIR.DecodedSignal[] decodes = DecodeIR.decode(irSignal);
        if (decodes.length == 0) {
            ParametrizedIrSignal.decrementCount();
            throw new DecodeIR.DecodeIrException("No decode");
        }
        DecodeIR.DecodedSignal decode = decodes[0];
        if (decode.getProtocol().substring(0, 3).equalsIgnoreCase("gap")) {
            ParametrizedIrSignal.decrementCount();
            throw new DecodeIR.DecodeIrException("No sensible decode");
        }
        this.protocolName = decode.getProtocol();
        this.parameters = decode.getParameters();
        if (ignoreT && this.parameters.containsKey("T")) {
            this.parameters.remove("T");
        }
    }

    public void digestMiscParameters(String payload) {
        String[] chunks;
        if (payload == null || payload.trim().isEmpty()) {
            return;
        }
        for (String name : this.parameters.keySet().toArray(new String[this.parameters.size()])) {
            if (name.equals("D") || name.equals("S") || name.equals("F") || name.equals("T")) continue;
            this.parameters.remove(name);
        }
        for (String chunk : chunks = payload.split("\\s+")) {
            String[] kvp = chunk.split("=");
            String name = kvp[0];
            long value = Long.parseLong(kvp[1]);
            if (name.equals("D") || name.equals("S") || name.equals("F") || name.equals("T")) continue;
            this.setParameter(name, value);
        }
    }

    public void nukeHex() {
        this.parameters.remove("hex");
    }

    public String getProtocol() {
        return this.protocolName;
    }

    public long getParameter(String param) {
        Long val = this.parameters.get(param);
        return val != null ? val : -1L;
    }

    private void setParameter(String name, Object object) {
        this.setParameter(name, object != null ? (long)((Integer)object).intValue() : -1L);
    }

    public final void setParameter(String name, long value) {
        if (value == -1L) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public String formatMiscParameters() {
        return ParametrizedIrSignal.formatMiscParams(this.parameters);
    }

    @Override
    public String toPrintString() {
        return this.csvString(", ") + ", " + this.protocolName + ", " + this.parameters.toString();
    }

    public Command toCommand() throws IrpMasterException {
        if (this.protocolName == null || this.protocolName.isEmpty()) {
            throw new IrpMasterException("Protocol name is empty");
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            throw new IrpMasterException("Parameters missing");
        }
        HashMap localParameters = (HashMap)this.parameters.clone();
        localParameters.remove("hex");
        Command command = new Command(this.getName(), this.getComment(), this.protocolName, localParameters);
        return command;
    }

    public static class ParameterIrSignalTableModel
    extends NamedIrSignal.LearnedIrSignalTableModel {
        public ParameterIrSignalTableModel() {
            super(new ParameterIrSignalColumns());
        }

        public ParametrizedIrSignal getParameterIrSignal(int row) {
            return this.validRow(row) ? (ParametrizedIrSignal)this.getValueAt(row, ParameterIrSignalColumns.posParameterIrSignal) : null;
        }

        public void addSignal(ParametrizedIrSignal signal) {
            super.addSignal(signal);
        }

        public void setFToHex() {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Long hex = this.getParameterIrSignal(row).getParameter("hex");
                if (hex == -1L) continue;
                this.setValueAt(hex.intValue(), row, 5);
            }
            this.fireTableDataChanged();
        }

        public ArrayList<Long> listF(Command reference) throws IrpMasterException {
            ArrayList<Long> list = new ArrayList<Long>(16);
            HashMap params = (HashMap)reference.getParameters().clone();
            params.remove("F");
            for (int row = 0; row < this.getRowCount(); ++row) {
                Command cmd = this.toCommand(row);
                if (!reference.getProtocolName().equalsIgnoreCase(cmd.getProtocolName())) continue;
                boolean eq = true;
                for (Map.Entry kvp : params.entrySet()) {
                    if (cmd.getParameters().get(kvp.getKey()).longValue() == ((Long)kvp.getValue()).longValue()) continue;
                    eq = false;
                    break;
                }
                if (!eq) continue;
                Long F = cmd.getParameters().get("F");
                list.add(F);
            }
            return list;
        }

        public void setProtocol(String newProtocol) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.setValueAt(newProtocol, row, 2);
            }
            this.fireTableDataChanged();
        }

        public void setMiscParameters(String value) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.setValueAt(value, row, 7);
            }
            this.fireTableDataChanged();
        }

        private int colPos(String name) {
            return name.equals("D") ? 3 : (name.equals("S") ? 4 : (name.equals("F") ? 5 : (name.equals("T") ? 6 : -1)));
        }

        public void setParameter(int colPos, long value) {
            if (colPos < 0) {
                return;
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.setValueAt(value != -1L ? Integer.valueOf((int)value) : null, row, colPos);
            }
            this.fireTableDataChanged();
        }

        public void setParameter(String name, long value) {
            this.setParameter(this.colPos(name), value);
        }

        public void unsetParameter(int colPos) {
            if (colPos < 0) {
                return;
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.setValueAt(null, row, colPos);
            }
            this.fireTableDataChanged();
        }

        public void unsetParameter(String name) {
            this.unsetParameter(this.colPos(name));
        }

        public void nukeHex() {
            for (int row = 0; row < this.getRowCount(); ++row) {
                ParametrizedIrSignal pir = this.getParameterIrSignal(row);
                pir.nukeHex();
                this.setValueAt(pir.formatMiscParameters(), row, 7);
            }
        }

        @Override
        public Command toCommand(int row) throws IrpMasterException {
            ParametrizedIrSignal pir = this.getParameterIrSignal(row);
            return pir.toCommand();
        }

        @Override
        public String toPrintString(int row) {
            ParametrizedIrSignal pir = this.getParameterIrSignal(row);
            return super.toPrintString(row) + ": " + (pir != null ? pir.toPrintString() : "null");
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
            ParametrizedIrSignal pir = this.getParameterIrSignal(row);
            this.unsavedChanges = true;
            switch (column) {
                case 2: {
                    pir.protocolName = (String)this.getValueAt(row, column);
                    break;
                }
                case 3: {
                    pir.setParameter("D", this.getValueAt(row, column));
                    break;
                }
                case 4: {
                    pir.setParameter("S", this.getValueAt(row, column));
                    break;
                }
                case 5: {
                    pir.setParameter("F", this.getValueAt(row, column));
                    break;
                }
                case 6: {
                    pir.setParameter("T", this.getValueAt(row, column));
                    break;
                }
                case 7: {
                    pir.digestMiscParameters((String)this.getValueAt(row, column));
                    break;
                }
                case 8: {
                    pir.setValidated((Boolean)this.getValueAt(row, column));
                    break;
                }
                case 9: {
                    pir.setName((String)this.getValueAt(row, column));
                    break;
                }
                case 10: {
                    pir.setComment((String)this.getValueAt(row, column));
                    break;
                }
            }
        }

        @Override
        public String getType() {
            return "parametrized";
        }
    }

    public static class ParameterIrSignalTableColumnModel
    extends NamedIrSignal.LearnedIrSignalTableColumnModel {
        public ParameterIrSignalTableColumnModel() {
            super(new ParameterIrSignalColumns());
        }
    }

    private static class ParameterIrSignalColumns
    extends NamedIrSignal.AbstractColumnFunction {
        private static final int[] widths = new int[]{15, 60, 60, 25, 25, 25, 25, 100, 25, 100, 200, 10};
        private static final String[] columnNames = new String[]{"#", "Date", "Protocol", "D", "S", "F", "T", "Misc. params", "Ver.", "Name", "Comment", "Signal"};
        private static final Class<?>[] classes = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class, Boolean.class, String.class, String.class, ParametrizedIrSignal.class};
        public static final int toIgnore = 1;
        public static final int posNumber = 0;
        public static final int posDate = 1;
        public static final int posProtocol = 2;
        public static final int posD = 3;
        public static final int posS = 4;
        public static final int posF = 5;
        public static final int posT = 6;
        public static final int posMiscParameters = 7;
        public static final int posVerified = 8;
        public static final int posName = 9;
        public static final int posComment = 10;
        public static final int posParameterIrSignal = columnNames.length - 1;

        ParameterIrSignalColumns() {
            super(columnNames, widths, classes, 1);
        }

        @Override
        public int getPosName() {
            return 9;
        }

        @Override
        public int getPosComment() {
            return 10;
        }

        @Override
        public int getPosDate() {
            return 1;
        }

        @Override
        public int getPosNumber() {
            return 0;
        }

        @Override
        public int getPosIrSignal() {
            return posParameterIrSignal;
        }

        @Override
        public boolean isEditable(int i) {
            return i != 0 && i != 1;
        }

        @Override
        public Object[] toObjectArray(NamedIrSignal signal) {
            if (!ParametrizedIrSignal.class.isInstance(signal)) {
                throw new IllegalArgumentException();
            }
            return this.toObjectArray((ParametrizedIrSignal)signal);
        }

        public Object[] toObjectArray(ParametrizedIrSignal signal) {
            return new Object[]{signal.getNumeral(), signal.getDate(), signal.protocolName, this.safeGet(signal.parameters, "D"), this.safeGet(signal.parameters, "S"), this.safeGet(signal.parameters, "F"), this.safeGet(signal.parameters, "T"), ParametrizedIrSignal.formatMiscParams(signal.parameters), signal.getValidated(), signal.getName(), signal.getComment(), signal};
        }

        private Integer safeGet(HashMap<String, Long> map, String key) {
            return map == null ? null : (map.get(key) == null ? null : Integer.valueOf(map.get(key).intValue()));
        }
    }
}

