/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public final class Props {
    private static final boolean useXml = true;
    private Properties props;
    private String filename;
    private String applicationHome;
    private boolean needSave;
    private boolean wasReset = false;
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private HashMap<String, ArrayList<IPropertyChangeListener>> changeListeners;

    private String ifWindows(String windows, String nonWindows) {
        return this.isWindows ? windows : nonWindows;
    }

    private void update(String key, String value) {
        if (!this.props.containsKey(key) && value != null) {
            this.props.setProperty(key, value);
            this.needSave = true;
        }
        this.changeListeners.put(key, new ArrayList());
    }

    public boolean getWasReset() {
        return this.wasReset;
    }

    private void setupDefaults() {
        this.update("bounds", null);
        this.update("outputFormatIndex", "1");
        this.update("irWidgetCapturePortName", this.ifWindows("COM8", "/dev/ttyUSB0"));
        this.update("globalCacheCaptureIpName", "");
        this.update("lircMode2Command", "mode2 -H serial");
        this.update("arduinoPortName", this.ifWindows("COM14", "/dev/ttyACM0"));
        this.update("arduinoPortBaudRate", "9600");
        this.update("arduinoCapturePortName", this.ifWindows("COM14", "/dev/ttyACM0"));
        this.update("arduinoCapturePortBaudRate", "9600");
        this.update("commandFusionPortName", this.ifWindows("COM14", "/dev/ttyUSB0"));
        this.update("commandFusionPortBaudRate", "9600");
        this.update("commandFusionCapturePortName", this.ifWindows("COM14", "/dev/ttyACM0"));
        this.update("commandFusionCapturePortBaudRate", "9600");
        this.update("girsClientSerialPortName", this.ifWindows("COM14", "/dev/ttyACM0"));
        this.update("girsClientSerialPortBaudRate", "115200");
        this.update("girsClientIPName", "arduino");
        this.update("girsClientPortNumber", "33333");
        this.update("girsClientType", "tcp");
        this.update("irToyPortName", this.ifWindows("COM13", "/dev/ttyACM0"));
        this.update("irToyPortBaudRate", "9600");
        this.update("irToyCapturePortName", this.ifWindows("COM13", "/dev/ttyACM0"));
        this.update("irToyCapturePortBaudRate", "9600");
        this.update("devLircName", "/dev/lirc0");
        this.update("devLircCaptureName", "/dev/lirc0");
        this.update("captureDevice", "LIRC Mode 2");
        this.update("sorterOnParametrizedTable", "false");
        this.update("sorterOnRawTable", "false");
        this.update("selectedMainPaneIndex", "0");
        this.update("selectedRemoteIndex", "0");
        this.update("captureBeginTimeout", "3000");
        this.update("captureMaxSize", "1000");
        this.update("captureEndTimeout", "300");
        this.update("sendingTimeout", "2000");
        this.update("transmitGeneratedCount", "1");
        this.update("fallbackFrequency", "38000");
        this.update("analyzerBase", "16");
        this.update("ignoreEndingSilence", "false");
        this.update("verbose", "false");
        this.update("invokeRepeatFinder", "true");
        this.update("invokeCleaner", "true");
        this.update("disregardRepeatMins", "false");
        this.update("exportDir", System.getProperty("java.io.tmpdir") + File.separator + "exports");
        this.update("defaultImportDir", "testfiles");
        this.update("exportFormatFilePath", "exportformats.xml");
        this.update("exportFormatName", "Girr");
        this.update("globalCacheIpName", "");
        this.update("globalCacheModule", "2");
        this.update("globalCachePort", "1");
        this.update("globalCacheTimeout", "3000");
        this.update("genericSerialPortDeviceName", this.ifWindows("COM2", "/dev/ttyS0"));
        this.update("helpfilePath", "doc" + File.separator + "IrScrutinizer.html");
        this.update("irpMasterHelpfilePath", "doc" + File.separator + "IrpMaster.html");
        this.update("releaseNotesPath", "doc" + File.separator + "IrScrutinizer.releasenotes.txt");
        this.update("tutorialUrl", "http://www.hifi-remote.com/wiki/index.php?title=IrScrutinizer_Guide");
        this.update("irTransIpName", "192.168.0.32");
        this.update("transmitHardware", "Audio Port");
        this.update("lircIpName", "127.0.0.1");
        this.update("lircPort", Integer.toString(8765));
        this.update("lircTimeout", "5000");
        this.update("lookAndFeel", "0");
        this.update("globalCacheApiKey", "");
        this.update("usePopupsForErrors", "true");
        this.update("usePopupsForHelp", "true");
        this.update("offerStackTrace", "false");
        this.update("printDecodesToConsole", "false");
        this.update("invokeDecodeIr", "true");
        this.update("generateRaw", "false");
        this.update("generateCcf", "false");
        this.update("exportGenerateRaw", "false");
        this.update("exportGenerateCcf", "true");
        this.update("exportGenerateShortCcf", "false");
        this.update("exportGenerateUei", "false");
        this.update("exportGenerateParameters", "false");
        this.update("exportGenerateSendIr", "false");
        this.update("exportSendIrModule", "1");
        this.update("exportSendIrConnector", "1");
        this.update("exportSendIrCompressed", "false");
        this.update("exportNoRepeats", "1");
        this.update("exportInquireDeviceData", "true");
        this.update("exportCharsetName", "WINDOWS-1252");
        this.update("importCharsetName", "WINDOWS-1252");
        this.update("translateProntoFont", "true");
        this.update("protocolsIniPath", "protocols.ini");
        this.update("irpProtocolsIniPath", "IrpProtocols.ini");
        this.update("creatingUser", System.getProperty("user.name", "unknown"));
        this.update("rawSeparatorIndex", "0");
        this.update("rawNameColumn", "1");
        this.update("rawNameMultiColumn", "false");
        this.update("parametrizedNameMultiColumn", "false");
        this.update("codeColumn", "2");
        this.update("includeTail", "false");
        this.update("parametrizedLearnIgnoreT", "false");
        this.update("parametricNameColumn", "1");
        this.update("protocolColumn", "2");
        this.update("dColumn", "3");
        this.update("sColumn", "4");
        this.update("fColumn", "5");
        this.update("parametricNumberBaseIndex", "2");
        this.update("parametricSeparatorIndex", "0");
        this.update("girrSchemaLocation", "http://www.harctoolbox.org/schemas/girr.xsd");
        this.update("girrValidate", "false");
        this.update("irpMasterCurrentProtocol", "nec1");
        this.update("irpMasterCurrentD", "0");
        this.update("irpMasterCurrentS", "-1");
        this.update("irpMasterCurrentF", "0");
        this.update("irpMasterCurrentT", "-");
        this.update("irpMasterCurrentAdditionalParameters", "");
        this.update("exportAutomaticFilenames", "true");
        this.update("invokeAnalyzer", "false");
        this.update("girrFatRaw", "false");
        this.update("girrCreateSchemaLocation", "true");
        this.update("girrStyleSheetUrl", "simplehtml.xsl");
        this.update("girrStyleSheetType", "xsl");
        this.update("importWaveDivideCarrier", "true");
        this.update("importOpensZipFiles", "false");
        this.update("importPaneSelectedIndex", "2");
        this.update("rejectLircCodeImports", "true");
        this.update("prontoModelIndex", "4");
        this.update("prontoScreenSizeX", "240");
        this.update("prontoScreenSizeY", "220");
        this.update("prontoButtonSizeX", "80");
        this.update("prontoButtonSizeY", "30");
        this.update("absoluteTolerance", Double.toString(60.0));
        this.update("relativeTolerance", Double.toString(0.2));
        this.update("dontInquire4UnsavedParametricRemotes", "false");
        this.update("dontInquire4UnsavedRawRemotes", "false");
    }

    public void reset() {
        this.props = new Properties();
        this.changeListeners = new HashMap();
        this.setupDefaults();
        this.needSave = true;
        this.wasReset = true;
    }

    public String getFilename() {
        return this.filename;
    }

    private String mkPathRelative(String path) {
        return path.replace(this.applicationHome, "");
    }

    public String mkPathAbsolute(String path) {
        return new File(path).isAbsolute() ? path : new File(new File(this.applicationHome), path).getAbsolutePath();
    }

    public Props(String applicationHome) {
        this(null, applicationHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Props(String filename, String applicationHome) {
        this.applicationHome = applicationHome;
        this.changeListeners = new HashMap();
        this.filename = filename;
        if (filename == null || filename.isEmpty()) {
            if (this.isWindows) {
                boolean status;
                String dir = System.getenv("LOCALAPPDATA");
                if (dir == null) {
                    dir = System.getenv("APPDATA");
                }
                if (dir != null && !new File(dir = dir + File.separator + "IrScrutinizer").isDirectory() && !(status = new File(dir).mkdirs())) {
                    System.err.println("Cannot create directory " + dir + ", using home directory instead.");
                }
                this.filename = dir != null ? dir + File.separator + "IrScrutinizer" + ".properties.xml" : System.getProperty("user.home") + File.separator + "." + "IrScrutinizer" + ".properties.xml";
            } else {
                boolean status;
                File baseFile;
                String base = System.getenv("XDG_CONFIG_HOME");
                if (base == null || base.isEmpty() || !new File(base).isAbsolute()) {
                    base = System.getProperty("user.home") + File.separator + ".config";
                }
                if (!(baseFile = new File(base + File.separator + "IrScrutinizer")).exists() && !(status = baseFile.mkdirs())) {
                    System.err.println("Could not create directory " + baseFile.getAbsolutePath() + ", saving properites in home direcory");
                    baseFile = new File(System.getProperty("user.home"));
                }
                this.filename = baseFile.getAbsolutePath() + File.separator + "properties.xml";
            }
        }
        this.needSave = false;
        this.props = new Properties();
        FileInputStream f = null;
        try {
            f = new FileInputStream(this.filename);
            this.props.loadFromXML(f);
        }
        catch (FileNotFoundException ex) {
            System.err.println("Property File " + this.filename + " not found, using builtin defaults.");
            this.setupDefaults();
            this.needSave = true;
        }
        catch (IOException ex) {
            System.err.println("Property File " + this.filename + " could not be read, using builtin defaults.");
            this.setupDefaults();
            this.needSave = true;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
        this.setupDefaults();
    }

    public boolean save(File filename) throws IOException {
        if (!this.needSave && filename.getAbsolutePath().equals(new File(this.filename).getAbsolutePath())) {
            return false;
        }
        boolean success = false;
        FileOutputStream f = new FileOutputStream(filename);
        try {
            this.props.storeToXML(f, "IrScrutinizer properties, feel free to hand edit if desired");
            success = true;
            this.needSave = false;
        }
        catch (IOException ex) {
            try {
                f.close();
            }
            catch (IOException exx) {
                System.err.println(exx.getMessage());
            }
            throw ex;
        }
        f.close();
        return success;
    }

    public String save() throws IOException {
        boolean result = this.save(new File(this.filename));
        return result ? this.filename : null;
    }

    private void list() {
        this.props.list(System.err);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        ArrayList<IPropertyChangeListener> presentListeners = this.changeListeners.get(propertyName);
        for (IPropertyChangeListener listener : presentListeners) {
            listener.propertyChange(propertyName, oldValue, newValue);
        }
    }

    private void addPropertyChangeListener(String propertyName, IPropertyChangeListener listener) {
        ArrayList<IPropertyChangeListener> presentListeners = this.changeListeners.get(propertyName);
        if (!presentListeners.contains(listener)) {
            presentListeners.add(listener);
        }
    }

    private void removePropertyChangeListener(String propertyName, IPropertyChangeListener listener) {
        ArrayList<IPropertyChangeListener> presentListeners = this.changeListeners.get(propertyName);
        if (presentListeners.contains(listener)) {
            presentListeners.remove(listener);
        }
    }

    public Rectangle getBounds() {
        String str = this.props.getProperty("bounds");
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] arr = str.trim().split(" +");
        return new Rectangle(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), Integer.parseInt(arr[2]), Integer.parseInt(arr[3]));
    }

    public void setBounds(Rectangle bounds) {
        String oldValue = this.props.getProperty("bounds");
        if (bounds == null) {
            return;
        }
        String newValue = String.format("%d %d %d %d", bounds.x, bounds.y, bounds.width, bounds.height);
        if (!newValue.equals(oldValue)) {
            this.props.setProperty("bounds", newValue);
            this.needSave = true;
            this.firePropertyChange("bounds", oldValue, newValue);
        }
    }

    public void addBoundsChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("bounds", listener);
    }

    public void removeBoundsChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("bounds", listener);
    }

    public int getOutputFormatIndex() {
        return Integer.parseInt(this.props.getProperty("outputFormatIndex"));
    }

    public void setOutputFormatIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("outputFormatIndex"));
        if (oldValue != n) {
            this.props.setProperty("outputFormatIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("outputFormatIndex", oldValue, n);
        }
    }

    public void addOutputFormatIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("outputFormatIndex", listener);
    }

    public void removeOutputFormatIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("outputFormatIndex", listener);
    }

    public String getIrWidgetCapturePortName() {
        return this.props.getProperty("irWidgetCapturePortName");
    }

    public void setIrWidgetCapturePortName(String str) {
        String oldValue = this.props.getProperty("irWidgetCapturePortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irWidgetCapturePortName", this.mkPathRelative(str));
            this.firePropertyChange("irWidgetCapturePortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrWidgetCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irWidgetCapturePortName", listener);
    }

    public void removeIrWidgetCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irWidgetCapturePortName", listener);
    }

    public String getGlobalCacheCaptureIpName() {
        return this.props.getProperty("globalCacheCaptureIpName");
    }

    public void setGlobalCacheCaptureIpName(String str) {
        String oldValue = this.props.getProperty("globalCacheCaptureIpName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("globalCacheCaptureIpName", this.mkPathRelative(str));
            this.firePropertyChange("globalCacheCaptureIpName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGlobalCacheCaptureIpNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCacheCaptureIpName", listener);
    }

    public void removeGlobalCacheCaptureIpNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCacheCaptureIpName", listener);
    }

    public String getLircMode2Command() {
        return this.props.getProperty("lircMode2Command");
    }

    public void setLircMode2Command(String str) {
        String oldValue = this.props.getProperty("lircMode2Command");
        if (!oldValue.equals(str)) {
            this.props.setProperty("lircMode2Command", this.mkPathRelative(str));
            this.firePropertyChange("lircMode2Command", oldValue, str);
            this.needSave = true;
        }
    }

    public void addLircMode2CommandChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("lircMode2Command", listener);
    }

    public void removeLircMode2CommandChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("lircMode2Command", listener);
    }

    public String getArduinoPortName() {
        return this.props.getProperty("arduinoPortName");
    }

    public void setArduinoPortName(String str) {
        String oldValue = this.props.getProperty("arduinoPortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("arduinoPortName", this.mkPathRelative(str));
            this.firePropertyChange("arduinoPortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addArduinoPortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("arduinoPortName", listener);
    }

    public void removeArduinoPortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("arduinoPortName", listener);
    }

    public int getArduinoPortBaudRate() {
        return Integer.parseInt(this.props.getProperty("arduinoPortBaudRate"));
    }

    public void setArduinoPortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("arduinoPortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("arduinoPortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("arduinoPortBaudRate", oldValue, n);
        }
    }

    public void addArduinoPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("arduinoPortBaudRate", listener);
    }

    public void removeArduinoPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("arduinoPortBaudRate", listener);
    }

    public String getArduinoCapturePortName() {
        return this.props.getProperty("arduinoCapturePortName");
    }

    public void setArduinoCapturePortName(String str) {
        String oldValue = this.props.getProperty("arduinoCapturePortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("arduinoCapturePortName", this.mkPathRelative(str));
            this.firePropertyChange("arduinoCapturePortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addArduinoCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("arduinoCapturePortName", listener);
    }

    public void removeArduinoCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("arduinoCapturePortName", listener);
    }

    public int getArduinoCapturePortBaudRate() {
        return Integer.parseInt(this.props.getProperty("arduinoCapturePortBaudRate"));
    }

    public void setArduinoCapturePortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("arduinoCapturePortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("arduinoCapturePortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("arduinoCapturePortBaudRate", oldValue, n);
        }
    }

    public void addArduinoCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("arduinoCapturePortBaudRate", listener);
    }

    public void removeArduinoCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("arduinoCapturePortBaudRate", listener);
    }

    public String getCommandFusionPortName() {
        return this.props.getProperty("commandFusionPortName");
    }

    public void setCommandFusionPortName(String str) {
        String oldValue = this.props.getProperty("commandFusionPortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("commandFusionPortName", this.mkPathRelative(str));
            this.firePropertyChange("commandFusionPortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addCommandFusionPortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("commandFusionPortName", listener);
    }

    public void removeCommandFusionPortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("commandFusionPortName", listener);
    }

    public int getCommandFusionPortBaudRate() {
        return Integer.parseInt(this.props.getProperty("commandFusionPortBaudRate"));
    }

    public void setCommandFusionPortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("commandFusionPortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("commandFusionPortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("commandFusionPortBaudRate", oldValue, n);
        }
    }

    public void addCommandFusionPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("commandFusionPortBaudRate", listener);
    }

    public void removeCommandFusionPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("commandFusionPortBaudRate", listener);
    }

    public String getCommandFusionCapturePortName() {
        return this.props.getProperty("commandFusionCapturePortName");
    }

    public void setCommandFusionCapturePortName(String str) {
        String oldValue = this.props.getProperty("commandFusionCapturePortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("commandFusionCapturePortName", this.mkPathRelative(str));
            this.firePropertyChange("commandFusionCapturePortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addCommandFusionCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("commandFusionCapturePortName", listener);
    }

    public void removeCommandFusionCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("commandFusionCapturePortName", listener);
    }

    public int getCommandFusionCapturePortBaudRate() {
        return Integer.parseInt(this.props.getProperty("commandFusionCapturePortBaudRate"));
    }

    public void setCommandFusionCapturePortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("commandFusionCapturePortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("commandFusionCapturePortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("commandFusionCapturePortBaudRate", oldValue, n);
        }
    }

    public void addCommandFusionCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("commandFusionCapturePortBaudRate", listener);
    }

    public void removeCommandFusionCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("commandFusionCapturePortBaudRate", listener);
    }

    public String getGirsClientSerialPortName() {
        return this.props.getProperty("girsClientSerialPortName");
    }

    public void setGirsClientSerialPortName(String str) {
        String oldValue = this.props.getProperty("girsClientSerialPortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girsClientSerialPortName", this.mkPathRelative(str));
            this.firePropertyChange("girsClientSerialPortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirsClientSerialPortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girsClientSerialPortName", listener);
    }

    public void removeGirsClientSerialPortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girsClientSerialPortName", listener);
    }

    public int getGirsClientSerialPortBaudRate() {
        return Integer.parseInt(this.props.getProperty("girsClientSerialPortBaudRate"));
    }

    public void setGirsClientSerialPortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("girsClientSerialPortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("girsClientSerialPortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("girsClientSerialPortBaudRate", oldValue, n);
        }
    }

    public void addGirsClientSerialPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girsClientSerialPortBaudRate", listener);
    }

    public void removeGirsClientSerialPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girsClientSerialPortBaudRate", listener);
    }

    public String getGirsClientIPName() {
        return this.props.getProperty("girsClientIPName");
    }

    public void setGirsClientIPName(String str) {
        String oldValue = this.props.getProperty("girsClientIPName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girsClientIPName", this.mkPathRelative(str));
            this.firePropertyChange("girsClientIPName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirsClientIPNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girsClientIPName", listener);
    }

    public void removeGirsClientIPNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girsClientIPName", listener);
    }

    public int getGirsClientPortNumber() {
        return Integer.parseInt(this.props.getProperty("girsClientPortNumber"));
    }

    public void setGirsClientPortNumber(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("girsClientPortNumber"));
        if (oldValue != n) {
            this.props.setProperty("girsClientPortNumber", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("girsClientPortNumber", oldValue, n);
        }
    }

    public void addGirsClientPortNumberChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girsClientPortNumber", listener);
    }

    public void removeGirsClientPortNumberChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girsClientPortNumber", listener);
    }

    public String getGirsClientType() {
        return this.props.getProperty("girsClientType");
    }

    public void setGirsClientType(String str) {
        String oldValue = this.props.getProperty("girsClientType");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girsClientType", this.mkPathRelative(str));
            this.firePropertyChange("girsClientType", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirsClientTypeChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girsClientType", listener);
    }

    public void removeGirsClientTypeChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girsClientType", listener);
    }

    public String getIrToyPortName() {
        return this.props.getProperty("irToyPortName");
    }

    public void setIrToyPortName(String str) {
        String oldValue = this.props.getProperty("irToyPortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irToyPortName", this.mkPathRelative(str));
            this.firePropertyChange("irToyPortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrToyPortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irToyPortName", listener);
    }

    public void removeIrToyPortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irToyPortName", listener);
    }

    public int getIrToyPortBaudRate() {
        return Integer.parseInt(this.props.getProperty("irToyPortBaudRate"));
    }

    public void setIrToyPortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("irToyPortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("irToyPortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("irToyPortBaudRate", oldValue, n);
        }
    }

    public void addIrToyPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irToyPortBaudRate", listener);
    }

    public void removeIrToyPortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irToyPortBaudRate", listener);
    }

    public String getIrToyCapturePortName() {
        return this.props.getProperty("irToyCapturePortName");
    }

    public void setIrToyCapturePortName(String str) {
        String oldValue = this.props.getProperty("irToyCapturePortName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irToyCapturePortName", this.mkPathRelative(str));
            this.firePropertyChange("irToyCapturePortName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrToyCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irToyCapturePortName", listener);
    }

    public void removeIrToyCapturePortNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irToyCapturePortName", listener);
    }

    public int getIrToyCapturePortBaudRate() {
        return Integer.parseInt(this.props.getProperty("irToyCapturePortBaudRate"));
    }

    public void setIrToyCapturePortBaudRate(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("irToyCapturePortBaudRate"));
        if (oldValue != n) {
            this.props.setProperty("irToyCapturePortBaudRate", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("irToyCapturePortBaudRate", oldValue, n);
        }
    }

    public void addIrToyCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irToyCapturePortBaudRate", listener);
    }

    public void removeIrToyCapturePortBaudRateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irToyCapturePortBaudRate", listener);
    }

    public String getDevLircName() {
        return this.props.getProperty("devLircName");
    }

    public void setDevLircName(String str) {
        String oldValue = this.props.getProperty("devLircName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("devLircName", this.mkPathRelative(str));
            this.firePropertyChange("devLircName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addDevLircNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("devLircName", listener);
    }

    public void removeDevLircNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("devLircName", listener);
    }

    public String getDevLircCaptureName() {
        return this.props.getProperty("devLircCaptureName");
    }

    public void setDevLircCaptureName(String str) {
        String oldValue = this.props.getProperty("devLircCaptureName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("devLircCaptureName", this.mkPathRelative(str));
            this.firePropertyChange("devLircCaptureName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addDevLircCaptureNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("devLircCaptureName", listener);
    }

    public void removeDevLircCaptureNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("devLircCaptureName", listener);
    }

    public String getCaptureDevice() {
        return this.props.getProperty("captureDevice");
    }

    public void setCaptureDevice(String str) {
        String oldValue = this.props.getProperty("captureDevice");
        if (!oldValue.equals(str)) {
            this.props.setProperty("captureDevice", this.mkPathRelative(str));
            this.firePropertyChange("captureDevice", oldValue, str);
            this.needSave = true;
        }
    }

    public void addCaptureDeviceChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("captureDevice", listener);
    }

    public void removeCaptureDeviceChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("captureDevice", listener);
    }

    public boolean getSorterOnParametrizedTable() {
        return Boolean.parseBoolean(this.props.getProperty("sorterOnParametrizedTable"));
    }

    public void setSorterOnParametrizedTable(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("sorterOnParametrizedTable"));
        if (oldValue != val) {
            this.props.setProperty("sorterOnParametrizedTable", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("sorterOnParametrizedTable", oldValue, val);
        }
    }

    public void addSorterOnParametrizedTableChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("sorterOnParametrizedTable", listener);
    }

    public void removeSorterOnParametrizedTableChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("sorterOnParametrizedTable", listener);
    }

    public boolean getSorterOnRawTable() {
        return Boolean.parseBoolean(this.props.getProperty("sorterOnRawTable"));
    }

    public void setSorterOnRawTable(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("sorterOnRawTable"));
        if (oldValue != val) {
            this.props.setProperty("sorterOnRawTable", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("sorterOnRawTable", oldValue, val);
        }
    }

    public void addSorterOnRawTableChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("sorterOnRawTable", listener);
    }

    public void removeSorterOnRawTableChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("sorterOnRawTable", listener);
    }

    public int getSelectedMainPaneIndex() {
        return Integer.parseInt(this.props.getProperty("selectedMainPaneIndex"));
    }

    public void setSelectedMainPaneIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("selectedMainPaneIndex"));
        if (oldValue != n) {
            this.props.setProperty("selectedMainPaneIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("selectedMainPaneIndex", oldValue, n);
        }
    }

    public void addSelectedMainPaneIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("selectedMainPaneIndex", listener);
    }

    public void removeSelectedMainPaneIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("selectedMainPaneIndex", listener);
    }

    public int getSelectedRemoteIndex() {
        return Integer.parseInt(this.props.getProperty("selectedRemoteIndex"));
    }

    public void setSelectedRemoteIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("selectedRemoteIndex"));
        if (oldValue != n) {
            this.props.setProperty("selectedRemoteIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("selectedRemoteIndex", oldValue, n);
        }
    }

    public void addSelectedRemoteIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("selectedRemoteIndex", listener);
    }

    public void removeSelectedRemoteIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("selectedRemoteIndex", listener);
    }

    public int getCaptureBeginTimeout() {
        return Integer.parseInt(this.props.getProperty("captureBeginTimeout"));
    }

    public void setCaptureBeginTimeout(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("captureBeginTimeout"));
        if (oldValue != n) {
            this.props.setProperty("captureBeginTimeout", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("captureBeginTimeout", oldValue, n);
        }
    }

    public void addCaptureBeginTimeoutChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("captureBeginTimeout", listener);
    }

    public void removeCaptureBeginTimeoutChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("captureBeginTimeout", listener);
    }

    public int getCaptureMaxSize() {
        return Integer.parseInt(this.props.getProperty("captureMaxSize"));
    }

    public void setCaptureMaxSize(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("captureMaxSize"));
        if (oldValue != n) {
            this.props.setProperty("captureMaxSize", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("captureMaxSize", oldValue, n);
        }
    }

    public void addCaptureMaxSizeChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("captureMaxSize", listener);
    }

    public void removeCaptureMaxSizeChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("captureMaxSize", listener);
    }

    public int getCaptureEndTimeout() {
        return Integer.parseInt(this.props.getProperty("captureEndTimeout"));
    }

    public void setCaptureEndTimeout(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("captureEndTimeout"));
        if (oldValue != n) {
            this.props.setProperty("captureEndTimeout", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("captureEndTimeout", oldValue, n);
        }
    }

    public void addCaptureEndTimeoutChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("captureEndTimeout", listener);
    }

    public void removeCaptureEndTimeoutChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("captureEndTimeout", listener);
    }

    public int getSendingTimeout() {
        return Integer.parseInt(this.props.getProperty("sendingTimeout"));
    }

    public void setSendingTimeout(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("sendingTimeout"));
        if (oldValue != n) {
            this.props.setProperty("sendingTimeout", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("sendingTimeout", oldValue, n);
        }
    }

    public void addSendingTimeoutChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("sendingTimeout", listener);
    }

    public void removeSendingTimeoutChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("sendingTimeout", listener);
    }

    public int getTransmitGeneratedCount() {
        return Integer.parseInt(this.props.getProperty("transmitGeneratedCount"));
    }

    public void setTransmitGeneratedCount(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("transmitGeneratedCount"));
        if (oldValue != n) {
            this.props.setProperty("transmitGeneratedCount", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("transmitGeneratedCount", oldValue, n);
        }
    }

    public void addTransmitGeneratedCountChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("transmitGeneratedCount", listener);
    }

    public void removeTransmitGeneratedCountChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("transmitGeneratedCount", listener);
    }

    public int getFallbackFrequency() {
        return Integer.parseInt(this.props.getProperty("fallbackFrequency"));
    }

    public void setFallbackFrequency(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("fallbackFrequency"));
        if (oldValue != n) {
            this.props.setProperty("fallbackFrequency", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("fallbackFrequency", oldValue, n);
        }
    }

    public void addFallbackFrequencyChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("fallbackFrequency", listener);
    }

    public void removeFallbackFrequencyChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("fallbackFrequency", listener);
    }

    public int getAnalyzerBase() {
        return Integer.parseInt(this.props.getProperty("analyzerBase"));
    }

    public void setAnalyzerBase(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("analyzerBase"));
        if (oldValue != n) {
            this.props.setProperty("analyzerBase", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("analyzerBase", oldValue, n);
        }
    }

    public void addAnalyzerBaseChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("analyzerBase", listener);
    }

    public void removeAnalyzerBaseChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("analyzerBase", listener);
    }

    public boolean getIgnoreEndingSilence() {
        return Boolean.parseBoolean(this.props.getProperty("ignoreEndingSilence"));
    }

    public void setIgnoreEndingSilence(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("ignoreEndingSilence"));
        if (oldValue != val) {
            this.props.setProperty("ignoreEndingSilence", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("ignoreEndingSilence", oldValue, val);
        }
    }

    public void addIgnoreEndingSilenceChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("ignoreEndingSilence", listener);
    }

    public void removeIgnoreEndingSilenceChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("ignoreEndingSilence", listener);
    }

    public boolean getVerbose() {
        return Boolean.parseBoolean(this.props.getProperty("verbose"));
    }

    public void setVerbose(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("verbose"));
        if (oldValue != val) {
            this.props.setProperty("verbose", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("verbose", oldValue, val);
        }
    }

    public void addVerboseChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("verbose", listener);
    }

    public void removeVerboseChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("verbose", listener);
    }

    public boolean getInvokeRepeatFinder() {
        return Boolean.parseBoolean(this.props.getProperty("invokeRepeatFinder"));
    }

    public void setInvokeRepeatFinder(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("invokeRepeatFinder"));
        if (oldValue != val) {
            this.props.setProperty("invokeRepeatFinder", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("invokeRepeatFinder", oldValue, val);
        }
    }

    public void addInvokeRepeatFinderChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("invokeRepeatFinder", listener);
    }

    public void removeInvokeRepeatFinderChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("invokeRepeatFinder", listener);
    }

    public boolean getInvokeCleaner() {
        return Boolean.parseBoolean(this.props.getProperty("invokeCleaner"));
    }

    public void setInvokeCleaner(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("invokeCleaner"));
        if (oldValue != val) {
            this.props.setProperty("invokeCleaner", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("invokeCleaner", oldValue, val);
        }
    }

    public void addInvokeCleanerChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("invokeCleaner", listener);
    }

    public void removeInvokeCleanerChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("invokeCleaner", listener);
    }

    public boolean getDisregardRepeatMins() {
        return Boolean.parseBoolean(this.props.getProperty("disregardRepeatMins"));
    }

    public void setDisregardRepeatMins(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("disregardRepeatMins"));
        if (oldValue != val) {
            this.props.setProperty("disregardRepeatMins", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("disregardRepeatMins", oldValue, val);
        }
    }

    public void addDisregardRepeatMinsChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("disregardRepeatMins", listener);
    }

    public void removeDisregardRepeatMinsChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("disregardRepeatMins", listener);
    }

    public String getExportDir() {
        return this.props.getProperty("exportDir");
    }

    public void setExportDir(String str) {
        String oldValue = this.props.getProperty("exportDir");
        if (!oldValue.equals(str)) {
            this.props.setProperty("exportDir", this.mkPathRelative(str));
            this.firePropertyChange("exportDir", oldValue, str);
            this.needSave = true;
        }
    }

    public void addExportDirChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportDir", listener);
    }

    public void removeExportDirChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportDir", listener);
    }

    public String getDefaultImportDir() {
        return this.props.getProperty("defaultImportDir");
    }

    public void setDefaultImportDir(String str) {
        String oldValue = this.props.getProperty("defaultImportDir");
        if (!oldValue.equals(str)) {
            this.props.setProperty("defaultImportDir", this.mkPathRelative(str));
            this.firePropertyChange("defaultImportDir", oldValue, str);
            this.needSave = true;
        }
    }

    public void addDefaultImportDirChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("defaultImportDir", listener);
    }

    public void removeDefaultImportDirChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("defaultImportDir", listener);
    }

    public String getExportFormatFilePath() {
        return this.props.getProperty("exportFormatFilePath");
    }

    public void setExportFormatFilePath(String str) {
        String oldValue = this.props.getProperty("exportFormatFilePath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("exportFormatFilePath", this.mkPathRelative(str));
            this.firePropertyChange("exportFormatFilePath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addExportFormatFilePathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportFormatFilePath", listener);
    }

    public void removeExportFormatFilePathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportFormatFilePath", listener);
    }

    public String getExportFormatName() {
        return this.props.getProperty("exportFormatName");
    }

    public void setExportFormatName(String str) {
        String oldValue = this.props.getProperty("exportFormatName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("exportFormatName", this.mkPathRelative(str));
            this.firePropertyChange("exportFormatName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addExportFormatNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportFormatName", listener);
    }

    public void removeExportFormatNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportFormatName", listener);
    }

    public String getGlobalCacheIpName() {
        return this.props.getProperty("globalCacheIpName");
    }

    public void setGlobalCacheIpName(String str) {
        String oldValue = this.props.getProperty("globalCacheIpName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("globalCacheIpName", this.mkPathRelative(str));
            this.firePropertyChange("globalCacheIpName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGlobalCacheIpNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCacheIpName", listener);
    }

    public void removeGlobalCacheIpNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCacheIpName", listener);
    }

    public int getGlobalCacheModule() {
        return Integer.parseInt(this.props.getProperty("globalCacheModule"));
    }

    public void setGlobalCacheModule(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("globalCacheModule"));
        if (oldValue != n) {
            this.props.setProperty("globalCacheModule", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("globalCacheModule", oldValue, n);
        }
    }

    public void addGlobalCacheModuleChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCacheModule", listener);
    }

    public void removeGlobalCacheModuleChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCacheModule", listener);
    }

    public int getGlobalCachePort() {
        return Integer.parseInt(this.props.getProperty("globalCachePort"));
    }

    public void setGlobalCachePort(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("globalCachePort"));
        if (oldValue != n) {
            this.props.setProperty("globalCachePort", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("globalCachePort", oldValue, n);
        }
    }

    public void addGlobalCachePortChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCachePort", listener);
    }

    public void removeGlobalCachePortChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCachePort", listener);
    }

    public int getGlobalCacheTimeout() {
        return Integer.parseInt(this.props.getProperty("globalCacheTimeout"));
    }

    public void setGlobalCacheTimeout(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("globalCacheTimeout"));
        if (oldValue != n) {
            this.props.setProperty("globalCacheTimeout", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("globalCacheTimeout", oldValue, n);
        }
    }

    public void addGlobalCacheTimeoutChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCacheTimeout", listener);
    }

    public void removeGlobalCacheTimeoutChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCacheTimeout", listener);
    }

    public String getGenericSerialPortDeviceName() {
        return this.props.getProperty("genericSerialPortDeviceName");
    }

    public void setGenericSerialPortDeviceName(String str) {
        String oldValue = this.props.getProperty("genericSerialPortDeviceName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("genericSerialPortDeviceName", this.mkPathRelative(str));
            this.firePropertyChange("genericSerialPortDeviceName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGenericSerialPortDeviceNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("genericSerialPortDeviceName", listener);
    }

    public void removeGenericSerialPortDeviceNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("genericSerialPortDeviceName", listener);
    }

    public String getHelpfilePath() {
        return this.props.getProperty("helpfilePath");
    }

    public void setHelpfilePath(String str) {
        String oldValue = this.props.getProperty("helpfilePath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("helpfilePath", this.mkPathRelative(str));
            this.firePropertyChange("helpfilePath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addHelpfilePathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("helpfilePath", listener);
    }

    public void removeHelpfilePathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("helpfilePath", listener);
    }

    public String getIrpMasterHelpfilePath() {
        return this.props.getProperty("irpMasterHelpfilePath");
    }

    public void setIrpMasterHelpfilePath(String str) {
        String oldValue = this.props.getProperty("irpMasterHelpfilePath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterHelpfilePath", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterHelpfilePath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterHelpfilePathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterHelpfilePath", listener);
    }

    public void removeIrpMasterHelpfilePathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterHelpfilePath", listener);
    }

    public String getReleaseNotesPath() {
        return this.props.getProperty("releaseNotesPath");
    }

    public void setReleaseNotesPath(String str) {
        String oldValue = this.props.getProperty("releaseNotesPath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("releaseNotesPath", this.mkPathRelative(str));
            this.firePropertyChange("releaseNotesPath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addReleaseNotesPathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("releaseNotesPath", listener);
    }

    public void removeReleaseNotesPathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("releaseNotesPath", listener);
    }

    public String getTutorialUrl() {
        return this.props.getProperty("tutorialUrl");
    }

    public void setTutorialUrl(String str) {
        String oldValue = this.props.getProperty("tutorialUrl");
        if (!oldValue.equals(str)) {
            this.props.setProperty("tutorialUrl", this.mkPathRelative(str));
            this.firePropertyChange("tutorialUrl", oldValue, str);
            this.needSave = true;
        }
    }

    public void addTutorialUrlChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("tutorialUrl", listener);
    }

    public void removeTutorialUrlChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("tutorialUrl", listener);
    }

    public String getIrTransIpName() {
        return this.props.getProperty("irTransIpName");
    }

    public void setIrTransIpName(String str) {
        String oldValue = this.props.getProperty("irTransIpName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irTransIpName", this.mkPathRelative(str));
            this.firePropertyChange("irTransIpName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrTransIpNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irTransIpName", listener);
    }

    public void removeIrTransIpNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irTransIpName", listener);
    }

    public String getTransmitHardware() {
        return this.props.getProperty("transmitHardware");
    }

    public void setTransmitHardware(String str) {
        String oldValue = this.props.getProperty("transmitHardware");
        if (!oldValue.equals(str)) {
            this.props.setProperty("transmitHardware", this.mkPathRelative(str));
            this.firePropertyChange("transmitHardware", oldValue, str);
            this.needSave = true;
        }
    }

    public void addTransmitHardwareChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("transmitHardware", listener);
    }

    public void removeTransmitHardwareChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("transmitHardware", listener);
    }

    public String getLircIpName() {
        return this.props.getProperty("lircIpName");
    }

    public void setLircIpName(String str) {
        String oldValue = this.props.getProperty("lircIpName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("lircIpName", this.mkPathRelative(str));
            this.firePropertyChange("lircIpName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addLircIpNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("lircIpName", listener);
    }

    public void removeLircIpNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("lircIpName", listener);
    }

    public int getLircPort() {
        return Integer.parseInt(this.props.getProperty("lircPort"));
    }

    public void setLircPort(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("lircPort"));
        if (oldValue != n) {
            this.props.setProperty("lircPort", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("lircPort", oldValue, n);
        }
    }

    public void addLircPortChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("lircPort", listener);
    }

    public void removeLircPortChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("lircPort", listener);
    }

    public int getLircTimeout() {
        return Integer.parseInt(this.props.getProperty("lircTimeout"));
    }

    public void setLircTimeout(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("lircTimeout"));
        if (oldValue != n) {
            this.props.setProperty("lircTimeout", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("lircTimeout", oldValue, n);
        }
    }

    public void addLircTimeoutChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("lircTimeout", listener);
    }

    public void removeLircTimeoutChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("lircTimeout", listener);
    }

    public int getLookAndFeel() {
        return Integer.parseInt(this.props.getProperty("lookAndFeel"));
    }

    public void setLookAndFeel(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("lookAndFeel"));
        if (oldValue != n) {
            this.props.setProperty("lookAndFeel", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("lookAndFeel", oldValue, n);
        }
    }

    public void addLookAndFeelChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("lookAndFeel", listener);
    }

    public void removeLookAndFeelChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("lookAndFeel", listener);
    }

    public String getGlobalCacheApiKey() {
        return this.props.getProperty("globalCacheApiKey");
    }

    public void setGlobalCacheApiKey(String str) {
        String oldValue = this.props.getProperty("globalCacheApiKey");
        if (!oldValue.equals(str)) {
            this.props.setProperty("globalCacheApiKey", this.mkPathRelative(str));
            this.firePropertyChange("globalCacheApiKey", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGlobalCacheApiKeyChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("globalCacheApiKey", listener);
    }

    public void removeGlobalCacheApiKeyChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("globalCacheApiKey", listener);
    }

    public boolean getUsePopupsForErrors() {
        return Boolean.parseBoolean(this.props.getProperty("usePopupsForErrors"));
    }

    public void setUsePopupsForErrors(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("usePopupsForErrors"));
        if (oldValue != val) {
            this.props.setProperty("usePopupsForErrors", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("usePopupsForErrors", oldValue, val);
        }
    }

    public void addUsePopupsForErrorsChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("usePopupsForErrors", listener);
    }

    public void removeUsePopupsForErrorsChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("usePopupsForErrors", listener);
    }

    public boolean getUsePopupsForHelp() {
        return Boolean.parseBoolean(this.props.getProperty("usePopupsForHelp"));
    }

    public void setUsePopupsForHelp(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("usePopupsForHelp"));
        if (oldValue != val) {
            this.props.setProperty("usePopupsForHelp", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("usePopupsForHelp", oldValue, val);
        }
    }

    public void addUsePopupsForHelpChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("usePopupsForHelp", listener);
    }

    public void removeUsePopupsForHelpChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("usePopupsForHelp", listener);
    }

    public boolean getOfferStackTrace() {
        return Boolean.parseBoolean(this.props.getProperty("offerStackTrace"));
    }

    public void setOfferStackTrace(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("offerStackTrace"));
        if (oldValue != val) {
            this.props.setProperty("offerStackTrace", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("offerStackTrace", oldValue, val);
        }
    }

    public void addOfferStackTraceChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("offerStackTrace", listener);
    }

    public void removeOfferStackTraceChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("offerStackTrace", listener);
    }

    public boolean getPrintDecodesToConsole() {
        return Boolean.parseBoolean(this.props.getProperty("printDecodesToConsole"));
    }

    public void setPrintDecodesToConsole(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("printDecodesToConsole"));
        if (oldValue != val) {
            this.props.setProperty("printDecodesToConsole", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("printDecodesToConsole", oldValue, val);
        }
    }

    public void addPrintDecodesToConsoleChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("printDecodesToConsole", listener);
    }

    public void removePrintDecodesToConsoleChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("printDecodesToConsole", listener);
    }

    public boolean getInvokeDecodeIr() {
        return Boolean.parseBoolean(this.props.getProperty("invokeDecodeIr"));
    }

    public void setInvokeDecodeIr(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("invokeDecodeIr"));
        if (oldValue != val) {
            this.props.setProperty("invokeDecodeIr", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("invokeDecodeIr", oldValue, val);
        }
    }

    public void addInvokeDecodeIrChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("invokeDecodeIr", listener);
    }

    public void removeInvokeDecodeIrChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("invokeDecodeIr", listener);
    }

    public boolean getGenerateRaw() {
        return Boolean.parseBoolean(this.props.getProperty("generateRaw"));
    }

    public void setGenerateRaw(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("generateRaw"));
        if (oldValue != val) {
            this.props.setProperty("generateRaw", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("generateRaw", oldValue, val);
        }
    }

    public void addGenerateRawChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("generateRaw", listener);
    }

    public void removeGenerateRawChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("generateRaw", listener);
    }

    public boolean getGenerateCcf() {
        return Boolean.parseBoolean(this.props.getProperty("generateCcf"));
    }

    public void setGenerateCcf(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("generateCcf"));
        if (oldValue != val) {
            this.props.setProperty("generateCcf", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("generateCcf", oldValue, val);
        }
    }

    public void addGenerateCcfChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("generateCcf", listener);
    }

    public void removeGenerateCcfChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("generateCcf", listener);
    }

    public boolean getExportGenerateRaw() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateRaw"));
    }

    public void setExportGenerateRaw(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateRaw"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateRaw", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateRaw", oldValue, val);
        }
    }

    public void addExportGenerateRawChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateRaw", listener);
    }

    public void removeExportGenerateRawChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateRaw", listener);
    }

    public boolean getExportGenerateCcf() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateCcf"));
    }

    public void setExportGenerateCcf(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateCcf"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateCcf", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateCcf", oldValue, val);
        }
    }

    public void addExportGenerateCcfChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateCcf", listener);
    }

    public void removeExportGenerateCcfChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateCcf", listener);
    }

    public boolean getExportGenerateShortCcf() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateShortCcf"));
    }

    public void setExportGenerateShortCcf(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateShortCcf"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateShortCcf", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateShortCcf", oldValue, val);
        }
    }

    public void addExportGenerateShortCcfChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateShortCcf", listener);
    }

    public void removeExportGenerateShortCcfChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateShortCcf", listener);
    }

    public boolean getExportGenerateUei() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateUei"));
    }

    public void setExportGenerateUei(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateUei"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateUei", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateUei", oldValue, val);
        }
    }

    public void addExportGenerateUeiChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateUei", listener);
    }

    public void removeExportGenerateUeiChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateUei", listener);
    }

    public boolean getExportGenerateParameters() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateParameters"));
    }

    public void setExportGenerateParameters(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateParameters"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateParameters", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateParameters", oldValue, val);
        }
    }

    public void addExportGenerateParametersChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateParameters", listener);
    }

    public void removeExportGenerateParametersChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateParameters", listener);
    }

    public boolean getExportGenerateSendIr() {
        return Boolean.parseBoolean(this.props.getProperty("exportGenerateSendIr"));
    }

    public void setExportGenerateSendIr(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportGenerateSendIr"));
        if (oldValue != val) {
            this.props.setProperty("exportGenerateSendIr", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportGenerateSendIr", oldValue, val);
        }
    }

    public void addExportGenerateSendIrChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportGenerateSendIr", listener);
    }

    public void removeExportGenerateSendIrChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportGenerateSendIr", listener);
    }

    public int getExportSendIrModule() {
        return Integer.parseInt(this.props.getProperty("exportSendIrModule"));
    }

    public void setExportSendIrModule(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("exportSendIrModule"));
        if (oldValue != n) {
            this.props.setProperty("exportSendIrModule", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("exportSendIrModule", oldValue, n);
        }
    }

    public void addExportSendIrModuleChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportSendIrModule", listener);
    }

    public void removeExportSendIrModuleChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportSendIrModule", listener);
    }

    public int getExportSendIrConnector() {
        return Integer.parseInt(this.props.getProperty("exportSendIrConnector"));
    }

    public void setExportSendIrConnector(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("exportSendIrConnector"));
        if (oldValue != n) {
            this.props.setProperty("exportSendIrConnector", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("exportSendIrConnector", oldValue, n);
        }
    }

    public void addExportSendIrConnectorChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportSendIrConnector", listener);
    }

    public void removeExportSendIrConnectorChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportSendIrConnector", listener);
    }

    public boolean getExportSendIrCompressed() {
        return Boolean.parseBoolean(this.props.getProperty("exportSendIrCompressed"));
    }

    public void setExportSendIrCompressed(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportSendIrCompressed"));
        if (oldValue != val) {
            this.props.setProperty("exportSendIrCompressed", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportSendIrCompressed", oldValue, val);
        }
    }

    public void addExportSendIrCompressedChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportSendIrCompressed", listener);
    }

    public void removeExportSendIrCompressedChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportSendIrCompressed", listener);
    }

    public int getExportNoRepeats() {
        return Integer.parseInt(this.props.getProperty("exportNoRepeats"));
    }

    public void setExportNoRepeats(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("exportNoRepeats"));
        if (oldValue != n) {
            this.props.setProperty("exportNoRepeats", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("exportNoRepeats", oldValue, n);
        }
    }

    public void addExportNoRepeatsChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportNoRepeats", listener);
    }

    public void removeExportNoRepeatsChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportNoRepeats", listener);
    }

    public boolean getExportInquireDeviceData() {
        return Boolean.parseBoolean(this.props.getProperty("exportInquireDeviceData"));
    }

    public void setExportInquireDeviceData(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportInquireDeviceData"));
        if (oldValue != val) {
            this.props.setProperty("exportInquireDeviceData", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportInquireDeviceData", oldValue, val);
        }
    }

    public void addExportInquireDeviceDataChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportInquireDeviceData", listener);
    }

    public void removeExportInquireDeviceDataChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportInquireDeviceData", listener);
    }

    public String getExportCharsetName() {
        return this.props.getProperty("exportCharsetName");
    }

    public void setExportCharsetName(String str) {
        String oldValue = this.props.getProperty("exportCharsetName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("exportCharsetName", this.mkPathRelative(str));
            this.firePropertyChange("exportCharsetName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addExportCharsetNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportCharsetName", listener);
    }

    public void removeExportCharsetNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportCharsetName", listener);
    }

    public String getImportCharsetName() {
        return this.props.getProperty("importCharsetName");
    }

    public void setImportCharsetName(String str) {
        String oldValue = this.props.getProperty("importCharsetName");
        if (!oldValue.equals(str)) {
            this.props.setProperty("importCharsetName", this.mkPathRelative(str));
            this.firePropertyChange("importCharsetName", oldValue, str);
            this.needSave = true;
        }
    }

    public void addImportCharsetNameChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("importCharsetName", listener);
    }

    public void removeImportCharsetNameChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("importCharsetName", listener);
    }

    public boolean getTranslateProntoFont() {
        return Boolean.parseBoolean(this.props.getProperty("translateProntoFont"));
    }

    public void setTranslateProntoFont(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("translateProntoFont"));
        if (oldValue != val) {
            this.props.setProperty("translateProntoFont", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("translateProntoFont", oldValue, val);
        }
    }

    public void addTranslateProntoFontChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("translateProntoFont", listener);
    }

    public void removeTranslateProntoFontChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("translateProntoFont", listener);
    }

    public String getProtocolsIniPath() {
        return this.props.getProperty("protocolsIniPath");
    }

    public void setProtocolsIniPath(String str) {
        String oldValue = this.props.getProperty("protocolsIniPath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("protocolsIniPath", this.mkPathRelative(str));
            this.firePropertyChange("protocolsIniPath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addProtocolsIniPathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("protocolsIniPath", listener);
    }

    public void removeProtocolsIniPathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("protocolsIniPath", listener);
    }

    public String getIrpProtocolsIniPath() {
        return this.props.getProperty("irpProtocolsIniPath");
    }

    public void setIrpProtocolsIniPath(String str) {
        String oldValue = this.props.getProperty("irpProtocolsIniPath");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpProtocolsIniPath", this.mkPathRelative(str));
            this.firePropertyChange("irpProtocolsIniPath", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpProtocolsIniPathChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpProtocolsIniPath", listener);
    }

    public void removeIrpProtocolsIniPathChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpProtocolsIniPath", listener);
    }

    public String getCreatingUser() {
        return this.props.getProperty("creatingUser");
    }

    public void setCreatingUser(String str) {
        String oldValue = this.props.getProperty("creatingUser");
        if (!oldValue.equals(str)) {
            this.props.setProperty("creatingUser", this.mkPathRelative(str));
            this.firePropertyChange("creatingUser", oldValue, str);
            this.needSave = true;
        }
    }

    public void addCreatingUserChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("creatingUser", listener);
    }

    public void removeCreatingUserChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("creatingUser", listener);
    }

    public int getRawSeparatorIndex() {
        return Integer.parseInt(this.props.getProperty("rawSeparatorIndex"));
    }

    public void setRawSeparatorIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("rawSeparatorIndex"));
        if (oldValue != n) {
            this.props.setProperty("rawSeparatorIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("rawSeparatorIndex", oldValue, n);
        }
    }

    public void addRawSeparatorIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("rawSeparatorIndex", listener);
    }

    public void removeRawSeparatorIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("rawSeparatorIndex", listener);
    }

    public int getRawNameColumn() {
        return Integer.parseInt(this.props.getProperty("rawNameColumn"));
    }

    public void setRawNameColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("rawNameColumn"));
        if (oldValue != n) {
            this.props.setProperty("rawNameColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("rawNameColumn", oldValue, n);
        }
    }

    public void addRawNameColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("rawNameColumn", listener);
    }

    public void removeRawNameColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("rawNameColumn", listener);
    }

    public boolean getRawNameMultiColumn() {
        return Boolean.parseBoolean(this.props.getProperty("rawNameMultiColumn"));
    }

    public void setRawNameMultiColumn(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("rawNameMultiColumn"));
        if (oldValue != val) {
            this.props.setProperty("rawNameMultiColumn", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("rawNameMultiColumn", oldValue, val);
        }
    }

    public void addRawNameMultiColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("rawNameMultiColumn", listener);
    }

    public void removeRawNameMultiColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("rawNameMultiColumn", listener);
    }

    public boolean getParametrizedNameMultiColumn() {
        return Boolean.parseBoolean(this.props.getProperty("parametrizedNameMultiColumn"));
    }

    public void setParametrizedNameMultiColumn(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("parametrizedNameMultiColumn"));
        if (oldValue != val) {
            this.props.setProperty("parametrizedNameMultiColumn", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("parametrizedNameMultiColumn", oldValue, val);
        }
    }

    public void addParametrizedNameMultiColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("parametrizedNameMultiColumn", listener);
    }

    public void removeParametrizedNameMultiColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("parametrizedNameMultiColumn", listener);
    }

    public int getCodeColumn() {
        return Integer.parseInt(this.props.getProperty("codeColumn"));
    }

    public void setCodeColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("codeColumn"));
        if (oldValue != n) {
            this.props.setProperty("codeColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("codeColumn", oldValue, n);
        }
    }

    public void addCodeColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("codeColumn", listener);
    }

    public void removeCodeColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("codeColumn", listener);
    }

    public boolean getIncludeTail() {
        return Boolean.parseBoolean(this.props.getProperty("includeTail"));
    }

    public void setIncludeTail(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("includeTail"));
        if (oldValue != val) {
            this.props.setProperty("includeTail", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("includeTail", oldValue, val);
        }
    }

    public void addIncludeTailChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("includeTail", listener);
    }

    public void removeIncludeTailChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("includeTail", listener);
    }

    public boolean getParametrizedLearnIgnoreT() {
        return Boolean.parseBoolean(this.props.getProperty("parametrizedLearnIgnoreT"));
    }

    public void setParametrizedLearnIgnoreT(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("parametrizedLearnIgnoreT"));
        if (oldValue != val) {
            this.props.setProperty("parametrizedLearnIgnoreT", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("parametrizedLearnIgnoreT", oldValue, val);
        }
    }

    public void addParametrizedLearnIgnoreTChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("parametrizedLearnIgnoreT", listener);
    }

    public void removeParametrizedLearnIgnoreTChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("parametrizedLearnIgnoreT", listener);
    }

    public int getParametricNameColumn() {
        return Integer.parseInt(this.props.getProperty("parametricNameColumn"));
    }

    public void setParametricNameColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("parametricNameColumn"));
        if (oldValue != n) {
            this.props.setProperty("parametricNameColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("parametricNameColumn", oldValue, n);
        }
    }

    public void addParametricNameColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("parametricNameColumn", listener);
    }

    public void removeParametricNameColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("parametricNameColumn", listener);
    }

    public int getProtocolColumn() {
        return Integer.parseInt(this.props.getProperty("protocolColumn"));
    }

    public void setProtocolColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("protocolColumn"));
        if (oldValue != n) {
            this.props.setProperty("protocolColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("protocolColumn", oldValue, n);
        }
    }

    public void addProtocolColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("protocolColumn", listener);
    }

    public void removeProtocolColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("protocolColumn", listener);
    }

    public int getDColumn() {
        return Integer.parseInt(this.props.getProperty("dColumn"));
    }

    public void setDColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("dColumn"));
        if (oldValue != n) {
            this.props.setProperty("dColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("dColumn", oldValue, n);
        }
    }

    public void addDColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("dColumn", listener);
    }

    public void removeDColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("dColumn", listener);
    }

    public int getSColumn() {
        return Integer.parseInt(this.props.getProperty("sColumn"));
    }

    public void setSColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("sColumn"));
        if (oldValue != n) {
            this.props.setProperty("sColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("sColumn", oldValue, n);
        }
    }

    public void addSColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("sColumn", listener);
    }

    public void removeSColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("sColumn", listener);
    }

    public int getFColumn() {
        return Integer.parseInt(this.props.getProperty("fColumn"));
    }

    public void setFColumn(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("fColumn"));
        if (oldValue != n) {
            this.props.setProperty("fColumn", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("fColumn", oldValue, n);
        }
    }

    public void addFColumnChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("fColumn", listener);
    }

    public void removeFColumnChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("fColumn", listener);
    }

    public int getParametricNumberBaseIndex() {
        return Integer.parseInt(this.props.getProperty("parametricNumberBaseIndex"));
    }

    public void setParametricNumberBaseIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("parametricNumberBaseIndex"));
        if (oldValue != n) {
            this.props.setProperty("parametricNumberBaseIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("parametricNumberBaseIndex", oldValue, n);
        }
    }

    public void addParametricNumberBaseIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("parametricNumberBaseIndex", listener);
    }

    public void removeParametricNumberBaseIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("parametricNumberBaseIndex", listener);
    }

    public int getParametricSeparatorIndex() {
        return Integer.parseInt(this.props.getProperty("parametricSeparatorIndex"));
    }

    public void setParametricSeparatorIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("parametricSeparatorIndex"));
        if (oldValue != n) {
            this.props.setProperty("parametricSeparatorIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("parametricSeparatorIndex", oldValue, n);
        }
    }

    public void addParametricSeparatorIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("parametricSeparatorIndex", listener);
    }

    public void removeParametricSeparatorIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("parametricSeparatorIndex", listener);
    }

    public String getGirrSchemaLocation() {
        return this.props.getProperty("girrSchemaLocation");
    }

    public void setGirrSchemaLocation(String str) {
        String oldValue = this.props.getProperty("girrSchemaLocation");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girrSchemaLocation", this.mkPathRelative(str));
            this.firePropertyChange("girrSchemaLocation", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirrSchemaLocationChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrSchemaLocation", listener);
    }

    public void removeGirrSchemaLocationChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrSchemaLocation", listener);
    }

    public boolean getGirrValidate() {
        return Boolean.parseBoolean(this.props.getProperty("girrValidate"));
    }

    public void setGirrValidate(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("girrValidate"));
        if (oldValue != val) {
            this.props.setProperty("girrValidate", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("girrValidate", oldValue, val);
        }
    }

    public void addGirrValidateChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrValidate", listener);
    }

    public void removeGirrValidateChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrValidate", listener);
    }

    public String getIrpMasterCurrentProtocol() {
        return this.props.getProperty("irpMasterCurrentProtocol");
    }

    public void setIrpMasterCurrentProtocol(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentProtocol");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentProtocol", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentProtocol", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentProtocolChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentProtocol", listener);
    }

    public void removeIrpMasterCurrentProtocolChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentProtocol", listener);
    }

    public String getIrpMasterCurrentD() {
        return this.props.getProperty("irpMasterCurrentD");
    }

    public void setIrpMasterCurrentD(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentD");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentD", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentD", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentDChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentD", listener);
    }

    public void removeIrpMasterCurrentDChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentD", listener);
    }

    public String getIrpMasterCurrentS() {
        return this.props.getProperty("irpMasterCurrentS");
    }

    public void setIrpMasterCurrentS(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentS");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentS", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentS", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentSChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentS", listener);
    }

    public void removeIrpMasterCurrentSChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentS", listener);
    }

    public String getIrpMasterCurrentF() {
        return this.props.getProperty("irpMasterCurrentF");
    }

    public void setIrpMasterCurrentF(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentF");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentF", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentF", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentFChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentF", listener);
    }

    public void removeIrpMasterCurrentFChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentF", listener);
    }

    public String getIrpMasterCurrentT() {
        return this.props.getProperty("irpMasterCurrentT");
    }

    public void setIrpMasterCurrentT(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentT");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentT", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentT", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentTChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentT", listener);
    }

    public void removeIrpMasterCurrentTChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentT", listener);
    }

    public String getIrpMasterCurrentAdditionalParameters() {
        return this.props.getProperty("irpMasterCurrentAdditionalParameters");
    }

    public void setIrpMasterCurrentAdditionalParameters(String str) {
        String oldValue = this.props.getProperty("irpMasterCurrentAdditionalParameters");
        if (!oldValue.equals(str)) {
            this.props.setProperty("irpMasterCurrentAdditionalParameters", this.mkPathRelative(str));
            this.firePropertyChange("irpMasterCurrentAdditionalParameters", oldValue, str);
            this.needSave = true;
        }
    }

    public void addIrpMasterCurrentAdditionalParametersChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("irpMasterCurrentAdditionalParameters", listener);
    }

    public void removeIrpMasterCurrentAdditionalParametersChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("irpMasterCurrentAdditionalParameters", listener);
    }

    public boolean getExportAutomaticFilenames() {
        return Boolean.parseBoolean(this.props.getProperty("exportAutomaticFilenames"));
    }

    public void setExportAutomaticFilenames(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("exportAutomaticFilenames"));
        if (oldValue != val) {
            this.props.setProperty("exportAutomaticFilenames", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("exportAutomaticFilenames", oldValue, val);
        }
    }

    public void addExportAutomaticFilenamesChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("exportAutomaticFilenames", listener);
    }

    public void removeExportAutomaticFilenamesChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("exportAutomaticFilenames", listener);
    }

    public boolean getInvokeAnalyzer() {
        return Boolean.parseBoolean(this.props.getProperty("invokeAnalyzer"));
    }

    public void setInvokeAnalyzer(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("invokeAnalyzer"));
        if (oldValue != val) {
            this.props.setProperty("invokeAnalyzer", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("invokeAnalyzer", oldValue, val);
        }
    }

    public void addInvokeAnalyzerChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("invokeAnalyzer", listener);
    }

    public void removeInvokeAnalyzerChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("invokeAnalyzer", listener);
    }

    public boolean getGirrFatRaw() {
        return Boolean.parseBoolean(this.props.getProperty("girrFatRaw"));
    }

    public void setGirrFatRaw(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("girrFatRaw"));
        if (oldValue != val) {
            this.props.setProperty("girrFatRaw", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("girrFatRaw", oldValue, val);
        }
    }

    public void addGirrFatRawChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrFatRaw", listener);
    }

    public void removeGirrFatRawChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrFatRaw", listener);
    }

    public boolean getGirrCreateSchemaLocation() {
        return Boolean.parseBoolean(this.props.getProperty("girrCreateSchemaLocation"));
    }

    public void setGirrCreateSchemaLocation(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("girrCreateSchemaLocation"));
        if (oldValue != val) {
            this.props.setProperty("girrCreateSchemaLocation", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("girrCreateSchemaLocation", oldValue, val);
        }
    }

    public void addGirrCreateSchemaLocationChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrCreateSchemaLocation", listener);
    }

    public void removeGirrCreateSchemaLocationChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrCreateSchemaLocation", listener);
    }

    public String getGirrStyleSheetUrl() {
        return this.props.getProperty("girrStyleSheetUrl");
    }

    public void setGirrStyleSheetUrl(String str) {
        String oldValue = this.props.getProperty("girrStyleSheetUrl");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girrStyleSheetUrl", this.mkPathRelative(str));
            this.firePropertyChange("girrStyleSheetUrl", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirrStyleSheetUrlChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrStyleSheetUrl", listener);
    }

    public void removeGirrStyleSheetUrlChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrStyleSheetUrl", listener);
    }

    public String getGirrStyleSheetType() {
        return this.props.getProperty("girrStyleSheetType");
    }

    public void setGirrStyleSheetType(String str) {
        String oldValue = this.props.getProperty("girrStyleSheetType");
        if (!oldValue.equals(str)) {
            this.props.setProperty("girrStyleSheetType", this.mkPathRelative(str));
            this.firePropertyChange("girrStyleSheetType", oldValue, str);
            this.needSave = true;
        }
    }

    public void addGirrStyleSheetTypeChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("girrStyleSheetType", listener);
    }

    public void removeGirrStyleSheetTypeChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("girrStyleSheetType", listener);
    }

    public boolean getImportWaveDivideCarrier() {
        return Boolean.parseBoolean(this.props.getProperty("importWaveDivideCarrier"));
    }

    public void setImportWaveDivideCarrier(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("importWaveDivideCarrier"));
        if (oldValue != val) {
            this.props.setProperty("importWaveDivideCarrier", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("importWaveDivideCarrier", oldValue, val);
        }
    }

    public void addImportWaveDivideCarrierChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("importWaveDivideCarrier", listener);
    }

    public void removeImportWaveDivideCarrierChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("importWaveDivideCarrier", listener);
    }

    public boolean getImportOpensZipFiles() {
        return Boolean.parseBoolean(this.props.getProperty("importOpensZipFiles"));
    }

    public void setImportOpensZipFiles(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("importOpensZipFiles"));
        if (oldValue != val) {
            this.props.setProperty("importOpensZipFiles", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("importOpensZipFiles", oldValue, val);
        }
    }

    public void addImportOpensZipFilesChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("importOpensZipFiles", listener);
    }

    public void removeImportOpensZipFilesChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("importOpensZipFiles", listener);
    }

    public int getImportPaneSelectedIndex() {
        return Integer.parseInt(this.props.getProperty("importPaneSelectedIndex"));
    }

    public void setImportPaneSelectedIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("importPaneSelectedIndex"));
        if (oldValue != n) {
            this.props.setProperty("importPaneSelectedIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("importPaneSelectedIndex", oldValue, n);
        }
    }

    public void addImportPaneSelectedIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("importPaneSelectedIndex", listener);
    }

    public void removeImportPaneSelectedIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("importPaneSelectedIndex", listener);
    }

    public boolean getRejectLircCodeImports() {
        return Boolean.parseBoolean(this.props.getProperty("rejectLircCodeImports"));
    }

    public void setRejectLircCodeImports(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("rejectLircCodeImports"));
        if (oldValue != val) {
            this.props.setProperty("rejectLircCodeImports", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("rejectLircCodeImports", oldValue, val);
        }
    }

    public void addRejectLircCodeImportsChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("rejectLircCodeImports", listener);
    }

    public void removeRejectLircCodeImportsChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("rejectLircCodeImports", listener);
    }

    public int getProntoModelIndex() {
        return Integer.parseInt(this.props.getProperty("prontoModelIndex"));
    }

    public void setProntoModelIndex(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("prontoModelIndex"));
        if (oldValue != n) {
            this.props.setProperty("prontoModelIndex", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("prontoModelIndex", oldValue, n);
        }
    }

    public void addProntoModelIndexChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("prontoModelIndex", listener);
    }

    public void removeProntoModelIndexChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("prontoModelIndex", listener);
    }

    public int getProntoScreenSizeX() {
        return Integer.parseInt(this.props.getProperty("prontoScreenSizeX"));
    }

    public void setProntoScreenSizeX(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("prontoScreenSizeX"));
        if (oldValue != n) {
            this.props.setProperty("prontoScreenSizeX", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("prontoScreenSizeX", oldValue, n);
        }
    }

    public void addProntoScreenSizeXChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("prontoScreenSizeX", listener);
    }

    public void removeProntoScreenSizeXChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("prontoScreenSizeX", listener);
    }

    public int getProntoScreenSizeY() {
        return Integer.parseInt(this.props.getProperty("prontoScreenSizeY"));
    }

    public void setProntoScreenSizeY(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("prontoScreenSizeY"));
        if (oldValue != n) {
            this.props.setProperty("prontoScreenSizeY", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("prontoScreenSizeY", oldValue, n);
        }
    }

    public void addProntoScreenSizeYChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("prontoScreenSizeY", listener);
    }

    public void removeProntoScreenSizeYChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("prontoScreenSizeY", listener);
    }

    public int getProntoButtonSizeX() {
        return Integer.parseInt(this.props.getProperty("prontoButtonSizeX"));
    }

    public void setProntoButtonSizeX(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("prontoButtonSizeX"));
        if (oldValue != n) {
            this.props.setProperty("prontoButtonSizeX", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("prontoButtonSizeX", oldValue, n);
        }
    }

    public void addProntoButtonSizeXChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("prontoButtonSizeX", listener);
    }

    public void removeProntoButtonSizeXChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("prontoButtonSizeX", listener);
    }

    public int getProntoButtonSizeY() {
        return Integer.parseInt(this.props.getProperty("prontoButtonSizeY"));
    }

    public void setProntoButtonSizeY(int n) {
        int oldValue = Integer.parseInt(this.props.getProperty("prontoButtonSizeY"));
        if (oldValue != n) {
            this.props.setProperty("prontoButtonSizeY", Integer.toString(n));
            this.needSave = true;
            this.firePropertyChange("prontoButtonSizeY", oldValue, n);
        }
    }

    public void addProntoButtonSizeYChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("prontoButtonSizeY", listener);
    }

    public void removeProntoButtonSizeYChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("prontoButtonSizeY", listener);
    }

    public double getAbsoluteTolerance() {
        return Double.parseDouble(this.props.getProperty("absoluteTolerance"));
    }

    public void setAbsoluteTolerance(double n) {
        double oldValue = Double.parseDouble(this.props.getProperty("absoluteTolerance"));
        if (oldValue != n) {
            this.props.setProperty("absoluteTolerance", Double.toString(n));
            this.needSave = true;
            this.firePropertyChange("absoluteTolerance", oldValue, n);
        }
    }

    public void addAbsoluteToleranceChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("absoluteTolerance", listener);
    }

    public void removeAbsoluteToleranceChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("absoluteTolerance", listener);
    }

    public double getRelativeTolerance() {
        return Double.parseDouble(this.props.getProperty("relativeTolerance"));
    }

    public void setRelativeTolerance(double n) {
        double oldValue = Double.parseDouble(this.props.getProperty("relativeTolerance"));
        if (oldValue != n) {
            this.props.setProperty("relativeTolerance", Double.toString(n));
            this.needSave = true;
            this.firePropertyChange("relativeTolerance", oldValue, n);
        }
    }

    public void addRelativeToleranceChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("relativeTolerance", listener);
    }

    public void removeRelativeToleranceChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("relativeTolerance", listener);
    }

    public boolean getDontInquire4UnsavedParametricRemotes() {
        return Boolean.parseBoolean(this.props.getProperty("dontInquire4UnsavedParametricRemotes"));
    }

    public void setDontInquire4UnsavedParametricRemotes(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("dontInquire4UnsavedParametricRemotes"));
        if (oldValue != val) {
            this.props.setProperty("dontInquire4UnsavedParametricRemotes", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("dontInquire4UnsavedParametricRemotes", oldValue, val);
        }
    }

    public void addDontInquire4UnsavedParametricRemotesChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("dontInquire4UnsavedParametricRemotes", listener);
    }

    public void removeDontInquire4UnsavedParametricRemotesChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("dontInquire4UnsavedParametricRemotes", listener);
    }

    public boolean getDontInquire4UnsavedRawRemotes() {
        return Boolean.parseBoolean(this.props.getProperty("dontInquire4UnsavedRawRemotes"));
    }

    public void setDontInquire4UnsavedRawRemotes(boolean val) {
        boolean oldValue = Boolean.parseBoolean(this.props.getProperty("dontInquire4UnsavedRawRemotes"));
        if (oldValue != val) {
            this.props.setProperty("dontInquire4UnsavedRawRemotes", Boolean.toString(val));
            this.needSave = true;
            this.firePropertyChange("dontInquire4UnsavedRawRemotes", oldValue, val);
        }
    }

    public void addDontInquire4UnsavedRawRemotesChangeListener(IPropertyChangeListener listener) {
        this.addPropertyChangeListener("dontInquire4UnsavedRawRemotes", listener);
    }

    public void removeDontInquire4UnsavedRawRemotesChangeListener(IPropertyChangeListener listener) {
        this.removePropertyChangeListener("dontInquire4UnsavedRawRemotes", listener);
    }

    public static void main(String[] args) {
        String filename = args.length > 0 ? args[0] : null;
        try {
            Props p = new Props(filename);
            p.list();
            p.save();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static interface IPropertyChangeListener {
        public void propertyChange(String var1, Object var2, Object var3);
    }
}

