/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer;

import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.ExchangeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.irscrutinizer.NamedIrSignal;

public class RawIrSignal
extends NamedIrSignal {
    private static boolean generateCcf = true;
    private static boolean decode = true;
    private IrSignal irSignal;
    private String analyzerString;
    private DecodeIR.DecodedSignal[] decodes;

    public static void setGenerateCcf(boolean aGenerateCcf) {
        generateCcf = aGenerateCcf;
    }

    public static void setDecode(boolean aDecode) {
        decode = aDecode;
    }

    public RawIrSignal(IrSignal irSignal, String name, String comment, boolean invokeAnalyzer) {
        super(name, comment);
        this.setIrSignal(irSignal, invokeAnalyzer);
    }

    public RawIrSignal(Command command, boolean invokeAnalyzer) throws IrpMasterException {
        this(command.toIrSignal(), command.getName(), command.getComment(), invokeAnalyzer);
    }

    private void setIrSignal(IrSignal irSignal, boolean invokeAnalyzer) {
        this.irSignal = irSignal;
        this.decodes = DecodeIR.decode(irSignal);
        if (invokeAnalyzer && irSignal.getIntroLength() > 0) {
            this.analyzerString = ExchangeIR.newAnalyzer(irSignal).toString();
        }
    }

    public Command toCommand() {
        Command command = new Command(this.getName(), this.getComment(), this.irSignal);
        return command;
    }

    public IrSignal getIrSignal() {
        return this.irSignal;
    }

    public DecodeIR.DecodedSignal getDecode(int i) {
        return this.decodes[i];
    }

    public String getDecodeString() {
        return DecodeIR.DecodedSignal.toPrintString(this.decodes, false);
    }

    public int getNoDecodes() {
        return this.decodes.length;
    }

    public String getAnalyzerString() {
        return this.analyzerString;
    }

    public void setFrequency(double newFrequency, boolean invokeAnalyzer) {
        this.setIrSignal(new IrSignal(newFrequency, this.irSignal.getDutyCycle(), this.irSignal.getIntroSequence(), this.irSignal.getRepeatSequence(), this.irSignal.getEndingSequence()), invokeAnalyzer);
    }

    public void setIntroSequence(String str, boolean invokeAnalyzer) throws IncompatibleArgumentException {
        this.setIrSignal(new IrSignal(this.irSignal.getFrequency(), this.irSignal.getDutyCycle(), new IrSequence(str), this.irSignal.getRepeatSequence(), this.irSignal.getEndingSequence()), invokeAnalyzer);
    }

    public void setRepeatSequence(String str, boolean invokeAnalyzer) throws IncompatibleArgumentException {
        this.setIrSignal(new IrSignal(this.irSignal.getFrequency(), this.irSignal.getDutyCycle(), this.irSignal.getIntroSequence(), new IrSequence(str), this.irSignal.getEndingSequence()), invokeAnalyzer);
    }

    public void setEndingSequence(String str, boolean invokeAnalyzer) throws IncompatibleArgumentException {
        this.setIrSignal(new IrSignal(this.irSignal.getFrequency(), this.irSignal.getDutyCycle(), this.irSignal.getIntroSequence(), this.irSignal.getRepeatSequence(), new IrSequence(str)), invokeAnalyzer);
    }

    @Override
    public String csvString(String separator) {
        StringBuilder str = new StringBuilder(super.csvString(separator));
        str.append(this.irSignal.getFrequency()).append(separator);
        str.append(this.irSignal.getIntroSequence().toPrintString(true)).append(separator);
        str.append(this.irSignal.getRepeatSequence().toPrintString(true)).append(separator);
        str.append(this.irSignal.getEndingSequence().toPrintString(true)).append(separator);
        str.append(DecodeIR.DecodedSignal.toPrintString(this.decodes, true));
        str.append(separator);
        str.append(this.analyzerString).append(separator);
        return str.toString();
    }

    @Override
    public String toPrintString() {
        return this.csvString(", ");
    }

    public static class RawTableModel
    extends NamedIrSignal.LearnedIrSignalTableModel {
        public RawTableModel() {
            super(new CapturedIrSignalColumns());
        }

        public RawIrSignal getCapturedIrSignal(int row) {
            return this.validRow(row) ? (RawIrSignal)this.getValueAt(row, CapturedIrSignalColumns.posCapturedIrSignal) : null;
        }

        @Override
        public Command toCommand(int row) {
            RawIrSignal rir = this.getCapturedIrSignal(row);
            return rir.toCommand();
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
            boolean invokeAnalyzer = true;
            try {
                RawIrSignal rawIrSignal = this.getCapturedIrSignal(row);
                switch (column) {
                    case 2: {
                        rawIrSignal.setIntroSequence((String)this.getValueAt(row, column), invokeAnalyzer);
                        break;
                    }
                    case 3: {
                        rawIrSignal.setRepeatSequence((String)this.getValueAt(row, column), invokeAnalyzer);
                        break;
                    }
                    case 4: {
                        rawIrSignal.setEndingSequence((String)this.getValueAt(row, column), invokeAnalyzer);
                        break;
                    }
                    case 8: {
                        rawIrSignal.setValidated((Boolean)this.getValueAt(row, column));
                        break;
                    }
                    case 5: {
                        rawIrSignal.setName((String)this.getValueAt(row, column));
                        break;
                    }
                    case 9: {
                        rawIrSignal.setComment((String)this.getValueAt(row, column));
                        break;
                    }
                    case 10: {
                        rawIrSignal.setFrequency(((Integer)this.getValueAt(row, column)).intValue(), invokeAnalyzer);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            catch (NumberFormatException | IncompatibleArgumentException ex) {
                System.err.println(ex.getMessage());
            }
        }

        @Override
        public String toPrintString(int row) {
            RawIrSignal cir = this.getCapturedIrSignal(row);
            return super.toPrintString(row) + ": " + (cir != null ? cir.toPrintString() : "null");
        }

        @Override
        public String getType() {
            return "raw";
        }
    }

    public static class RawTableColumnModel
    extends NamedIrSignal.LearnedIrSignalTableColumnModel {
        public RawTableColumnModel() {
            super(new CapturedIrSignalColumns());
        }
    }

    private static class CapturedIrSignalColumns
    extends NamedIrSignal.AbstractColumnFunction {
        private static final int[] widths = new int[]{10, 40, 75, 75, 75, 75, 75, 75, 10, 75, 40, 10};
        private static final String[] columnNames = new String[]{"#", "Date", "Intro", "Repetition", "Ending", "Name", "Decode", "Analyze", "Ver.", "Comment", "Frequency", "C. IrSignal"};
        private static final Class<?>[] classes = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class, String.class, Integer.class, RawIrSignal.class};
        public static final int posNumber = 0;
        public static final int posDate = 1;
        public static final int posIntro = 2;
        public static final int posRepetition = 3;
        public static final int posEnding = 4;
        public static final int posName = 5;
        public static final int posVerified = 8;
        public static final int posComment = 9;
        public static final int posFrequency = 10;
        public static final int posCapturedIrSignal = columnNames.length - 1;

        CapturedIrSignalColumns() {
            super(columnNames, widths, classes, 1);
        }

        @Override
        public int getPosName() {
            return 5;
        }

        @Override
        public int getPosComment() {
            return 9;
        }

        @Override
        public int getPosIrSignal() {
            return posCapturedIrSignal;
        }

        @Override
        public boolean isEditable(int i) {
            return i > 4;
        }

        @Override
        public int getPosDate() {
            return 1;
        }

        @Override
        public int getPosNumber() {
            return 0;
        }

        @Override
        public Object[] toObjectArray(NamedIrSignal signal) {
            if (!RawIrSignal.class.isInstance(signal)) {
                throw new IllegalArgumentException();
            }
            return this.toObjectArray((RawIrSignal)signal);
        }

        public Object[] toObjectArray(RawIrSignal cir) {
            IrSignal irSignal = cir.getIrSignal();
            Object[] result = new Object[]{cir.getNumeral(), cir.getDate(), irSignal.getIntroSequence().toPrintString(true), irSignal.getRepeatSequence().toPrintString(true), irSignal.getEndingSequence().toPrintString(true), cir.getName(), cir.getDecodeString(), cir.getAnalyzerString(), cir.getValidated(), cir.getComment(), (int)irSignal.getFrequency(), cir, null};
            assert (result.length == columnNames.length);
            return result;
        }
    }
}

