/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.capturinghardware;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GlobalCacheIrSenderSelector;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardware;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardwareManager;
import org.harctoolbox.irscrutinizer.capturinghardware.ICapturingHardware;

public class CapturingGlobalCache
extends CapturingHardware<GlobalCache>
implements ICapturingHardware<GlobalCache> {
    private String initialIp;
    private final GlobalCacheIrSenderSelector globalCacheIrSenderSelector;
    private GlobalCache hardware;

    public CapturingGlobalCache(String hostname, final GlobalCacheIrSenderSelector globalCacheIrSenderSelector, JPanel panel, Props properties_, GuiUtils guiUtils, CapturingHardwareManager capturingHardwareManager) {
        super(panel, properties_, guiUtils, capturingHardwareManager);
        this.initialIp = hostname.isEmpty() ? null : hostname;
        this.globalCacheIrSenderSelector = globalCacheIrSenderSelector;
        globalCacheIrSenderSelector.setTimeout(this.properties.getCaptureBeginTimeout());
        this.properties.addCaptureBeginTimeoutChangeListener(new Props.IPropertyChangeListener(){

            @Override
            public void propertyChange(String name, Object oldValue, Object newValue) {
                globalCacheIrSenderSelector.setTimeout(CapturingGlobalCache.this.properties.getCaptureBeginTimeout());
            }
        });
        globalCacheIrSenderSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    CapturingGlobalCache.this.setup();
                    if (evt.getPropertyName().equals("PROP_IPNAME")) {
                        CapturingGlobalCache.this.properties.setGlobalCacheCaptureIpName((String)evt.getNewValue());
                    }
                }
                catch (IOException | HarcHardwareException ex) {
                    Logger.getLogger(CapturingGlobalCache.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    @Override
    public void setup() throws IOException, HarcHardwareException {
        this.hardware = null;
        try {
            if (this.initialIp != null) {
                this.globalCacheIrSenderSelector.setIpName(this.initialIp);
                this.initialIp = null;
            }
            this.hardware = this.globalCacheIrSenderSelector.getGlobalCache();
            if (this.hardware != null && !this.hardware.isValid()) {
                this.hardware.open();
            }
            this.selectMe();
        }
        catch (UnknownHostException ex) {
            this.guiUtils.error("Hostname \"" + this.initialIp + "\" does not resolve.");
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    @Override
    public String getName() {
        return "Global Cach\u00e9";
    }

    @Override
    public GlobalCache getCapturer() {
        return this.hardware;
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
    }
}

