/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.capturinghardware;

import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardwareManager;

public abstract class CapturingHardware<T extends ICapture & IHarcHardware>
implements ICapture {
    private final JPanel panel;
    protected Props properties;
    protected GuiUtils guiUtils;
    protected boolean verbose;
    private final CapturingHardwareManager capturingHardwareManager;

    protected CapturingHardware(JPanel panel, Props properties, GuiUtils guiUtils, CapturingHardwareManager capturingHardwareManager) {
        this.panel = panel;
        this.properties = properties;
        this.guiUtils = guiUtils;
        this.capturingHardwareManager = capturingHardwareManager;
        this.verbose = properties.getVerbose();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public abstract T getCapturer();

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void close() {
        try {
            if (this.getCapturer() != null && this.getCapturer().isValid()) {
                this.getCapturer().close();
            }
        }
        catch (IOException ex) {
            this.guiUtils.warning("Could not close present capture device: " + ex.getMessage());
        }
    }

    protected void setupHardwareCommonEnd() {
        if (this.verbose && this.getCapturer() != null) {
            try {
                this.guiUtils.info("Capture device: " + this.getCapturer().getClass().getSimpleName() + ", Hardware version: " + this.getCapturer().getVersion());
            }
            catch (IOException ex) {
                this.guiUtils.error(ex);
            }
        }
    }

    protected void selectMe() throws IOException, HarcHardwareException {
        this.capturingHardwareManager.select(this.getName());
    }

    @Override
    public ModulatedIrSequence capture() throws HarcHardwareException, IOException, IrpMasterException {
        return this.getCapturer().capture();
    }

    @Override
    public boolean stopCapture() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getVersion() throws IOException {
        return this.getCapturer().getVersion();
    }

    @Override
    public void setVerbosity(boolean verbosity) {
        this.getCapturer().setVerbosity(verbosity);
    }

    @Override
    public void setTimeout(int i) throws IOException {
        this.getCapturer().setTimeout(i);
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public void setBeginTimeout(int beginTimeout) throws IOException {
        this.getCapturer().setBeginTimeout(beginTimeout);
    }

    @Override
    public void setCaptureMaxSize(int captureMaxSize) {
        this.getCapturer().setCaptureMaxSize(captureMaxSize);
    }

    @Override
    public void setEndTimeout(int endTimeout) {
        this.getCapturer().setEndTimeout(endTimeout);
    }

    @Override
    public boolean isValid() {
        return this.getCapturer() != null && this.getCapturer().isValid();
    }

    public abstract String getName();
}

