/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.capturinghardware;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.capturinghardware.ICapturingHardware;

public class CapturingHardwareManager {
    private final LinkedHashMap<String, ICapturingHardware<?>> table;
    private final JTabbedPane tabbedPane;
    private JMenu menu = null;
    private final AbstractButton startButton;
    private ButtonGroup buttonGroup;
    private final Props properties;
    private ICapturingHardware<? extends IHarcHardware> selected;
    private boolean verbosity;
    private final GuiUtils guiUtils;

    public CapturingHardwareManager(GuiUtils guiUtils, Props properties, JTabbedPane tabbedPane, AbstractButton startButton) {
        this.guiUtils = guiUtils;
        this.properties = properties;
        this.tabbedPane = tabbedPane;
        this.startButton = startButton;
        this.startButton.setEnabled(false);
        this.table = new LinkedHashMap(16);
    }

    public Collection<ICapturingHardware<?>> getCapturingHardware() {
        return this.table.values();
    }

    public ICapturingHardware<?> getSelectedHardware() {
        return this.selected;
    }

    public ICapture getCapturer() {
        return this.selected.getCapturer();
    }

    public ICapturingHardware<?> getHardware(JPanel panel) {
        for (ICapturingHardware<?> hardware : this.table.values()) {
            if (hardware.getPanel() != panel) continue;
            return hardware;
        }
        return null;
    }

    public void add(ICapturingHardware<?> hardware) {
        if (this.table.containsKey(hardware.getName())) {
            throw new IllegalArgumentException(hardware.getName() + " already exists in map.");
        }
        this.table.put(hardware.getName(), hardware);
    }

    public String[] getNames() {
        return this.table.keySet().toArray(new String[this.table.size()]);
    }

    public ICapturingHardware<?> getCapturingHardware(String name) {
        return this.table.get(name);
    }

    public void setVerbosity(boolean verbosity) {
        this.verbosity = verbosity;
        this.selected.setVerbose(verbosity);
    }

    public boolean isReady() {
        return this.selected != null && this.selected.isValid();
    }

    public boolean hasSelection() {
        return this.selected != null;
    }

    public ModulatedIrSequence capture() throws IOException, HarcHardwareException, IrpMasterException {
        if (this.selected == null) {
            throw new IllegalArgumentException("No transitting hardware selected.");
        }
        return this.selected.capture();
    }

    private void createMenu(String selection) {
        this.menu = new JMenu();
        this.menu.setText("Capturing Hardware");
        this.menu.setToolTipText("Allows direct selection of capturing hardware");
        this.buttonGroup = new ButtonGroup();
        for (Map.Entry<String, ICapturingHardware<?>> kvp : this.table.entrySet()) {
            String name = kvp.getKey();
            final ICapturingHardware<?> hardware = kvp.getValue();
            JRadioButton menuItem = new JRadioButton(name);
            menuItem.setSelected(name.equals(selection));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        CapturingHardwareManager.this.select(hardware);
                    }
                    catch (IOException | HarcHardwareException ex) {
                        CapturingHardwareManager.this.guiUtils.error(ex);
                    }
                }
            });
            this.buttonGroup.add(menuItem);
            this.menu.add(menuItem);
        }
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.createMenu(this.selected != null ? this.selected.getName() : null);
        }
        return this.menu;
    }

    public void select(String name) throws IOException, HarcHardwareException {
        ICapturingHardware<?> hardware = this.table.get(name);
        if (hardware == null) {
            if (this.startButton != null) {
                this.startButton.setEnabled(false);
            }
            throw new IllegalArgumentException(name + " does not exist in map.");
        }
        this.select(hardware);
    }

    private void select(ICapturingHardware<?> hardware) throws IOException, HarcHardwareException {
        this.tabbedPane.setSelectedComponent(hardware.getPanel());
        if (this.selected == null) {
            this.selectDoWork(hardware);
        }
    }

    public void selectDoWork(String name) throws IOException, HarcHardwareException {
        ICapturingHardware<?> hardware = this.table.get(name);
        if (hardware == null) {
            if (this.startButton != null) {
                this.startButton.setEnabled(false);
            }
            throw new IllegalArgumentException(name + " does not exist in map.");
        }
        this.selectDoWork(hardware);
    }

    private void selectDoWork(ICapturingHardware<?> hardware) throws IOException, HarcHardwareException {
        if (this.selected != hardware) {
            this.selected = hardware;
            hardware.setup();
        }
        this.selected.setVerbose(this.verbosity);
        if (this.startButton != null) {
            this.startButton.setEnabled(true);
        }
        this.properties.setCaptureDevice(hardware.getName());
        if (this.menu != null) {
            for (Component component : this.menu.getMenuComponents()) {
                JRadioButton menuItem = (JRadioButton)component;
                menuItem.setSelected(menuItem.getText().equals(hardware.getName()));
            }
        }
    }

    public void close() {
        for (ICapturingHardware<?> hardware : this.table.values()) {
            hardware.close();
        }
    }
}

