/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.capturinghardware;

import java.io.IOException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.LircMode2;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardware;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardwareManager;
import org.harctoolbox.irscrutinizer.capturinghardware.ICapturingHardware;

public class CapturingLircMode2
extends CapturingHardware<LircMode2>
implements ICapturingHardware<LircMode2>,
IHarcHardware {
    private String commandName;
    private LircMode2 hardware;

    public CapturingLircMode2(String commandName, JPanel panel, Props properties, GuiUtils guiUtils, CapturingHardwareManager capturingHardwareManager) {
        super(panel, properties, guiUtils, capturingHardwareManager);
        this.commandName = commandName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
        if (this.hardware != null) {
            this.hardware.setCommand(commandName);
        }
        this.properties.setLircMode2Command(commandName);
    }

    @Override
    public void open() throws IOException {
        this.hardware.open();
    }

    @Override
    public void setup() {
        try {
            this.hardware = new LircMode2(this.commandName, this.properties.getVerbose(), this.properties.getCaptureBeginTimeout(), this.properties.getCaptureMaxSize(), this.properties.getCaptureEndTimeout());
            this.selectMe();
        }
        catch (IOException | HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
    }

    @Override
    public String getName() {
        return "LIRC Mode 2";
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public LircMode2 getCapturer() {
        return this.hardware;
    }
}

