/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.capturinghardware;

import gnu.io.NoSuchPortException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.SerialPortSimpleBean;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.IHarcHardware;
import org.harctoolbox.harchardware.ir.ICapture;
import org.harctoolbox.harchardware.ir.IrSerial;
import org.harctoolbox.irscrutinizer.Props;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardware;
import org.harctoolbox.irscrutinizer.capturinghardware.CapturingHardwareManager;
import org.harctoolbox.irscrutinizer.capturinghardware.ICapturingHardware;

public class CapturingSerial<T extends ICapture & IHarcHardware>
extends CapturingHardware<T>
implements ICapturingHardware<T>,
IHarcHardware {
    private SerialPortSimpleBean serialPortSimpleBean;
    private String portName = null;
    private int baudRate = -1;
    private Class<T> clazz;
    private T hardware;

    public CapturingSerial(Class<T> clazz, JPanel panel, SerialPortSimpleBean serialPortSimpleBean, Props properties_, GuiUtils guiUtils_, CapturingHardwareManager capturingHardwareManager) {
        super(panel, properties_, guiUtils_, capturingHardwareManager);
        this.serialPortSimpleBean = serialPortSimpleBean;
        this.baudRate = serialPortSimpleBean.getBaudRate();
        this.portName = serialPortSimpleBean.getPortName();
        this.clazz = clazz;
        serialPortSimpleBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                try {
                    switch (propertyName) {
                        case "PROP_BAUD": {
                            CapturingSerial.this.setup();
                            break;
                        }
                        case "PROP_PORTNAME": {
                            if (evt.getNewValue() == null) {
                                return;
                            }
                            CapturingSerial.this.setup();
                            break;
                        }
                        case "PROP_ISOPEN": {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Programmming error detected");
                        }
                    }
                }
                catch (IOException ex) {
                    CapturingSerial.this.guiUtils.error(ex);
                }
            }
        });
    }

    @Override
    public void setup() throws IOException {
        String newPort = this.serialPortSimpleBean.getPortName();
        int newBaud = this.serialPortSimpleBean.getBaudRate();
        if (this.hardware != null && (newPort == null || newPort.equals(this.portName)) && this.baudRate == newBaud) {
            return;
        }
        if (this.hardware != null) {
            this.hardware.close();
        }
        this.hardware = null;
        try {
            this.portName = newPort;
            if (IrSerial.class.isAssignableFrom(this.clazz)) {
                this.hardware = (ICapture)this.clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(newPort, newBaud, this.properties.getCaptureBeginTimeout(), this.properties.getCaptureMaxSize(), this.properties.getCaptureEndTimeout(), this.properties.getVerbose());
                this.baudRate = newBaud;
                Props.class.getMethod("set" + this.clazz.getSimpleName() + "CapturePortBaudRate", Integer.TYPE).invoke((Object)this.properties, newBaud);
            } else {
                this.hardware = (ICapture)this.clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE).newInstance(newPort, this.properties.getCaptureBeginTimeout(), this.properties.getCaptureMaxSize(), this.properties.getCaptureEndTimeout(), this.properties.getVerbose());
            }
            Props.class.getMethod("set" + this.clazz.getSimpleName() + "CapturePortName", String.class).invoke((Object)this.properties, this.portName);
            this.serialPortSimpleBean.setHardware((IHarcHardware)this.hardware);
            this.selectMe();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
        catch (InvocationTargetException ex) {
            if (NoSuchPortException.class.isInstance(ex.getCause())) {
                throw new IOException("No such port: " + newPort);
            }
            this.guiUtils.error(ex);
            this.guiUtils.error(ex.getCause().getMessage());
        }
    }

    @Override
    public String getName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public void open() throws HarcHardwareException, IOException {
        this.hardware.open();
    }

    @Override
    public void setDebug(int debug) {
    }

    @Override
    public T getCapturer() {
        return this.hardware;
    }
}

