/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.irscrutinizer.exporter.ICommandExporter;
import org.harctoolbox.irscrutinizer.exporter.RemoteSetExporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicCommandExportFormat
extends RemoteSetExporter
implements ICommandExporter {
    private final String formatName;
    private final String extension;
    private final boolean simpleSequence;
    private final boolean binary;
    private final Document xslt;

    public DynamicCommandExportFormat(Element el) {
        this.formatName = el.getAttribute("name");
        this.extension = el.getAttribute("extension");
        this.simpleSequence = Boolean.parseBoolean(el.getAttribute("simpleSequence"));
        this.binary = Boolean.parseBoolean(el.getAttribute("binary"));
        this.xslt = XmlUtils.newDocument(true);
        Node stylesheet = el.getElementsByTagName("xsl:stylesheet").item(0);
        this.xslt.appendChild(this.xslt.importNode(stylesheet, true));
    }

    @Override
    public boolean considersRepetitions() {
        return this.simpleSequence;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{this.formatName + " files (*." + this.extension + ")", this.extension}};
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getPreferredFileExtension() {
        return this.extension;
    }

    @Override
    public void export(RemoteSet remoteSet, String title, int noRepeats, File saveFile, String charsetName) throws IrpMasterException, IOException {
        Document document = remoteSet.xmlExportDocument(title, null, null, true, false, true, true, true);
        this.export(document, saveFile.getCanonicalPath(), charsetName, noRepeats);
    }

    void export(Document document, String fileName, String charsetName, int noRepeats) throws IOException, IrpMasterException {
        XmlExporter xmlExporter = new XmlExporter(document);
        try (PrintStream out = IrpUtils.getPrintSteam(fileName);){
            HashMap<String, String> parameters = new HashMap<String, String>(1);
            parameters.put("noRepeats", Integer.toString(noRepeats));
            xmlExporter.printDOM(out, this.xslt, parameters, this.binary, charsetName);
        }
    }
}

