/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.irscrutinizer.exporter.DynamicCommandExportFormat;
import org.harctoolbox.irscrutinizer.exporter.ICommandExporter;
import org.harctoolbox.irscrutinizer.exporter.IExporterFactory;
import org.harctoolbox.irscrutinizer.exporter.IRemoteSetExporter;
import org.harctoolbox.irscrutinizer.exporter.RemoteSetExporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DynamicRemoteSetExportFormat
extends RemoteSetExporter
implements IRemoteSetExporter {
    public static final String exportFormatNamespace = "http://www.harctoolbox.org/exportformats";
    private static JCommander argumentParser;
    private static final CommandLineArgs commandLineArgs;
    private final String formatName;
    private final String extension;
    private final boolean simpleSequence;
    private final boolean binary;
    private final boolean metadata;
    private final Document xslt;

    static HashMap<String, IExporterFactory> parseExportFormats(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(file);
        HashMap<String, IExporterFactory> result = new HashMap<String, IExporterFactory>(32);
        NodeList nl = doc.getElementsByTagNameNS(exportFormatNamespace, "exportformat");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            final ICommandExporter ef = (ICommandExporter)((Object)(el.getAttribute("multiSignal").equals("true") ? new DynamicRemoteSetExportFormat(el) : new DynamicCommandExportFormat(el)));
            result.put(ef.getFormatName(), new IExporterFactory(){

                @Override
                public ICommandExporter newExporter() {
                    return ef;
                }
            });
        }
        return result;
    }

    private static boolean isFat(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("flash");
        return nodeList.getLength() > 0;
    }

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(128);
        argumentParser.usage(str);
        (exitcode == 0 ? System.out : System.err).println(str);
        DynamicRemoteSetExportFormat.doExit(exitcode);
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("DynamicRemoteSetExportFormatVersion");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            DynamicRemoteSetExportFormat.usage(1);
        }
        if (commandLineArgs.helpRequested) {
            DynamicRemoteSetExportFormat.usage(0);
        }
        File configFile = new File(commandLineArgs.exportFormatsPathname);
        String formatName = commandLineArgs.formatName;
        File girrFile = new File((String)commandLineArgs.parameters.get(0));
        XmlExporter.setDebug(true);
        try {
            HashMap<String, IExporterFactory> exportFormats = DynamicRemoteSetExportFormat.parseExportFormats(configFile);
            IExporterFactory format = exportFormats.get(formatName);
            if (format == null) {
                System.err.println("No such export format ``" + formatName + "''");
                System.exit(2);
            }
            ICommandExporter exporter = format.newExporter();
            String outFileName = commandLineArgs.outputFile != null ? commandLineArgs.outputFile : girrFile.getCanonicalPath().replaceAll("\\.girr$", "." + exporter.getPreferredFileExtension());
            Document doc = XmlUtils.openXmlFile(girrFile);
            if (!DynamicRemoteSetExportFormat.isFat(doc)) {
                throw new IrpMasterException("Not a fat Girr file");
            }
            if (DynamicRemoteSetExportFormat.class.isInstance(exporter)) {
                ((DynamicRemoteSetExportFormat)exporter).export(doc, outFileName, commandLineArgs.encoding);
            } else {
                ((DynamicCommandExportFormat)exporter).export(doc, outFileName, commandLineArgs.encoding, commandLineArgs.noTimes);
            }
            System.err.println("Created " + outFileName);
        }
        catch (IOException | ParserConfigurationException | IrpMasterException | SAXException ex) {
            System.err.println(ex + ": " + ex.getMessage());
        }
    }

    private DynamicRemoteSetExportFormat(Element el) {
        this.formatName = el.getAttribute("name");
        this.extension = el.getAttribute("extension");
        this.simpleSequence = Boolean.parseBoolean(el.getAttribute("simpleSequence"));
        this.binary = Boolean.parseBoolean(el.getAttribute("binary"));
        this.metadata = Boolean.parseBoolean(el.getAttribute("metadata"));
        this.xslt = XmlUtils.newDocument(true);
        Node stylesheet = el.getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "stylesheet").item(0);
        this.xslt.appendChild(this.xslt.importNode(stylesheet, true));
    }

    @Override
    public boolean considersRepetitions() {
        return this.simpleSequence;
    }

    @Override
    public String[][] getFileExtensions() {
        return new String[][]{{this.formatName + " files (*." + this.extension + ")", this.extension}};
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getPreferredFileExtension() {
        return this.extension;
    }

    @Override
    public boolean supportsMetaData() {
        return this.metadata;
    }

    @Override
    public void export(RemoteSet remoteSet, String title, int count, File saveFile, String charsetName) throws IOException, IrpMasterException {
        this.export(remoteSet, title, count, saveFile.getCanonicalPath(), charsetName);
    }

    private void export(RemoteSet remoteSet, String title, int count, String fileName, String charsetName) throws IOException, IrpMasterException {
        Document document = remoteSet.xmlExportDocument(title, null, null, true, false, true, true, true);
        this.export(document, fileName, charsetName);
    }

    private void export(Document document, String fileName, String charsetName) throws IOException, IrpMasterException {
        XmlExporter xmlExporter = new XmlExporter(document);
        try (PrintStream out = IrpUtils.getPrintSteam(fileName);){
            xmlExporter.printDOM(out, this.xslt, this.standardParameter(charsetName), this.binary, charsetName);
        }
    }

    private HashMap<String, String> standardParameter(String charsetName) {
        HashMap<String, String> parameters = new HashMap<String, String>(8);
        parameters.put("encoding", "'" + charsetName + "'");
        parameters.put("creatingUser", "'" + this.creatingUser + "'");
        parameters.put("creatingTool", "'IrScrutinizer version 1.3'");
        parameters.put("creatingDate", "'" + new Date().toString() + "'");
        return parameters;
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-c", "--configuration"}, required=true, description="Pathname of exportformats.xml")
        private String exportFormatsPathname = null;
        @Parameter(names={"-e", "--encoding"}, description="Encoding of the generated document")
        private String encoding = "ISO-8859-1";
        @Parameter(names={"-f", "--format"}, required=true, description="Name of the desired export format")
        private String formatName = null;
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        private boolean helpRequested = false;
        @Parameter(names={"-n", "--notimes"}, description="Number of times to repeat a signal (only for CommandExport)")
        private int noTimes = 1;
        @Parameter(names={"-o", "--outputfile"}, description="Name of output file")
        private String outputFile = null;
        @Parameter(arity=1, description="Girr file to be transformed")
        private List<String> parameters = new ArrayList<String>(4);

        private CommandLineArgs() {
        }
    }
}

