/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.irscrutinizer.exporter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.xml.parsers.ParserConfigurationException;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.irscrutinizer.exporter.DynamicRemoteSetExportFormat;
import org.harctoolbox.irscrutinizer.exporter.IExporterFactory;
import org.xml.sax.SAXException;

public class ExportFormatManager {
    private final HashMap<String, IExporterFactory> exportFormats;
    private final IExportFormatSelector exportFormatSelector;
    private JMenu menu;
    private ButtonGroup buttonGroup;

    public ExportFormatManager(GuiUtils guiUtils, File exportFormatFile, IExportFormatSelector exportFormatSelector, IExporterFactory girrExporter, IExporterFactory waveExporter, IExporterFactory textExporter, IExporterFactory prontoExporter) throws ParserConfigurationException, SAXException, IOException {
        this.exportFormatSelector = exportFormatSelector;
        this.exportFormats = new LinkedHashMap<String, IExporterFactory>(32);
        this.exportFormats.put("Girr", girrExporter);
        this.exportFormats.put("Text", textExporter);
        this.exportFormats.put("Wave", waveExporter);
        this.exportFormats.put("ProntoClassic", prontoExporter);
        if (!exportFormatFile.exists()) {
            throw new FileNotFoundException(exportFormatFile + " does not exist.");
        }
        this.exportFormats.putAll(DynamicRemoteSetExportFormat.parseExportFormats(exportFormatFile));
    }

    public IExporterFactory get(String name) {
        return this.exportFormats.get(name);
    }

    private void createMenu(String selection) {
        this.menu = new JMenu();
        this.menu.setText("Export formats");
        this.menu.setToolTipText("Allows direct selection of export format");
        this.buttonGroup = new ButtonGroup();
        String[] stringArray = this.toArray();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String formatName;
            final String name = formatName = stringArray[i];
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(name);
            menuItem.setSelected(name.equals(selection));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExportFormatManager.this.exportFormatSelector.select(name);
                }
            });
            this.buttonGroup.add(menuItem);
            this.menu.add(menuItem);
        }
    }

    public void setMenuSelection(String format) {
        if (this.menu == null) {
            this.createMenu(format);
        }
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            JMenuItem item = this.menu.getItem(i);
            item.setSelected(item.getText().equals(format));
        }
    }

    public JMenu getMenu(String format) {
        this.createMenu(format);
        return this.menu;
    }

    public Set<String> getNames() {
        return this.exportFormats.keySet();
    }

    public String[] toArray() {
        ArrayList<String> list = new ArrayList<String>(this.exportFormats.keySet());
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list.toArray(new String[list.size()]);
    }

    public static interface IExportFormatSelector {
        public void select(String var1);
    }
}

